/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.gcube.common.authorization.control.AuthorizationAspect;
import org.gcube.common.authorization.control.annotations.AuthorizationControl;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.exception.MyAuthException;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.VRE;
import org.gcube.data.access.storagehub.handlers.VREManager;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="groups")
public class GroupManager {
    @Context
    ServletContext context;
    private static final String VREMANAGER_ROLE = "VRE-Manager";
    private static final String INFRASTRUCTURE_MANAGER_ROLE = "Infrastructure-Manager";
    private static final Logger log;
    @Inject
    RepositoryInitializer repository;
    @Inject
    VREManager vreManager;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    AuthorizationChecker authChecker;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        GroupManager.ajc$preClinit();
        log = LoggerFactory.getLogger(GroupManager.class);
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public List<String> getGroups() {
        InnerMethodName.instance.set("getGroups");
        JackrabbitSession session = null;
        ArrayList<String> groups = new ArrayList<String>();
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Iterator result = session.getUserManager().findAuthorizables((Query)new /* Unavailable Anonymous Inner Class!! */);
                while (result.hasNext()) {
                    Authorizable group = (Authorizable)result.next();
                    log.info("group {} found", (Object)group.getPrincipal().getName());
                    groups.add(group.getPrincipal().getName());
                }
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (session != null) {
                    session.logout();
                }
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return groups;
    }

    @POST
    @Path(value="")
    @Consumes(value={"multipart/form-data"})
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public String createGroup(@FormDataParam(value="group") String group, @FormDataParam(value="accessType") AccessType accessType, @FormDataParam(value="folderOwner") String folderOwner) {
        String string = group;
        AccessType accessType2 = accessType;
        String string2 = folderOwner;
        Object[] objectArray = new Object[]{string, accessType2, string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("createGroup");
        JackrabbitSession session = null;
        String groupId = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                UserManager usrManager = session.getUserManager();
                Group createdGroup = usrManager.createGroup(group);
                groupId = createdGroup.getID();
                this.createVreFolder(groupId, session, accessType != null ? accessType : AccessType.WRITE_OWNER, folderOwner);
                session.save();
            }
            catch (Exception e) {
                log.error("jcr error creating group {}", (Object)group, (Object)e);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)e));
                if (session != null) {
                    session.logout();
                }
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return groupId;
    }

    @DELETE
    @Path(value="{group}")
    @AuthorizationControl(allowedRoles={"Infrastructure-Manager"}, exception=MyAuthException.class)
    public String deleteGroup(@PathParam(value="group") String group) {
        String string = group;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("deleteGroup");
        JackrabbitSession session = null;
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                UserManager usrManager = session.getUserManager();
                try {
                    this.getVreFolderNode(session, group).removeSharedSet();
                }
                catch (Exception exception) {
                    log.warn("vreFolder {} not found, removing only the group", (Object)group);
                }
                Authorizable authorizable = usrManager.getAuthorizable(group);
                if (authorizable.isGroup()) {
                    authorizable.remove();
                }
                session.save();
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (session != null) {
                    session.logout();
                }
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return group;
    }

    public boolean isInfraManager() {
        return AuthorizationProvider.instance.get().getClient().getRoles().contains("Infrastructure-Manager");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Path(value="{id}/admins")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @AuthorizationControl(allowedRoles={"VRE-Manager", "Infrastructure-Manager"}, exception=MyAuthException.class)
    public void addAdmin(@PathParam(value="id") String groupId, @FormParam(value="userId") String userId) {
        String string = groupId;
        String string2 = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)string2);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("addAddmin");
        JackrabbitSession session = null;
        try {
            try {
                User authUser;
                if (!this.isInfraManager() && !this.isValidGroupForContext(groupId)) {
                    throw new UserNotAuthorizedException("only VREManager of the selected VRE can execute this operation");
                }
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                UserManager usrManager = session.getUserManager();
                Group group = (Group)usrManager.getAuthorizable(groupId);
                if (!group.isMember((Authorizable)(authUser = (User)usrManager.getAuthorizable(userId)))) {
                    throw new InvalidCallParameters("user " + userId + " is not in the group " + groupId);
                }
                Node vreFolder = this.getVreFolderNode(session, groupId);
                AccessControlManager acm = session.getAccessControlManager();
                JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)vreFolder.getPath());
                Privilege[] userPrivileges = new Privilege[]{acm.privilegeFromName(AccessType.ADMINISTRATOR.getValue())};
                Principal principal = AccessControlUtils.getPrincipal((Session)session, (String)userId);
                acls.addAccessControlEntry(principal, userPrivileges);
                acm.setPolicy(vreFolder.getPath(), (AccessControlPolicy)acls);
                session.save();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return;
                session.logout();
                return;
            }
            catch (RepositoryException re) {
                log.error("adding admin to VREFolder", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error adding admin to VREFolder", (Throwable)re));
                if (session == null) return;
                session.logout();
                return;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @Path(value="{id}/admins/{userId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @AuthorizationControl(allowedRoles={"VRE-Manager", "Infrastructure-Manager"}, exception=MyAuthException.class)
    public void removeAdmin(@PathParam(value="id") String groupId, @PathParam(value="userId") String userId) {
        String string = groupId;
        String string2 = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string, (Object)string2);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("removeAdmin");
        JackrabbitSession session = null;
        try {
            try {
                if (!this.isValidGroupForContext(groupId) && !this.isInfraManager()) {
                    throw new UserNotAuthorizedException("only VREManager of the selected VRE can execute this operation");
                }
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node vreFolder = this.getVreFolderNode(session, groupId);
                AccessControlManager acm = session.getAccessControlManager();
                JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)vreFolder.getPath());
                AccessControlEntry toRemove = null;
                AccessControlEntry[] accessControlEntryArray = acls.getAccessControlEntries();
                int n = accessControlEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AccessControlEntry acl = accessControlEntryArray[n2];
                    if (acl.getPrincipal().getName().equals(userId)) {
                        toRemove = acl;
                        break;
                    }
                    ++n2;
                }
                acls.removeAccessControlEntry(toRemove);
                acm.setPolicy(vreFolder.getPath(), (AccessControlPolicy)acls);
                session.save();
                return;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return;
                session.logout();
                return;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (session == null) return;
                session.logout();
                return;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="{groupId}/admins")
    @Produces(value={"application/json"})
    public List<String> getAdmins(@PathParam(value="groupId") String groupId) {
        InnerMethodName.instance.set("getAdmins");
        JackrabbitSession session = null;
        ArrayList<String> users = new ArrayList<String>();
        try {
            try {
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                VRE vreFolder = Utils.getVreFolderItemByGroupNameAndUser((Session)session, (String)groupId, (String)AuthorizationProvider.instance.get().getClient().getId(), (Node2ItemConverter)this.node2Item, (VREManager)this.vreManager, (List)Excludes.ALL);
                AccessControlManager acm = session.getAccessControlManager();
                Node node = session.getNodeByIdentifier(vreFolder.getVreFolder().getId());
                JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)node.getPath());
                AccessControlEntry[] accessControlEntryArray = acls.getAccessControlEntries();
                int n = accessControlEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AccessControlEntry acl = accessControlEntryArray[n2];
                    Privilege[] privilegeArray = acl.getPrivileges();
                    int n3 = privilegeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Privilege pr = privilegeArray[n4];
                        if (pr.getName().equals(AccessType.ADMINISTRATOR.getValue())) {
                            users.add(acl.getPrincipal().getName());
                        }
                        ++n4;
                    }
                    ++n2;
                }
                return users;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return users;
                session.logout();
                return users;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (session == null) return users;
                session.logout();
                return users;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PUT
    @Path(value="{id}/users")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @AuthorizationControl(allowedRoles={"VRE-Manager", "Infrastructure-Manager"}, exception=MyAuthException.class)
    public boolean addUserToGroup(@PathParam(value="id") String groupId, @FormParam(value="userId") String userId) {
        String string = groupId;
        String string2 = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)string2);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("addUserToGroup");
        JackrabbitSession session = null;
        boolean success = false;
        try {
            try {
                User user;
                if (!this.isValidGroupForContext(groupId) && !this.isInfraManager()) {
                    throw new UserNotAuthorizedException("only VREManager of the selected VRE can execute this operation");
                }
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                UserManager usrManager = session.getUserManager();
                Group group = (Group)usrManager.getAuthorizable(groupId);
                if (group.isMember((Authorizable)(user = (User)usrManager.getAuthorizable(userId)))) {
                    throw new InvalidCallParameters("user " + userId + " is already member of group " + groupId);
                }
                success = group.addMember((Authorizable)user);
                String folderName = group.getPrincipal().getName();
                Node folder = this.getVreFolderNode(session, folderName);
                String userPath = String.format("%s%s/%s", Utils.getWorkspacePath((String)user.getPrincipal().getName()).toPath(), "MySpecialFolders", folderName);
                log.debug("creating folder in user path {}", (Object)userPath);
                session.getWorkspace().clone(session.getWorkspace().getName(), folder.getPath(), userPath, false);
                session.save();
                return success;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return success;
                session.logout();
                return success;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (session == null) return success;
                session.logout();
                return success;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @DELETE
    @Path(value="{groupId}/users/{userId}")
    @AuthorizationControl(allowedRoles={"VRE-Manager", "Infrastructure-Manager"}, exception=MyAuthException.class)
    public boolean removeUserFromGroup(@PathParam(value="groupId") String groupId, @PathParam(value="userId") String userId) {
        String string = groupId;
        String string2 = userId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)string2);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("removeUserFromGroup");
        JackrabbitSession session = null;
        boolean success = false;
        try {
            try {
                User user;
                if (!this.isValidGroupForContext(groupId) && !this.isInfraManager()) {
                    throw new UserNotAuthorizedException("only VREManager of the selected VRE can execute this operation");
                }
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                UserManager usrManager = session.getUserManager();
                Group group = (Group)usrManager.getAuthorizable(groupId);
                if (!group.isMember((Authorizable)(user = (User)usrManager.getAuthorizable(userId)))) {
                    throw new InvalidCallParameters("user " + userId + " is not member of group " + groupId);
                }
                String folderName = group.getPrincipal().getName();
                Node folder = this.getVreFolderNode(session, folderName);
                NodeIterator ni = folder.getSharedSet();
                while (ni.hasNext()) {
                    Node node = ni.nextNode();
                    if (!node.getPath().startsWith(Utils.getWorkspacePath((String)user.getPrincipal().getName()).toPath())) continue;
                    node.removeShare();
                    break;
                }
                success = group.removeMember((Authorizable)user);
                session.save();
                return success;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return success;
                session.logout();
                return success;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (session == null) return success;
                session.logout();
                return success;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="{groupId}/users")
    @Produces(value={"application/json"})
    @AuthorizationControl(allowedRoles={"VRE-Manager"}, exception=MyAuthException.class)
    public List<String> getUsersOfGroup(@PathParam(value="groupId") String groupId) {
        String string = groupId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        AuthorizationAspect.aspectOf().before(joinPoint);
        InnerMethodName.instance.set("getUsersOfGroup");
        JackrabbitSession session = null;
        ArrayList<String> users = new ArrayList<String>();
        try {
            try {
                if (!this.isValidGroupForContext(groupId)) {
                    throw new UserNotAuthorizedException("only VREManager of the selected VRE can execute this operation");
                }
                session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                UserManager usrManager = session.getUserManager();
                Group group = (Group)usrManager.getAuthorizable(groupId);
                Iterator it = group.getMembers();
                while (it.hasNext()) {
                    Authorizable user = (Authorizable)it.next();
                    users.add(user.getPrincipal().getName());
                }
                return users;
            }
            catch (StorageHubException she) {
                log.error(she.getErrorMessage(), (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
                if (session == null) return users;
                session.logout();
                return users;
            }
            catch (RepositoryException re) {
                log.error("jcr error creating item", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
                if (session == null) return users;
                session.logout();
                return users;
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private void createVreFolder(String groupId, JackrabbitSession session, AccessType defaultAccessType, String owner) throws Exception {
        Node sharedRootNode = session.getNode("/Share");
        String name = groupId;
        String title = groupId.substring(groupId.lastIndexOf("-") + 1);
        Node folder = Utils.createFolderInternally((Session)session, (Node)sharedRootNode, (String)name, (String)("VREFolder for " + groupId), (boolean)false, (String)owner, null);
        folder.setPrimaryType("nthl:workspaceSharedItem");
        folder.setProperty(NodeProperty.IS_VRE_FOLDER.toString(), true);
        folder.setProperty(NodeProperty.TITLE.toString(), name);
        folder.setProperty(NodeProperty.DISPLAY_NAME.toString(), title);
        session.save();
        AccessControlManager acm = session.getAccessControlManager();
        JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)folder.getPath());
        Privilege[] usersPrivileges = new Privilege[]{acm.privilegeFromName(defaultAccessType.getValue())};
        acls.addAccessControlEntry(AccessControlUtils.getPrincipal((Session)session, (String)groupId), usersPrivileges);
        acm.setPolicy(folder.getPath(), (AccessControlPolicy)acls);
    }

    private Node getVreFolderNode(JackrabbitSession session, String name) throws InvalidItemException, RepositoryException {
        Node sharedRootNode = session.getNode("/Share");
        Node vreFolder = null;
        try {
            vreFolder = sharedRootNode.getNode(name);
        }
        catch (PathNotFoundException pathNotFoundException) {
            log.debug("is an old HL VRE");
        }
        NodeIterator nodes = sharedRootNode.getNodes();
        while (nodes.hasNext()) {
            Node node = nodes.nextNode();
            if (!node.getProperty(NodeProperty.TITLE.toString()).getString().equals(name)) continue;
            vreFolder = node;
            break;
        }
        if (vreFolder == null) {
            throw new InvalidItemException("vre folder not found");
        }
        return vreFolder;
    }

    private boolean isValidGroupForContext(String group) {
        String currentContext = ScopeProvider.instance.get();
        String expectedGroupId = currentContext.replace("/", "-").substring(1);
        return group.equals(expectedGroupId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("GroupManager.java", GroupManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createGroup", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String:org.gcube.common.storagehub.model.acls.AccessType:java.lang.String", "group:accessType:folderOwner", "", "java.lang.String"), 125);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteGroup", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String", "group", "", "java.lang.String"), 157);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addAdmin", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String:java.lang.String", "groupId:userId", "", "void"), 194);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeAdmin", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String:java.lang.String", "groupId:userId", "", "void"), 241);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addUserToGroup", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String:java.lang.String", "groupId:userId", "", "boolean"), 329);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeUserFromGroup", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String:java.lang.String", "groupId:userId", "", "boolean"), 377);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getUsersOfGroup", "org.gcube.data.access.storagehub.services.GroupManager", "java.lang.String", "groupId", "", "java.util.List"), 432);
    }
}

