/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.Query;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="groups")
public class GroupManager {
    @Context
    ServletContext context;
    private static final Logger log = LoggerFactory.getLogger(GroupManager.class);
    @Inject
    RepositoryInitializer repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public List<String> getGroups() {
        JackrabbitSession session = null;
        ArrayList<String> groups = new ArrayList<String>();
        try {
            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Iterator result = session.getUserManager().findAuthorizables((Query)new /* Unavailable Anonymous Inner Class!! */);
            while (result.hasNext()) {
                Authorizable group = (Authorizable)result.next();
                log.info("group {} found", (Object)group.getPrincipal().getName());
                groups.add(group.getPrincipal().getName());
            }
        }
        catch (Exception e) {
            log.error("jcr error getting groups", (Throwable)e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return groups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String createGroup(@FormParam(value="group") String group, @FormParam(value="accessType") AccessType accessType) {
        JackrabbitSession session = null;
        String groupId = null;
        try {
            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            UserManager usrManager = session.getUserManager();
            Group createdGroup = usrManager.createGroup(group);
            groupId = createdGroup.getID();
            this.createVreFolder(groupId, session, accessType != null ? accessType : AccessType.WRITE_OWNER);
            session.save();
        }
        catch (Exception e) {
            log.error("jcr error creating group {}", (Object)group, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return groupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{group}")
    public String deleteGroup(@PathParam(value="group") String group) {
        JackrabbitSession session = null;
        try {
            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            UserManager usrManager = session.getUserManager();
            try {
                Node sharedRootNode = session.getNode("/Share");
                sharedRootNode.getNode(group).removeSharedSet();
            }
            catch (Exception e) {
                log.warn("vreFolder {} not found, removing only the group", (Object)group);
            }
            Authorizable authorizable = usrManager.getAuthorizable(group);
            if (authorizable.isGroup()) {
                authorizable.remove();
            }
            session.save();
        }
        catch (Exception e) {
            log.error("jcr error getting users", (Throwable)e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public boolean addUserToGroup(@PathParam(value="id") String groupId, @FormParam(value="userId") String userId) {
        JackrabbitSession session = null;
        boolean success = false;
        try {
            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            UserManager usrManager = session.getUserManager();
            Group group = (Group)usrManager.getAuthorizable(groupId);
            User user = (User)usrManager.getAuthorizable(userId);
            success = group.addMember((Authorizable)user);
            String folderName = group.getPrincipal().getName();
            Node sharedRootNode = session.getNode("/Share");
            Node folder = sharedRootNode.getNode(folderName);
            String userPath = String.format("%s%s/%s", Utils.getWorkspacePath((String)user.getPrincipal().getName()).toPath(), "MySpecialFolders", folderName);
            log.debug("creating folder in user path {}", (Object)userPath);
            session.getWorkspace().clone(session.getWorkspace().getName(), folder.getPath(), userPath, false);
            session.save();
        }
        catch (Exception e) {
            log.error("jcr error adding user {} to group {}", new Object[]{userId, groupId, e});
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{groupId}/users/{userId}")
    public boolean removeUserFromGroup(@PathParam(value="groupId") String groupId, @PathParam(value="userId") String userId) {
        JackrabbitSession session = null;
        boolean success = false;
        try {
            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            UserManager usrManager = session.getUserManager();
            Group group = (Group)usrManager.getAuthorizable(groupId);
            User user = (User)usrManager.getAuthorizable(userId);
            String folderName = group.getPrincipal().getName();
            Node sharedRootNode = session.getNode("/Share");
            Node folder = sharedRootNode.getNode(folderName);
            NodeIterator ni = folder.getSharedSet();
            while (ni.hasNext()) {
                Node node = ni.nextNode();
                if (!node.getPath().startsWith(Utils.getWorkspacePath((String)user.getPrincipal().getName()).toPath())) continue;
                node.removeShare();
                break;
            }
            success = group.removeMember((Authorizable)user);
            session.save();
        }
        catch (Exception e) {
            log.error("jcr error adding user {} to group {}", new Object[]{userId, groupId, e});
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{groupId}/users")
    @Produces(value={"application/json"})
    public List<String> getUsersOfGroup(@PathParam(value="groupId") String groupId) {
        JackrabbitSession session = null;
        ArrayList<String> users = new ArrayList<String>();
        try {
            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            UserManager usrManager = session.getUserManager();
            Group group = (Group)usrManager.getAuthorizable(groupId);
            Iterator it = group.getMembers();
            while (it.hasNext()) {
                Authorizable user = (Authorizable)it.next();
                users.add(user.getPrincipal().getName());
            }
        }
        catch (Exception e) {
            log.error("jcr error getting users of group {}", (Object)groupId, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return users;
    }

    private void createVreFolder(String groupId, JackrabbitSession session, AccessType defaultAccessType) throws Exception {
        Node sharedRootNode = session.getNode("/Share");
        String name = groupId;
        String title = groupId.substring(groupId.lastIndexOf("-") + 1);
        Node folder = Utils.createFolderInternally((Session)session, (Node)sharedRootNode, (String)name, (String)("VREFolder for " + groupId), (boolean)false, (String)AuthorizationProvider.instance.get().getClient().getId(), null);
        folder.setPrimaryType("nthl:workspaceSharedItem");
        folder.setProperty(NodeProperty.IS_VRE_FOLDER.toString(), true);
        folder.setProperty(NodeProperty.TITLE.toString(), name);
        folder.setProperty(NodeProperty.DISPLAY_NAME.toString(), title);
        session.save();
        AccessControlManager acm = session.getAccessControlManager();
        JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)folder.getPath());
        Privilege[] adminPrivileges = new Privilege[]{acm.privilegeFromName(AccessType.ADMINISTRATOR.getValue())};
        acls.addAccessControlEntry(AccessControlUtils.getPrincipal((Session)session, (String)AuthorizationProvider.instance.get().getClient().getId()), adminPrivileges);
        Privilege[] usersPrivileges = new Privilege[]{acm.privilegeFromName(defaultAccessType.getValue())};
        acls.addAccessControlEntry(AccessControlUtils.getPrincipal((Session)session, (String)groupId), usersPrivileges);
        acm.setPolicy(folder.getPath(), (AccessControlPolicy)acls);
    }
}

