/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.gcube.common.authorization.library.AuthorizedTasks;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.GCubeItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.storages.MetaInfo;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.MultipleOutputStream;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.Node2ItemConverter;
import org.gcube.data.access.storagehub.handlers.StorageBackendHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandlerFactory;
import org.gcube.data.access.storagehub.services.ItemsCreator;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
public class ItemsCreator {
    private static final Logger log = LoggerFactory.getLogger(ItemsCreator.class);
    private static ExecutorService executor = Executors.newFixedThreadPool(100);
    @Context
    ServletContext context;
    @Inject
    RepositoryInitializer repository;
    @Inject
    ContentHandlerFactory contenthandlerFactory;
    @Inject
    VersionHandler versionHandler;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    AccountingHandler accountingHandler;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    StorageBackendHandler storageBackend;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}/create/FOLDER")
    public Response createFolder(@PathParam(value="id") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="hidden") boolean hidden) {
        InnerMethodName.instance.set("createItem(FOLDER)");
        log.info("create folder item called");
        Session ses = null;
        String toReturn = null;
        try {
            Node newNode;
            Node destination;
            String login = AuthorizationProvider.instance.get().getClient().getId();
            long start = System.currentTimeMillis();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            log.info("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
            try {
                destination = ses.getNodeByIdentifier(id);
            }
            catch (RepositoryException inf) {
                throw new IdNotFoundException(id);
            }
            if (!this.node2Item.checkNodeType(destination, FolderItem.class)) {
                throw new InvalidItemException("the destination item is not a folder");
            }
            this.authChecker.checkWriteAuthorizationControl(ses, destination.getIdentifier(), true);
            Utils.acquireLockWithWait((Session)ses, (String)destination.getPath(), (boolean)false, (String)login, (int)10);
            try {
                newNode = Utils.createFolderInternally((Session)ses, (Node)destination, (String)name, (String)description, (boolean)hidden, (String)login, (AccountingHandler)this.accountingHandler);
                ses.save();
            }
            finally {
                ses.getWorkspace().getLockManager().unlock(destination.getPath());
            }
            log.info("item with id {} correctly created", (Object)newNode.getIdentifier());
            toReturn = newNode.getIdentifier();
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        catch (RepositoryException re) {
            log.error("jcr error creating item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return Response.ok(toReturn).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{id}/create/URL")
    public Response createURL(@PathParam(value="id") String id, @FormParam(value="name") String name, @FormParam(value="description") String description, @FormParam(value="value") URL value) {
        InnerMethodName.instance.set("createItem(URL)");
        log.info("create url called");
        Session ses = null;
        String toReturn = null;
        try {
            Node newNode;
            Node destination;
            String login = AuthorizationProvider.instance.get().getClient().getId();
            long start = System.currentTimeMillis();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            log.info("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
            try {
                destination = ses.getNodeByIdentifier(id);
            }
            catch (RepositoryException inf) {
                throw new IdNotFoundException(id);
            }
            if (!this.node2Item.checkNodeType(destination, FolderItem.class)) {
                throw new InvalidItemException("the destination item is not a folder");
            }
            this.authChecker.checkWriteAuthorizationControl(ses, destination.getIdentifier(), true);
            Utils.acquireLockWithWait((Session)ses, (String)destination.getPath(), (boolean)false, (String)login, (int)10);
            try {
                newNode = Utils.createURLInternally((Session)ses, (Node)destination, (String)name, (URL)value, (String)description, (String)login, (AccountingHandler)this.accountingHandler);
                ses.save();
            }
            finally {
                ses.getWorkspace().getLockManager().unlock(destination.getPath());
            }
            log.info("item with id {} correctly created", (Object)newNode.getIdentifier());
            toReturn = newNode.getIdentifier();
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        catch (RepositoryException re) {
            log.error("jcr error creating item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return Response.ok(toReturn).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/json"})
    @Path(value="/{id}/create/GCUBEITEM")
    public String createGcubeItem(@PathParam(value="id") String id, GCubeItem item) {
        InnerMethodName.instance.set("createItem(GCUBEITEM)");
        log.info("create Gcube item called");
        Session ses = null;
        String toReturn = null;
        try {
            Node newNode;
            Node destination;
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            try {
                destination = ses.getNodeByIdentifier(id);
            }
            catch (ItemNotFoundException inf) {
                throw new IdNotFoundException(id);
            }
            if (!this.node2Item.checkNodeType(destination, FolderItem.class)) {
                throw new InvalidItemException("the destination item is not a folder");
            }
            this.authChecker.checkWriteAuthorizationControl(ses, destination.getIdentifier(), true);
            Utils.acquireLockWithWait((Session)ses, (String)destination.getPath(), (boolean)false, (String)login, (int)10);
            try {
                newNode = Utils.createGcubeItemInternally((Session)ses, (Node)destination, (String)item.getName(), (String)item.getDescription(), (String)login, (GCubeItem)item, (AccountingHandler)this.accountingHandler);
                ses.save();
            }
            finally {
                ses.getWorkspace().getLockManager().unlock(destination.getPath());
            }
            log.info("item with id {} correctly created", (Object)newNode.getIdentifier());
            toReturn = newNode.getIdentifier();
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        catch (RepositoryException re) {
            log.error("jcr error creating item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/{id}/create/FILE")
    public String createFileItem(@PathParam(value="id") String id, @FormDataParam(value="name") String name, @FormDataParam(value="description") String description, @FormDataParam(value="file") InputStream stream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        InnerMethodName.instance.set("createItem(FILE)");
        Session ses = null;
        String toReturn = null;
        try {
            if (name == null || name.trim().isEmpty() || description == null) {
                throw new InvalidCallParameters("name or description are null or empty");
            }
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Node destination = ses.getNodeByIdentifier(id);
            log.info("create file called with filename {} in dir {} ", (Object)name, (Object)destination.getPath());
            if (!this.node2Item.checkNodeType(destination, FolderItem.class)) {
                throw new InvalidItemException("the destination item is not a folder");
            }
            log.info("session: {}", (Object)ses.toString());
            Node newNode = this.createFileItemInternally(ses, destination, stream, name, description, login, true);
            ses.save();
            this.versionHandler.checkinContentNode(newNode, ses);
            log.info("file with id {} correctly created", (Object)newNode.getIdentifier());
            toReturn = newNode.getIdentifier();
        }
        catch (RepositoryException re) {
            log.error("jcr error creating file item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating file item", (Throwable)re));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        catch (Throwable e) {
            log.error("unexpected error", e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(e));
        }
        finally {
            if (ses != null && ses.isLive()) {
                log.info("session closed");
                ses.logout();
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node createFileItemInternally(Session ses, Node destinationNode, InputStream stream, String name, String description, String login, boolean withLock) throws RepositoryException, UserNotAuthorizedException, ItemLockedException, BackendGenericError {
        Node newNode;
        try {
            newNode = ses.getNode(Paths.append((org.gcube.common.storagehub.model.Path)Paths.getPath((String)destinationNode.getPath()), (String)name).toPath());
            this.authChecker.checkWriteAuthorizationControl(ses, newNode.getIdentifier(), false);
            AbstractFileItem item = this.fillItemWithContent(stream, name, description, destinationNode.getPath(), login);
            if (withLock) {
                try {
                    ses.getWorkspace().getLockManager().lock(newNode.getPath(), true, true, 0L, login);
                }
                catch (LockException le) {
                    throw new ItemLockedException((Throwable)le);
                }
            }
            try {
                this.versionHandler.checkoutContentNode(newNode, ses);
                log.trace("replacing content of class {}", item.getContent().getClass());
                this.item2Node.replaceContent(newNode, item, ItemAction.UPDATED);
                this.accountingHandler.createFileUpdated(item.getTitle(), ses, newNode, false);
                ses.save();
            }
            finally {
                if (withLock) {
                    ses.getWorkspace().getLockManager().unlock(newNode.getPath());
                }
            }
        }
        catch (PathNotFoundException pnf) {
            this.authChecker.checkWriteAuthorizationControl(ses, destinationNode.getIdentifier(), true);
            AbstractFileItem item = this.fillItemWithContent(stream, name, description, destinationNode.getPath(), login);
            if (withLock) {
                try {
                    log.debug("trying to acquire lock");
                    Utils.acquireLockWithWait((Session)ses, (String)destinationNode.getPath(), (boolean)false, (String)login, (int)10);
                }
                catch (LockException le) {
                    throw new ItemLockedException((Throwable)le);
                }
            }
            try {
                newNode = this.item2Node.getNode(destinationNode, (Item)item);
                ses.save();
            }
            finally {
                if (withLock) {
                    ses.getWorkspace().getLockManager().unlock(destinationNode.getPath());
                }
            }
            this.versionHandler.makeVersionableContent(newNode, ses);
            this.accountingHandler.createFolderAddObj(name, item.getClass().getSimpleName(), item.getContent().getMimeType(), ses, newNode, false);
        }
        return newNode;
    }

    private AbstractFileItem fillItemWithContent(InputStream stream, String name, String description, String path, String login) throws BackendGenericError {
        ContentHandler handler = this.getContentHandler(stream, name, path, login);
        AbstractFileItem item = handler.buildItem(name, description, login);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Path(value="/{id}/create/ARCHIVE")
    public String uploadArchive(@PathParam(value="id") String id, @FormDataParam(value="parentFolderName") String parentFolderName, @FormDataParam(value="file") InputStream stream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        InnerMethodName.instance.set("createItem(ARCHIVE)");
        Session ses = null;
        String toReturn = null;
        try {
            if (parentFolderName == null) {
                throw new InvalidCallParameters("new folder name is null");
            }
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Node destination = ses.getNodeByIdentifier(id);
            if (!this.node2Item.checkNodeType(destination, FolderItem.class)) {
                throw new InvalidItemException("the destination item is not a folder");
            }
            this.authChecker.checkWriteAuthorizationControl(ses, destination.getIdentifier(), true);
            try {
                ses.getWorkspace().getLockManager().lock(destination.getPath(), false, true, 0L, login);
            }
            catch (LockException le) {
                throw new ItemLockedException((Throwable)le);
            }
            Node parentDirectoryNode = Utils.createFolderInternally((Session)ses, (Node)destination, (String)parentFolderName, (String)"", (boolean)false, (String)login, (AccountingHandler)this.accountingHandler);
            try {
                if (ses.getWorkspace().getLockManager().isLocked(destination.getPath())) {
                    ses.getWorkspace().getLockManager().unlock(destination.getPath());
                }
            }
            catch (Throwable t) {
                log.warn("error unlocking {}", (Object)destination.getPath(), (Object)t);
            }
            HashSet<Node> fileNodes = new HashSet<Node>();
            HashMap<String, Node> directoryNodeMap = new HashMap<String, Node>();
            try (ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(stream, 65536));){
                ArchiveEntry entry;
                while ((entry = input.getNextEntry()) != null) {
                    Node parentNode;
                    String parentPath;
                    String name;
                    String entirePath;
                    if (entry.isDirectory()) {
                        Node createdNode;
                        entirePath = entry.getName();
                        name = entirePath.replaceAll("(.*/)*(.*)/", "$2");
                        parentPath = entirePath.replaceAll("(.*/)*(.*)/", "$1");
                        log.debug("creating directory with entire path {}, name {}, parentPath {} ", new Object[]{entirePath, name, parentPath});
                        if (parentPath.isEmpty()) {
                            createdNode = Utils.createFolderInternally((Session)ses, (Node)parentDirectoryNode, (String)name, (String)"", (boolean)false, (String)login, (AccountingHandler)this.accountingHandler);
                        } else {
                            parentNode = (Node)directoryNodeMap.get(parentPath);
                            createdNode = Utils.createFolderInternally((Session)ses, (Node)parentNode, (String)name, (String)"", (boolean)false, (String)login, (AccountingHandler)this.accountingHandler);
                        }
                        directoryNodeMap.put(entirePath, createdNode);
                        continue;
                    }
                    try {
                        entirePath = entry.getName();
                        name = entirePath.replaceAll("(.*/)*(.*)", "$2");
                        parentPath = entirePath.replaceAll("(.*/)*(.*)", "$1");
                        log.debug("creating file with entire path {}, name {}, parentPath {} ", new Object[]{entirePath, name, parentPath});
                        Node fileNode = null;
                        if (parentPath.isEmpty()) {
                            fileNode = this.createFileItemInternally(ses, parentDirectoryNode, (InputStream)input, name, "", login, false);
                        } else {
                            parentNode = (Node)directoryNodeMap.get(parentPath);
                            fileNode = this.createFileItemInternally(ses, parentNode, (InputStream)input, name, "", login, false);
                        }
                        fileNodes.add(fileNode);
                    }
                    catch (Exception e) {
                        log.warn("error getting file {}", (Object)entry.getName(), (Object)e);
                    }
                }
            }
            ses.save();
            for (Node node : fileNodes) {
                this.versionHandler.checkinContentNode(node, ses);
            }
            toReturn = parentDirectoryNode.getIdentifier();
        }
        catch (IOException | RepositoryException | ArchiveException re) {
            log.error("jcr error extracting archive", re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error extracting archive", re));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return toReturn;
    }

    private ContentHandler getContentHandler(InputStream stream, String name, String path, String login) throws BackendGenericError {
        MultipleOutputStream mos;
        try {
            mos = new MultipleOutputStream(stream, 2);
        }
        catch (IOException e) {
            throw new BackendGenericError((Throwable)e);
        }
        1 mimeTypeDector = new /* Unavailable Anonymous Inner Class!! */;
        2 uploader = new /* Unavailable Anonymous Inner Class!! */;
        Future detectorF = executor.submit(AuthorizedTasks.bind((Callable)mimeTypeDector));
        Future uploaderF = executor.submit(AuthorizedTasks.bind((Callable)uploader));
        long start = System.currentTimeMillis();
        log.debug("TIMING: writing the stream - start");
        try {
            mos.startWriting();
            log.debug("TIMING: writing the stream - finished in {}", (Object)(System.currentTimeMillis() - start));
            ContentHandler handler = (ContentHandler)detectorF.get();
            MetaInfo info = (MetaInfo)uploaderF.get();
            handler.getContent().setData("jcr:content");
            handler.getContent().setStorageId(info.getStorageId());
            handler.getContent().setSize(Long.valueOf(info.getSize()));
            handler.getContent().setRemotePath(info.getRemotePath());
            return handler;
        }
        catch (Exception e) {
            throw new BackendGenericError((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

