/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.data.access.storagehub.handlers.VRE;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VREManager {
    private static final Logger logger = LoggerFactory.getLogger(VREManager.class);
    private Map<String, VRE> vreMap = new HashMap();
    @Inject
    RepositoryInitializer repository;
    ExecutorService executor = Executors.newFixedThreadPool(5);
    SimpleCredentials credentials;

    @Inject
    public VREManager(ServletContext context) {
        this.credentials = new SimpleCredentials(context.getInitParameter("admin-username"), context.getInitParameter("admin-pwd").toCharArray());
    }

    public synchronized VRE getVRE(String completeName) {
        logger.trace("requesting VRE {}", (Object)completeName);
        if (this.vreMap.containsKey(completeName)) {
            return (VRE)this.vreMap.get(completeName);
        }
        return null;
    }

    public synchronized VRE putVRE(Item vreFolder) {
        logger.trace("inserting VRE {}", (Object)vreFolder.getTitle());
        if (this.vreMap.containsKey(vreFolder.getTitle())) {
            throw new RuntimeException("something went wrong (vre already present in the map)");
        }
        VRE toReturn = new VRE(vreFolder, this.repository.getRepository(), this.credentials, this.executor);
        this.vreMap.put(vreFolder.getTitle(), toReturn);
        return toReturn;
    }
}

