/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.data.access.storagehub.handlers.VREQueryRetriever;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VRE {
    private static final Logger logger = LoggerFactory.getLogger(VRE.class);
    private Item vreFolder;
    private Future<List<Item>> result;
    private VREQueryRetriever vreQueryRetriever;
    private ExecutorService executor;

    public VRE(Item item, Repository repository, SimpleCredentials credentials, ExecutorService executor) {
        this.vreFolder = item;
        this.executor = executor;
        this.vreQueryRetriever = new VREQueryRetriever(repository, (Credentials)credentials, this.vreFolder);
        this.result = executor.submit(this.vreQueryRetriever);
    }

    public Item getVreFolder() {
        return this.vreFolder;
    }

    public synchronized List<Item> getRecents() throws BackendGenericError {
        try {
            logger.trace("getting recents");
            if (this.result.isDone()) {
                this.result = this.executor.submit(this.vreQueryRetriever);
            }
            return (List)this.result.get();
        }
        catch (Exception ee) {
            throw new BackendGenericError((Throwable)ee);
        }
    }
}

