/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import org.gcube.common.authorization.library.AuthorizedTasks;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.ItemLockedException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.Item2NodeConverter;
import org.gcube.data.access.storagehub.handlers.StorageBackendHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TrashHandler {
    private static Logger log = LoggerFactory.getLogger(TrashHandler.class);
    @Inject
    VersionHandler versionHandler;
    @Inject
    AccountingHandler accountingHandler;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    Item2NodeConverter item2Node;
    @Inject
    StorageBackendHandler storageHandler;

    public void removeNodes(Session ses, List<Item> itemsToDelete) throws RepositoryException, StorageHubException {
        log.debug("defnitively removing nodes with ids {}", itemsToDelete);
        for (Item item : itemsToDelete) {
            this.removeNodesInternally(ses, item);
        }
    }

    private void removeNodesInternally(Session ses, Item itemToDelete) throws RepositoryException, StorageHubException {
        try {
            HashSet contentIdsToDelete = new HashSet();
            Node nodeToDelete = ses.getNodeByIdentifier(itemToDelete.getId());
            if (itemToDelete instanceof TrashItem) {
                List trashChildren = Utils.getItemList((Node)nodeToDelete, (List)Excludes.GET_ONLY_CONTENT, null, (boolean)true, null);
                for (Item itemContentToRetrieve : trashChildren) {
                    Utils.getAllContentIds((Session)ses, contentIdsToDelete, (Item)itemContentToRetrieve, (VersionHandler)this.versionHandler);
                }
            } else {
                Utils.getAllContentIds((Session)ses, contentIdsToDelete, (Item)itemToDelete, (VersionHandler)this.versionHandler);
            }
            nodeToDelete.remove();
            log.debug("content ids to remove are {}", contentIdsToDelete);
            String user = AuthorizationProvider.instance.get().getClient().getId();
            Runnable deleteFromStorageRunnable = AuthorizedTasks.bind((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            new Thread(deleteFromStorageRunnable).start();
            ses.save();
        }
        catch (LockException e) {
            throw new ItemLockedException("the selected node or his parent is locked", (Throwable)e);
        }
        catch (Exception e) {
            throw new BackendGenericError("error permanetly deleting items", (Throwable)e);
        }
    }

    public void moveToTrash(Session ses, Node nodeToDelete, Item item) throws RepositoryException, BackendGenericError {
        log.debug("moving node {} to trash ", (Object)item.getId());
        Node trashFolder = ses.getNode(Paths.append((Path)Utils.getWorkspacePath(), (String)"Trash").toPath());
        String login = AuthorizationProvider.instance.get().getClient().getId();
        try {
            ses.getWorkspace().getLockManager().lock(trashFolder.getPath(), true, true, 0L, login);
            ses.getWorkspace().getLockManager().lock(nodeToDelete.getPath(), true, true, 0L, login);
            log.debug("preparing thrash item");
            TrashItem trashItem = new TrashItem();
            trashItem.setDeletedBy(AuthorizationProvider.instance.get().getClient().getId());
            trashItem.setDeletedFrom(nodeToDelete.getParent().getPath());
            Calendar now = Calendar.getInstance();
            trashItem.setDeletedTime(now);
            trashItem.setHidden(false);
            trashItem.setLastAction(ItemAction.CREATED);
            trashItem.setDescription("trash item of node " + nodeToDelete.getPath());
            trashItem.setParentId(trashFolder.getIdentifier());
            trashItem.setParentPath(trashFolder.getPath());
            trashItem.setTitle(item.getTitle());
            trashItem.setName(item.getId());
            trashItem.setOriginalParentId(nodeToDelete.getParent().getIdentifier());
            trashItem.setOwner(item.getOwner());
            trashItem.setLastModificationTime(item.getLastModificationTime());
            trashItem.setLastModifiedBy(item.getLastModifiedBy());
            trashItem.setLenght(0L);
            if (item instanceof FolderItem) {
                trashItem.setFolder(true);
            } else if (item instanceof AbstractFileItem) {
                AbstractFileItem file = (AbstractFileItem)item;
                if (file.getContent() != null) {
                    trashItem.setMimeType(file.getContent().getMimeType());
                    trashItem.setLenght(file.getContent().getSize().longValue());
                }
                trashItem.setFolder(false);
            }
            log.debug("creating node");
            Node newTrashItemNode = this.item2Node.getNode(trashFolder, (Item)trashItem);
            ses.save();
            log.debug("calling jcr move");
            ses.getWorkspace().move(nodeToDelete.getPath(), Paths.append((Path)Paths.getPath((String)newTrashItemNode.getPath()), (String)nodeToDelete.getName()).toPath());
            String mimetype = null;
            if (item instanceof AbstractFileItem) {
                if (((AbstractFileItem)item).getContent() != null) {
                    mimetype = ((AbstractFileItem)item).getContent().getMimeType();
                } else {
                    log.warn("the AbstractFileItem with id {} has no content (check it!!)", (Object)item.getId());
                }
            }
            this.accountingHandler.createFolderRemoveObj(item.getName(), item.getClass().getSimpleName(), mimetype, ses, ses.getNodeByIdentifier(item.getParentId()), true);
        }
        catch (Throwable t) {
            log.error("error exceuting move to trash", t);
            throw new BackendGenericError(t);
        }
        finally {
            ses.getWorkspace().getLockManager().unlock(nodeToDelete.getPath());
            ses.getWorkspace().getLockManager().unlock(trashFolder.getPath());
        }
    }

    public String restoreItem(Session ses, TrashItem item) throws RepositoryException, BackendGenericError, UserNotAuthorizedException {
        log.debug("restoring node from trash");
        String login = AuthorizationProvider.instance.get().getClient().getId();
        Node originalParent = ses.getNodeByIdentifier(item.getOriginalParentId());
        this.authChecker.checkWriteAuthorizationControl(ses, originalParent.getIdentifier(), false);
        ses.getWorkspace().getLockManager().lock(originalParent.getPath(), true, true, 0L, login);
        List items = Utils.getItemList((Node)ses.getNodeByIdentifier(item.getId()), (List)Excludes.ALL, null, (boolean)false, null);
        if (items.size() != 1) {
            log.warn("a problem occurred restoring item from trash");
            throw new BackendGenericError("An error occurred on trash item");
        }
        Item itemToMove = (Item)items.get(0);
        String newNodePath = Paths.append((Path)Paths.getPath((String)originalParent.getPath()), (String)itemToMove.getName()).toPath();
        ses.move(itemToMove.getPath(), newNodePath);
        Utils.setPropertyOnChangeNode((Node)ses.getNode(newNodePath), (String)login, (ItemAction)ItemAction.MOVED);
        ses.removeItem(item.getPath());
        ses.save();
        return ses.getNode(newNodePath).getIdentifier();
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

