/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.UnshareHandler;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@javax.ws.rs.Path(value="users")
public class UserManager {
    @Context
    ServletContext context;
    private static final Logger log = LoggerFactory.getLogger(UserManager.class);
    @Inject
    RepositoryInitializer repository;
    @Inject
    UnshareHandler unshareHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @javax.ws.rs.Path(value="")
    @Produces(value={"application/json"})
    public List<String> getUsers() {
        JackrabbitSession session = null;
        ArrayList<String> users = new ArrayList<String>();
        try {
            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Iterator result = session.getUserManager().findAuthorizables((org.apache.jackrabbit.api.security.user.Query)new /* Unavailable Anonymous Inner Class!! */);
            while (result.hasNext()) {
                Authorizable user = (Authorizable)result.next();
                log.debug("user {} found", (Object)user.getPrincipal().getName());
                users.add(user.getPrincipal().getName());
            }
        }
        catch (Exception e) {
            log.error("jcr error getting users", (Throwable)e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @javax.ws.rs.Path(value="")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public String createUser(@FormParam(value="user") String user, @FormParam(value="password") String password) {
        JackrabbitSession session = null;
        String userId = null;
        try {
            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            org.apache.jackrabbit.api.security.user.UserManager usrManager = session.getUserManager();
            User createdUser = usrManager.createUser(user, password);
            userId = createdUser.getID();
            Node homeNode = session.getNode("/Home");
            Node userHome = homeNode.addNode(user, "nthl:home");
            Node workspaceFolder = Utils.createFolderInternally((Session)session, (Node)userHome, (String)"Workspace", (String)("workspace of " + user), (boolean)false, (String)user, null);
            Utils.createFolderInternally((Session)session, (Node)workspaceFolder, (String)"Trash", (String)("trash of " + user), (boolean)false, (String)user, null);
            Utils.createFolderInternally((Session)session, (Node)workspaceFolder, (String)"MySpecialFolders", (String)("special folder container of " + user), (boolean)false, (String)user, null);
            session.save();
        }
        catch (Exception e) {
            log.error("jcr error creating user {}", (Object)user, (Object)e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @javax.ws.rs.Path(value="{id}")
    public String deleteUser(@PathParam(value="id") String id) {
        JackrabbitSession session = null;
        String userId = null;
        try {
            session = (JackrabbitSession)this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            org.apache.jackrabbit.api.security.user.UserManager usrManager = session.getUserManager();
            Path path = Utils.getWorkspacePath((String)id);
            String sql2Query = String.format("SELECT * FROM [nthl:workspaceSharedItem] AS node WHERE ISDESCENDANTNODE('%s')", path.toPath());
            log.info("query sent is {}", (Object)sql2Query);
            Query jcrQuery = session.getWorkspace().getQueryManager().createQuery(sql2Query, "JCR-SQL2");
            QueryResult result = jcrQuery.execute();
            NodeIterator nodeIt = result.getNodes();
            while (nodeIt.hasNext()) {
                Node rNode = nodeIt.nextNode();
                String title = rNode.hasProperty(NodeProperty.TITLE.toString()) ? rNode.getProperty(NodeProperty.TITLE.toString()).getString() : "unknown";
                log.debug("removing sharing for folder name {} with title {} and path {} ", new Object[]{rNode.getName(), title, rNode.getPath()});
                this.unshareHandler.unshare((Session)session, Collections.singleton(id), rNode, id);
            }
            Authorizable authorizable = usrManager.getAuthorizable((Principal)new PrincipalImpl(id));
            if (!authorizable.isGroup()) {
                log.info("removing user {}", (Object)id);
                authorizable.remove();
            }
            session.save();
        }
        catch (Exception e) {
            log.error("jcr error getting users", (Throwable)e);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)e));
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return userId;
    }
}

