/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.security.Principal;
import java.util.ArrayList;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Excludes;
import org.gcube.common.storagehub.model.acls.ACL;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.types.ACLList;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.Node2ItemConverter;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
public class ACLManager {
    private static final Logger log = LoggerFactory.getLogger(ACLManager.class);
    @Inject
    RepositoryInitializer repository;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    Node2ItemConverter node2Item;
    @Inject
    AuthorizationChecker authChecker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}/acls")
    @Produces(value={"application/json"})
    public ACLList getACL() {
        InnerMethodName.instance.set("getACLById");
        Session ses = null;
        ArrayList<ACL> acls = new ArrayList<ACL>();
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            String path = ses.getNodeByIdentifier(this.id).getPath();
            log.info("checking acces for path {}", (Object)path);
            JackrabbitAccessControlList accessControlList = AccessControlUtils.getAccessControlList((Session)ses, (String)path);
            for (AccessControlEntry aclEntry : accessControlList.getAccessControlEntries()) {
                ACL acl = new ACL();
                acl.setPricipal(aclEntry.getPrincipal().getName());
                ArrayList<AccessType> types = new ArrayList<AccessType>();
                for (Privilege priv : aclEntry.getPrivileges()) {
                    try {
                        types.add(AccessType.fromValue((String)priv.getName()));
                    }
                    catch (Exception e) {
                        log.warn(priv.getName() + " cannot be mapped to AccessTypes", (Throwable)e);
                    }
                }
                acl.setAccessTypes(types);
                acls.add(acl);
            }
        }
        catch (RepositoryException re) {
            log.error("jcr error getting acl", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting acl", (Throwable)re));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ACLList(acls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"multipart/form-data"})
    @Path(value="{id}/acls")
    public void setACL(@FormDataParam(value="user") String user, @FormDataParam(value="access") AccessType accessType) {
        InnerMethodName.instance.set("setACLById");
        Session ses = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Node node = ses.getNodeByIdentifier(this.id);
            Item item = this.node2Item.getItem(node, Excludes.ALL);
            if (!(item instanceof SharedFolder)) {
                throw new InvalidItemException("the item is not a shared folder");
            }
            if (item.getOwner().equals(user)) {
                throw new UserNotAuthorizedException("owner acl cannot be changed");
            }
            this.authChecker.checkAdministratorControl(ses, (SharedFolder)item);
            SharedFolder folder = (SharedFolder)item;
            if (folder.isVreFolder()) {
                User authUser;
                String groupId;
                if (accessType != AccessType.ADMINISTRATOR) {
                    throw new InvalidCallParameters("acls in vreFolder cannot be changed, only new admin can be set");
                }
                UserManager usrManager = ((JackrabbitSession)ses).getUserManager();
                Group group = (Group)usrManager.getAuthorizable(groupId = folder.getTitle());
                if (!group.isMember((Authorizable)(authUser = (User)usrManager.getAuthorizable(user)))) {
                    throw new InvalidCallParameters("user " + user + " is not in the group " + groupId);
                }
                String path = node.getPath();
                AccessControlManager acm = ses.getAccessControlManager();
                JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)path);
                Privilege[] userPrivileges = new Privilege[]{acm.privilegeFromName(AccessType.ADMINISTRATOR.getValue())};
                Principal principal = AccessControlUtils.getPrincipal((Session)ses, (String)user);
                acls.addAccessControlEntry(principal, userPrivileges);
                acm.setPolicy(path, (AccessControlPolicy)acls);
                ses.save();
            } else {
                NodeIterator sharedSet = node.getSharedSet();
                boolean found = false;
                while (sharedSet.hasNext() && !found) {
                    Node current = sharedSet.nextNode();
                    if (!current.getPath().startsWith(Utils.getWorkspacePath((String)user).toPath())) continue;
                    found = true;
                }
                if (!found) {
                    throw new InvalidCallParameters("shared folder with id " + item.getId() + " is not shared with user " + user);
                }
                String path = node.getPath();
                AccessControlManager acm = ses.getAccessControlManager();
                JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)path);
                Privilege[] userPrivileges = new Privilege[]{acm.privilegeFromName(accessType.getValue())};
                AccessControlEntry aceToDelete = null;
                Principal principal = AccessControlUtils.getPrincipal((Session)ses, (String)user);
                for (AccessControlEntry ace : acls.getAccessControlEntries()) {
                    if (!ace.getPrincipal().equals(principal)) continue;
                    aceToDelete = ace;
                    break;
                }
                if (aceToDelete != null) {
                    acls.removeAccessControlEntry(aceToDelete);
                }
                acls.addAccessControlEntry(principal, userPrivileges);
                acm.setPolicy(path, (AccessControlPolicy)acls);
                ses.save();
            }
        }
        catch (RepositoryException re) {
            log.error("jcr error extracting archive", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error setting acl", (Throwable)re));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}/acls/write")
    public Boolean canWriteInto() {
        InnerMethodName.instance.set("canWriteIntoFolder");
        Session ses = null;
        Boolean canWrite = false;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Node node = ses.getNodeByIdentifier(this.id);
            Item item = this.node2Item.getItem(node, Excludes.ALL);
            if (!(item instanceof FolderItem)) {
                throw new InvalidItemException("this method can be applied only to folder");
            }
            try {
                this.authChecker.checkWriteAuthorizationControl(ses, this.id, true);
            }
            catch (UserNotAuthorizedException e) {
                Boolean bl = false;
                if (ses != null) {
                    ses.logout();
                }
                return bl;
            }
            Boolean bl = true;
            return bl;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting acl", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error getting acl", (Throwable)re));
        }
        catch (StorageHubException she) {
            log.error(she.getErrorMessage(), (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she), (Response.Status)Response.Status.fromStatusCode((int)she.getStatus()));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return canWrite;
    }
}

