/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.IdNotFoundException;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.MetaInfo;
import org.gcube.data.access.storagehub.MultipleOutputStream;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.ItemHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandlerFactory;
import org.gcube.data.access.storagehub.services.ItemsCreator;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
public class ItemsCreator {
    private static final Logger log = LoggerFactory.getLogger(ItemsCreator.class);
    private static ExecutorService executor = Executors.newFixedThreadPool(100);
    @Context
    ServletContext context;
    @Inject
    RepositoryInitializer repository;
    @Inject
    ContentHandlerFactory contenthandlerFactory;
    @Inject
    VersionHandler versionHandler;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    AccountingHandler accountingHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/create/FOLDER")
    public String createItem(@PathParam(value="id") String id, @FormDataParam(value="name") String name, @FormDataParam(value="description") String description) {
        InnerMethodName.instance.set("createItem(FOLDER)");
        log.info("create generic item called");
        Session ses = null;
        Item destinationItem = null;
        String toReturn = null;
        try {
            Node destination;
            String login = AuthorizationProvider.instance.get().getClient().getId();
            long start = System.currentTimeMillis();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            log.info("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
            try {
                destination = ses.getNodeByIdentifier(id);
            }
            catch (ItemNotFoundException inf) {
                throw new IdNotFoundException(id);
            }
            try {
                destinationItem = ItemHandler.getItem((Node)destination, Arrays.asList("hl:accounting", "jcr:content"));
            }
            catch (Exception e) {
                throw new InvalidItemException("item with id " + id + " cannot be mapped", (Throwable)e);
            }
            if (!(destinationItem instanceof FolderItem)) {
                throw new InvalidItemException("the destination item is not a folder");
            }
            this.authChecker.checkWriteAuthorizationControl(ses, destinationItem.getId(), true);
            ses.getWorkspace().getLockManager().lock(destinationItem.getPath(), true, true, 0L, login);
            Node newNode = this.createFolderInternally(ses, destinationItem, destination, name, description, login);
            ses.save();
            log.info("item with id {} correctly created", (Object)newNode.getIdentifier());
            toReturn = newNode.getIdentifier();
        }
        catch (StorageHubException she) {
            log.error("error creating item", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        catch (RepositoryException re) {
            log.error("jcr error creating item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating item", (Throwable)re));
        }
        finally {
            if (ses != null) {
                if (destinationItem != null) {
                    try {
                        if (ses.getWorkspace().getLockManager().isLocked(destinationItem.getPath())) {
                            ses.getWorkspace().getLockManager().unlock(destinationItem.getPath());
                        }
                    }
                    catch (Throwable t) {
                        log.warn("error unlocking {}", (Object)destinationItem.getPath(), (Object)t);
                    }
                }
                ses.logout();
            }
        }
        return toReturn;
    }

    private Node createFolderInternally(Session ses, Item destinationItem, Node destinationNode, String name, String description, String login) {
        FolderItem item = new FolderItem();
        Calendar now = Calendar.getInstance();
        item.setName(name);
        item.setTitle(name);
        item.setDescription(description);
        item.setHidden(false);
        item.setLastAction(ItemAction.CREATED);
        item.setLastModificationTime(now);
        item.setLastModifiedBy(login);
        item.setOwner(login);
        Node newNode = ItemHandler.createNodeFromItem((Session)ses, (Node)destinationNode, (Item)item);
        this.accountingHandler.createFolderAddObj(name, item.getClass().getSimpleName(), null, ses, newNode, false);
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/create/FILE")
    public String createFileItem(@PathParam(value="id") String id, @FormDataParam(value="name") String name, @FormDataParam(value="description") String description, @FormDataParam(value="file") InputStream stream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        InnerMethodName.instance.set("createItem(FILE)");
        Session ses = null;
        Item destinationItem = null;
        String toReturn = null;
        try {
            if (name == null || name.trim().isEmpty() || description == null) {
                throw new InvalidCallParameters("name or description are null");
            }
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Node destination = ses.getNodeByIdentifier(id);
            log.info("create file called with filename {} in dir {} ", (Object)name, (Object)destination.getPath());
            destinationItem = ItemHandler.getItem((Node)destination, Arrays.asList("hl:accounting", "jcr:content"));
            if (!(destinationItem instanceof FolderItem)) {
                throw new InvalidCallParameters("destination item must be a directory");
            }
            ses.getWorkspace().getLockManager().lock(destinationItem.getPath(), true, true, 0L, login);
            Node newNode = this.createFileItemInternally(ses, destinationItem, destination, stream, name, description, login);
            ses.save();
            this.versionHandler.checkinContentNode(newNode, ses);
            log.info("file with id {} correctly created", (Object)newNode.getIdentifier());
        }
        catch (RepositoryException re) {
            log.error("jcr error creating file item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error creating file item", (Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error creating file item", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                if (destinationItem != null) {
                    try {
                        if (ses.getWorkspace().getLockManager().isLocked(destinationItem.getPath())) {
                            ses.getWorkspace().getLockManager().unlock(destinationItem.getPath());
                        }
                    }
                    catch (Throwable t) {
                        log.warn("error unlocking {}", (Object)destinationItem.getPath(), (Object)t);
                    }
                }
                ses.logout();
            }
        }
        return toReturn;
    }

    private Node createFileItemInternally(Session ses, Item destinationItem, Node destinationNode, InputStream stream, String name, String description, String login) throws RepositoryException, UserNotAuthorizedException, BackendGenericError {
        Node newNode;
        ContentHandler handler = this.getContentHandler(stream, name, destinationItem.getPath());
        AbstractFileItem item = handler.buildItem(name, description, login);
        log.debug("item prepared, fulfilling content");
        log.debug("content prepared");
        try {
            newNode = ses.getNode(Paths.append((org.gcube.common.storagehub.model.Path)Paths.getPath((String)destinationItem.getPath()), (String)name).toPath());
            this.authChecker.checkWriteAuthorizationControl(ses, newNode.getIdentifier(), false);
            this.versionHandler.checkoutContentNode(newNode, ses);
            log.trace("replacing content of class {}", item.getContent().getClass());
            ItemHandler.replaceContent((Session)ses, (Node)newNode, (AbstractFileItem)item);
        }
        catch (PathNotFoundException pnf) {
            log.info("creating new node");
            this.authChecker.checkWriteAuthorizationControl(ses, destinationItem.getId(), true);
            newNode = ItemHandler.createNodeFromItem((Session)ses, (Node)destinationNode, (Item)item);
            this.versionHandler.makeVersionableContent(newNode, ses);
        }
        this.accountingHandler.createFolderAddObj(name, item.getClass().getSimpleName(), item.getContent().getMimeType(), ses, newNode, false);
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/create/ARCHIVE")
    public String uploadArchive(@PathParam(value="id") String id, @FormDataParam(value="parentFolderName") String parentFolderName, @FormDataParam(value="file") InputStream stream, @FormDataParam(value="file") FormDataContentDisposition fileDetail) {
        InnerMethodName.instance.set("createItem(ARCHIVE)");
        Session ses = null;
        Item destinationItem = null;
        String toReturn = null;
        try {
            if (parentFolderName == null) {
                throw new InvalidCallParameters("new folder name is null");
            }
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Node destination = ses.getNodeByIdentifier(id);
            destinationItem = ItemHandler.getItem((Node)destination, Arrays.asList("hl:accounting", "jcr:content"));
            if (!(destinationItem instanceof FolderItem)) {
                throw new InvalidCallParameters("destination item must be a directory");
            }
            this.authChecker.checkWriteAuthorizationControl(ses, destinationItem.getId(), true);
            ses.getWorkspace().getLockManager().lock(destination.getPath(), true, true, 0L, login);
            Node parentDirectoryNode = null;
            try {
                parentDirectoryNode = this.createFolderInternally(ses, destinationItem, destination, parentFolderName, "", login);
                HashSet<Node> fileNodes = new HashSet<Node>();
                HashMap<String, Node> directoryNodeMap = new HashMap<String, Node>();
                try (ArchiveInputStream input = new ArchiveStreamFactory().createArchiveInputStream((InputStream)new BufferedInputStream(stream, 65536));){
                    ArchiveEntry entry;
                    while ((entry = input.getNextEntry()) != null) {
                        Item parentItem;
                        Node parentNode;
                        String parentPath;
                        String name;
                        String entirePath;
                        if (entry.isDirectory()) {
                            Node createdNode;
                            entirePath = entry.getName();
                            name = entirePath.replaceAll("(.*/)*(.*)/", "$2");
                            parentPath = entirePath.replaceAll("(.*/)*(.*)/", "$1");
                            log.trace("creating directory with entire path {}, name {}, parentPath {} ", new Object[]{entirePath, name, parentPath});
                            if (parentPath.isEmpty()) {
                                createdNode = this.createFolderInternally(ses, ItemHandler.getItem((Node)parentDirectoryNode, Collections.emptyList()), parentDirectoryNode, name, "", login);
                            } else {
                                parentNode = (Node)directoryNodeMap.get(parentPath);
                                parentItem = ItemHandler.getItem((Node)parentNode, Collections.emptyList());
                                createdNode = this.createFolderInternally(ses, parentItem, parentNode, name, "", login);
                            }
                            directoryNodeMap.put(entirePath, createdNode);
                            continue;
                        }
                        try {
                            entirePath = entry.getName();
                            name = entirePath.replaceAll("(.*/)*(.*)", "$2");
                            parentPath = entirePath.replaceAll("(.*/)*(.*)", "$1");
                            log.trace("creating file with entire path {}, name {}, parentPath {} ", new Object[]{entirePath, name, parentPath});
                            Node fileNode = null;
                            if (parentPath.isEmpty()) {
                                fileNode = this.createFileItemInternally(ses, ItemHandler.getItem((Node)parentDirectoryNode, Collections.emptyList()), parentDirectoryNode, (InputStream)input, name, "", login);
                            } else {
                                parentNode = (Node)directoryNodeMap.get(parentPath);
                                parentItem = ItemHandler.getItem((Node)parentNode, Collections.emptyList());
                                fileNode = this.createFileItemInternally(ses, parentItem, parentNode, (InputStream)input, name, "", login);
                            }
                            fileNodes.add(fileNode);
                        }
                        catch (Exception e) {
                            log.warn("error getting file {}", (Object)entry.getName(), (Object)e);
                        }
                    }
                }
                ses.save();
                for (Node node : fileNodes) {
                    this.versionHandler.checkinContentNode(node, ses);
                }
                toReturn = parentDirectoryNode.getIdentifier();
            }
            finally {
                try {
                    if (ses.getWorkspace().getLockManager().isLocked(destination.getPath())) {
                        ses.getWorkspace().getLockManager().unlock(destination.getPath());
                    }
                }
                catch (Throwable t) {
                    log.warn("error unlocking {}", (Object)destination.getPath(), (Object)t);
                }
            }
        }
        catch (IOException | RepositoryException | ArchiveException re) {
            log.error("jcr error extracting archive", re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error extracting archive", re));
        }
        catch (StorageHubException she) {
            log.error("error creating file item", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return toReturn;
    }

    private ContentHandler getContentHandler(InputStream stream, String name, String path) throws BackendGenericError {
        MultipleOutputStream mos;
        try {
            mos = new MultipleOutputStream(stream, 2);
        }
        catch (IOException e) {
            throw new BackendGenericError((Throwable)e);
        }
        1 mimeTypeDector = new /* Unavailable Anonymous Inner Class!! */;
        2 uploader = new /* Unavailable Anonymous Inner Class!! */;
        Future detectorF = executor.submit(mimeTypeDector);
        Future uploaderF = executor.submit(uploader);
        long start = System.currentTimeMillis();
        log.debug("TIMING: writing the stream - start");
        try {
            mos.startWriting();
            log.debug("TIMING: writing the stream - finished in {}", (Object)(System.currentTimeMillis() - start));
            ContentHandler handler = (ContentHandler)detectorF.get();
            MetaInfo info = (MetaInfo)uploaderF.get();
            handler.getContent().setData("jcr:content");
            handler.getContent().setStorageId(info.getStorageId());
            handler.getContent().setSize(Long.valueOf(info.getSize()));
            handler.getContent().setRemotePath(info.getRemotePath());
            return handler;
        }
        catch (Exception e) {
            throw new BackendGenericError((Throwable)e);
        }
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

