/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.items.VreFolder;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.SingleFileStreamingOutput;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.ItemHandler;
import org.gcube.data.access.storagehub.handlers.TrashHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.services.ItemsManager;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
public class ItemsManager {
    private static final Logger log = LoggerFactory.getLogger(ItemsManager.class);
    @Inject
    RepositoryInitializer repository;
    @Inject
    AccountingHandler accountingHandler;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    VersionHandler versionHandler;
    @Inject
    TrashHandler trashHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getById(@QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.instance.set("getById");
        Session ses = null;
        Item toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = ItemHandler.getItem((Node)ses.getNodeByIdentifier(this.id), excludes);
        }
        catch (RepositoryException re) {
            log.error("jcr error getting item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error searching item", (Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error getting item", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemWrapper(toReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}/items/{name}")
    @Produces(value={"application/json"})
    public ItemList findChildrenByNamePattern(@QueryParam(value="exclude") List<String> excludes, @PathParam(value="name") String name) {
        InnerMethodName.instance.set("findChildrenByNamePattern");
        Session ses = null;
        ArrayList<Item> toReturn = new ArrayList<Item>();
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            NodeIterator it = ses.getNodeByIdentifier(this.id).getNodes(name);
            while (it.hasNext()) {
                toReturn.add(ItemHandler.getItem((Node)it.nextNode(), excludes));
            }
        }
        catch (RepositoryException re) {
            log.error("jcr error searching item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error searching item", (Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error searching item", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemList(toReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}/children/count")
    @Produces(value={"application/json"})
    public Long countById(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.instance.set("countById");
        Session ses = null;
        Long toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = Utils.getItemCount((Node)ses.getNodeByIdentifier(this.id), (boolean)(showHidden == null ? false : showHidden));
        }
        catch (RepositoryException re) {
            log.error("jcr error counting item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error counting item", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}/children")
    @Produces(value={"application/json"})
    public ItemList listById(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.instance.set("listById");
        Session ses = null;
        List toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = Utils.getItemList((Node)ses.getNodeByIdentifier(this.id), excludes, null, (boolean)(showHidden == null ? false : showHidden));
        }
        catch (RepositoryException re) {
            log.error("jcr error getting children", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error getting children", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemList(toReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}/children/paged")
    @Produces(value={"application/json"})
    public ItemList listByIdPaged(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit, @QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.instance.set("listByIdPaged");
        Session ses = null;
        List toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = Utils.getItemList((Node)ses.getNodeByIdentifier(this.id), excludes, (Range)new Range(start.intValue(), limit.intValue()), (boolean)(showHidden == null ? false : showHidden));
        }
        catch (RepositoryException re) {
            log.error("jcr error getting paged children", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error getting paged children", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemList(toReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}/publiclink")
    public URL getPubliclink() {
        InnerMethodName.instance.set("getPubliclink");
        Session ses = null;
        URL toReturn = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            Item item = ItemHandler.getItem((Node)ses.getNodeByIdentifier(this.id), Arrays.asList("hl:accounting", "hl:metadata"));
            if (!(item instanceof AbstractFileItem)) {
                throw new InvalidCallParameters("the choosen item is not a File");
            }
            AbstractFileItem fileItem = (AbstractFileItem)item;
            String url = Utils.getStorageClient((String)login).getClient().getHttpsUrl().RFileById(fileItem.getContent().getStorageId());
            toReturn = new URL(url);
        }
        catch (MalformedURLException | RepositoryException re) {
            log.error("jcr error getting public link", re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError(re));
        }
        catch (StorageHubException she) {
            log.error("error getting public link", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}/rootSharedFolder")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getRootSharedFolder(@QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.instance.set("getRootSharedFolder");
        Session ses = null;
        Item sharedParent = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            Item currentItem = ItemHandler.getItem((Node)ses.getNodeByIdentifier(this.id), excludes);
            if (!currentItem.isShared()) {
                throw new RuntimeException("this item is not shared");
            }
            log.trace("current node is {}", (Object)currentItem.getPath());
            while (!(currentItem instanceof SharedFolder)) {
                currentItem = ItemHandler.getItem((Node)ses.getNodeByIdentifier(currentItem.getParentId()), Arrays.asList("hl:accounting", "hl:metadata", "jcr:content"));
            }
            sharedParent = currentItem;
        }
        catch (RepositoryException re) {
            log.error("jcr error getting rootSharedFolder", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error getting rootSharedFolder", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemWrapper(sharedParent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}/anchestors")
    @Produces(value={"application/json"})
    public ItemList getAnchestors(@QueryParam(value="exclude") List<String> excludes) {
        InnerMethodName.instance.set("getAnchestors");
        org.gcube.common.storagehub.model.Path absolutePath = Utils.getHomePath();
        Session ses = null;
        LinkedList<Item> toReturn = new LinkedList<Item>();
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            Item currentItem = ItemHandler.getItem((Node)ses.getNodeByIdentifier(this.id), excludes);
            log.trace("current node is {}", (Object)currentItem.getPath());
            while (!(currentItem.getPath() + "/").equals(absolutePath.toPath())) {
                if (currentItem instanceof SharedFolder) {
                    Map users = ((SharedFolder)currentItem).getUsers().getValues();
                    String[] user = ((String)users.get(login)).split("/");
                    String parentId = user[0];
                    currentItem = ItemHandler.getItem((Node)ses.getNodeByIdentifier(parentId), excludes);
                } else {
                    currentItem = ItemHandler.getItem((Node)ses.getNodeByIdentifier(currentItem.getParentId()), excludes);
                }
                log.trace("current node is {}", (Object)currentItem.getPath());
                toReturn.add(currentItem);
            }
        }
        catch (RepositoryException re) {
            log.error("jcr error getting anchestors", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error getting anchestors", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        log.trace("item list to return is empty ? {}", (Object)toReturn.isEmpty());
        return new ItemList(toReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="{id}/download")
    public Response download(@QueryParam(value="exclude") List<String> excludes) {
        Response response;
        block14: {
            InnerMethodName.instance.set("downloadById");
            Session ses = null;
            response = null;
            try {
                String login = AuthorizationProvider.instance.get().getClient().getId();
                ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
                Node node = ses.getNodeByIdentifier(this.id);
                this.authChecker.checkReadAuthorizationControl(ses, this.id);
                Item item = ItemHandler.getItem((Node)node, null);
                if (item instanceof AbstractFileItem) {
                    AbstractFileItem fileItem = (AbstractFileItem)item;
                    InputStream streamToWrite = Utils.getStorageClient((String)login).getClient().get().RFileAsInputStream(fileItem.getContent().getStorageId());
                    this.accountingHandler.createReadObj(fileItem.getTitle(), ses, node, true);
                    SingleFileStreamingOutput so = new SingleFileStreamingOutput(streamToWrite);
                    response = Response.ok((Object)so).header("content-disposition", (Object)("attachment; filename = " + fileItem.getName())).header("Content-Length", (Object)fileItem.getContent().getSize()).build();
                    break block14;
                }
                if (item instanceof FolderItem) {
                    try {
                        Deque allNodes = Utils.getAllNodesForZip((FolderItem)((FolderItem)item), (Session)ses, (AccountingHandler)this.accountingHandler, excludes);
                        org.gcube.common.storagehub.model.Path originalPath = Paths.getPath((String)item.getPath());
                        1 so = new /* Unavailable Anonymous Inner Class!! */;
                        response = Response.ok((Object)so).header("content-disposition", (Object)("attachment; filename = " + item.getTitle() + ".zip")).header("Content-Length", (Object)-1L).build();
                        break block14;
                    }
                    finally {
                        if (ses != null) {
                            ses.save();
                        }
                    }
                }
                throw new InvalidItemException("item type not supported for download: " + item.getClass());
            }
            catch (RepositoryException re) {
                log.error("jcr error download", (Throwable)re);
                GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
            }
            catch (StorageHubException she) {
                log.error("error download", (Throwable)she);
                GXOutboundErrorResponse.throwException((Exception)((Object)she));
            }
            finally {
                if (ses != null) {
                    ses.logout();
                }
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{id}/move")
    public Response move(@QueryParam(value="destinationId") String destinationId, @PathParam(value="id") String identifier) {
        InnerMethodName.instance.set("move");
        Session ses = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkWriteAuthorizationControl(ses, destinationId, true);
            this.authChecker.checkWriteAuthorizationControl(ses, identifier, false);
            Node nodeToMove = ses.getNodeByIdentifier(identifier);
            Node destination = ses.getNodeByIdentifier(destinationId);
            Item destinationItem = ItemHandler.getItem((Node)destination, null);
            Item item = ItemHandler.getItem((Node)nodeToMove, null);
            if (item instanceof SharedFolder || item.isHidden() || destinationItem.isHidden()) {
                throw new InvalidItemException("shared folder cannot be moved or cannot not move hidden item");
            }
            if (Constants.FOLDERS_TO_EXLUDE.contains(item.getTitle()) || Constants.FOLDERS_TO_EXLUDE.contains(destinationItem.getTitle())) {
                throw new InvalidItemException("protected folder cannot be moved");
            }
            ses.getWorkspace().getLockManager().lock(destinationItem.getPath(), true, true, 0L, login);
            ses.getWorkspace().getLockManager().lock(nodeToMove.getPath(), true, true, 0L, login);
            if (item instanceof FolderItem) {
                if (Utils.hasSharedChildren((FolderItem)((FolderItem)item), (Session)ses)) {
                    throw new InvalidItemException("folder item with shared children cannot be moved");
                }
                ses.getWorkspace().move(nodeToMove.getPath(), destination.getPath() + "/" + nodeToMove.getName());
            } else {
                ses.getWorkspace().move(nodeToMove.getPath(), destination.getPath() + "/" + nodeToMove.getName());
            }
            ses.getWorkspace().getLockManager().unlock(nodeToMove.getPath());
            ses.getWorkspace().getLockManager().unlock(destinationItem.getPath());
            ses.save();
        }
        catch (RepositoryException re) {
            log.error("jcr error moving item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error moving item", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{id}")
    public Response deleteItem(@PathParam(value="id") String identifier) {
        InnerMethodName.instance.set("deleteItem");
        Session ses = null;
        try {
            log.info("removing node with id {}", (Object)identifier);
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkWriteAuthorizationControl(ses, identifier, false);
            Node nodeToDelete = ses.getNodeByIdentifier(identifier);
            Item itemToDelete = ItemHandler.getItem((Node)nodeToDelete, Arrays.asList("hl:accounting", "hl:metadata", "hl:owner"));
            if (itemToDelete instanceof SharedFolder || itemToDelete instanceof VreFolder || itemToDelete instanceof FolderItem && Utils.hasSharedChildren((FolderItem)((FolderItem)itemToDelete), (Session)ses)) {
                throw new InvalidItemException("SharedFolder, VreFolder or folders with shared children cannot be deleted");
            }
            log.debug("item is trashed? {}", (Object)itemToDelete.isTrashed());
            if (!itemToDelete.isTrashed()) {
                this.trashHandler.moveToTrash(ses, nodeToDelete, itemToDelete);
            } else {
                this.trashHandler.removeNodes(ses, Collections.singletonList(itemToDelete));
            }
        }
        catch (RepositoryException re) {
            log.error("jcr error moving item", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError((Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error moving item", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return Response.ok().build();
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

