/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import java.util.Arrays;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.data.access.storagehub.handlers.ItemHandler;

@Singleton
public class AuthorizationChecker {
    public void checkReadAuthorizationControl(Session session, String id) throws UserNotAuthorizedException, BackendGenericError, RepositoryException {
        SharedFolder parentShared;
        Node node = session.getNodeByIdentifier(id);
        String login = AuthorizationProvider.instance.get().getClient().getId();
        Item item = ItemHandler.getItem((Node)node, Arrays.asList("hl:accounting", "jcr:content"));
        if (item.isShared() ? !(parentShared = this.retrieveSharedFolderParent(item, session)).getUsers().getValues().containsKey(login) : !item.getOwner().equals(login)) {
            throw new UserNotAuthorizedException("Insufficent Provileges for user " + login + " to write into node with id " + id);
        }
    }

    private SharedFolder retrieveSharedFolderParent(Item item, Session session) throws BackendGenericError, RepositoryException {
        if (item instanceof SharedFolder) {
            return (SharedFolder)item;
        }
        return this.retrieveSharedFolderParent(ItemHandler.getItem((Node)session.getNodeByIdentifier(item.getParentId()), Arrays.asList("hl:accounting", "jcr:content")), session);
    }

    public void checkWriteAuthorizationControl(Session session, String id, boolean isNewItem) throws UserNotAuthorizedException, BackendGenericError, RepositoryException {
        Node node = session.getNodeByIdentifier(id);
        Item item = ItemHandler.getItem((Node)node, Arrays.asList("hl:accounting", "jcr:content", "hl:metadata"));
        String login = AuthorizationProvider.instance.get().getClient().getId();
        if (item.isShared()) {
            AccessControlEntry[] entries;
            SharedFolder parentShared = this.retrieveSharedFolderParent(item, session);
            JackrabbitAccessControlList accessControlList = AccessControlUtils.getAccessControlList((Session)session, (String)parentShared.getPath());
            for (AccessControlEntry entry : entries = accessControlList.getAccessControlEntries()) {
                if (!entry.getPrincipal().getName().equals(login) && (!parentShared.isVreFolder() || !entry.getPrincipal().getName().equals(parentShared.getTitle()))) continue;
                for (Privilege privilege : entry.getPrivileges()) {
                    AccessType access = AccessType.fromValue((String)privilege.getName());
                    if (isNewItem && access != AccessType.READ_ONLY) {
                        return;
                    }
                    if (isNewItem || access != AccessType.ADMINISTRATOR && access != AccessType.WRITE_ALL && (access != AccessType.WRITE_OWNER || !item.getOwner().equals(login))) continue;
                    return;
                }
                throw new UserNotAuthorizedException("Insufficent Provileges for user " + login + " to write into node with id " + id);
            }
        } else if (item.getOwner().equals(login)) {
            return;
        }
        throw new UserNotAuthorizedException("Insufficent Provileges for user " + login + " to write into node with id " + id);
    }

    public void checkAdministratorControl(Session session, SharedFolder item) throws UserNotAuthorizedException, RepositoryException {
        String login = AuthorizationProvider.instance.get().getClient().getId();
        if (item.isShared()) {
            AccessControlEntry[] entries;
            SharedFolder parentShared = item;
            JackrabbitAccessControlList accessControlList = AccessControlUtils.getAccessControlList((Session)session, (String)parentShared.getPath());
            for (AccessControlEntry entry : entries = accessControlList.getAccessControlEntries()) {
                if (!entry.getPrincipal().getName().equals(login) && (!parentShared.isVreFolder() || !entry.getPrincipal().getName().equals(parentShared.getTitle()))) continue;
                for (Privilege privilege : entry.getPrivileges()) {
                    AccessType access = AccessType.fromValue((String)privilege.getName());
                    if (access != AccessType.ADMINISTRATOR) continue;
                    return;
                }
                throw new UserNotAuthorizedException("The user " + login + " is not an administrator of node with id " + item.getId());
            }
        }
        throw new UserNotAuthorizedException("The user " + login + " is not an administrator of node with id " + item.getId());
    }
}

