/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.gxrest.response.outbound.GXOutboundErrorResponse;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.exceptions.InvalidCallParameters;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.exceptions.UserNotAuthorizedException;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.CredentialHandler;
import org.gcube.data.access.storagehub.handlers.ItemHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.gcube.smartgears.utils.InnerMethodName;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="items")
public class ItemSharing {
    private static final Logger log = LoggerFactory.getLogger(ItemSharing.class);
    @Inject
    RepositoryInitializer repository;
    @Inject
    AccountingHandler accountingHandler;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    VersionHandler versionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{id}/share")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public String share(@FormDataParam(value="users") Set<String> users, @FormDataParam(value="defaultAccessType") AccessType accessType) {
        InnerMethodName.instance.set("shareFolder");
        Session ses = null;
        String toReturn = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            this.authChecker.checkWriteAuthorizationControl(ses, this.id, false);
            Item item = ItemHandler.getItem((Node)ses.getNodeByIdentifier(this.id), Arrays.asList("hl:accounting", "jcr:content", "hl:metadata"));
            if (accessType == null) {
                accessType = AccessType.READ_ONLY;
            }
            if (users == null || users.isEmpty()) {
                throw new InvalidCallParameters("users is empty");
            }
            Node sharedFolderNode = !(item instanceof SharedFolder) ? this.shareFolder(item, ses) : ses.getNodeByIdentifier(item.getId());
            ses.save();
            ses.getWorkspace().getLockManager().lock(sharedFolderNode.getPath(), true, true, 0L, login);
            try {
                AccessControlManager acm = ses.getAccessControlManager();
                JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)sharedFolderNode.getPath());
                if (!(item instanceof SharedFolder)) {
                    Privilege[] adminPrivileges = new Privilege[]{acm.privilegeFromName(AccessType.ADMINISTRATOR.getValue())};
                    this.addUserToSharing(sharedFolderNode, (FolderItem)item, ses, login, adminPrivileges, acls);
                    users.remove(login);
                }
                Privilege[] userPrivileges = new Privilege[]{acm.privilegeFromName(accessType.getValue())};
                for (String user : users) {
                    try {
                        this.addUserToSharing(sharedFolderNode, (FolderItem)item, ses, user, userPrivileges, acls);
                    }
                    catch (Exception e) {
                        log.warn("error adding user {} to sharing of folder {}", (Object)user, (Object)sharedFolderNode.getName());
                    }
                }
                acm.setPolicy(sharedFolderNode.getPath(), (AccessControlPolicy)acls);
                this.accountingHandler.shareFolder(item.getTitle(), users, ses, sharedFolderNode, false);
                ses.save();
                toReturn = sharedFolderNode.getIdentifier();
            }
            finally {
                ses.getWorkspace().getLockManager().unlock(sharedFolderNode.getPath());
            }
        }
        catch (RepositoryException re) {
            log.error("jcr sharing", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error extracting archive", (Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error sharing", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return toReturn;
    }

    private Node shareFolder(Item item, Session ses) throws RepositoryException, BackendGenericError, StorageHubException {
        String login = AuthorizationProvider.instance.get().getClient().getId();
        if (!(item instanceof FolderItem) || Utils.hasSharedChildren((FolderItem)((FolderItem)item), (Session)ses) || !item.getOwner().equals(login)) {
            throw new InvalidItemException("item with id " + this.id + " cannot be shared");
        }
        String sharedFolderName = item.getId();
        String newNodePath = "/Share/" + sharedFolderName;
        ses.move(item.getPath(), newNodePath);
        Node sharedFolderNode = ses.getNode(newNodePath);
        sharedFolderNode.setPrimaryType("nthl:workspaceSharedItem");
        return sharedFolderNode;
    }

    private void addUserToSharing(Node sharedFolderNode, FolderItem item, Session ses, String user, Privilege[] userPrivileges, JackrabbitAccessControlList acls) throws RepositoryException {
        org.gcube.common.storagehub.model.Path userFolderPath = Paths.append((org.gcube.common.storagehub.model.Path)Utils.getHomePath((String)user), (String)item.getName());
        ses.getWorkspace().clone(ses.getWorkspace().getName(), sharedFolderNode.getPath(), userFolderPath.toPath(), false);
        String userRootWSId = ses.getNode(Utils.getHomePath((String)user).toPath()).getIdentifier();
        acls.addAccessControlEntry(AccessControlUtils.getPrincipal((Session)ses, (String)user), userPrivileges);
        Node usersNode = null;
        usersNode = sharedFolderNode.hasNode("hl:users") ? sharedFolderNode.getNode("hl:users") : sharedFolderNode.addNode("hl:users");
        usersNode.setProperty(user, String.format("%s/%s", userRootWSId, item.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{id}/unshare")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public String unshare(@FormDataParam(value="users") Set<String> users) {
        InnerMethodName.instance.set("unshareFolder");
        String login = AuthorizationProvider.instance.get().getClient().getId();
        Session ses = null;
        String toReturn = null;
        try {
            ses = this.repository.getRepository().login((Credentials)CredentialHandler.getAdminCredentials((ServletContext)this.context));
            Item item = ItemHandler.getItem((Node)ses.getNodeByIdentifier(this.id), Arrays.asList("hl:accounting", "jcr:content", "hl:metadata"));
            if (!(item instanceof FolderItem) || !((FolderItem)item).isShared() || ((SharedFolder)item).isVreFolder()) {
                throw new InvalidItemException("item with id " + this.id + " cannot be unshared");
            }
            SharedFolder sharedItem = (SharedFolder)item;
            HashSet usersInSharedFolder = new HashSet(sharedItem.getUsers().getValues().keySet());
            usersInSharedFolder.removeAll(users);
            if (users == null || users.size() == 0 || usersInSharedFolder.size() <= 1) {
                String string = this.unshareAll(login, ses, sharedItem);
                return string;
            }
            ses.getWorkspace().getLockManager().lock(sharedItem.getPath(), true, true, 0L, login);
            try {
                toReturn = users.size() == 1 && users.contains(login) ? this.unshareCaller(login, ses, sharedItem) : this.unsharePartial(users, login, ses, sharedItem);
            }
            finally {
                ses.getWorkspace().getLockManager().unlock(sharedItem.getPath());
            }
        }
        catch (RepositoryException re) {
            log.error("jcr unsharing", (Throwable)re);
            GXOutboundErrorResponse.throwException((Exception)new BackendGenericError("jcr error extracting archive", (Throwable)re));
        }
        catch (StorageHubException she) {
            log.error("error unsharing", (Throwable)she);
            GXOutboundErrorResponse.throwException((Exception)((Object)she));
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String unshareAll(String login, Session ses, SharedFolder item) throws StorageHubException, BackendGenericError, RepositoryException {
        Node unsharedNode;
        this.authChecker.checkAdministratorControl(ses, item);
        if (!login.equals(item.getOwner())) {
            throw new UserNotAuthorizedException("user " + login + " not authorized to unshare all");
        }
        Node sharedItemNode = ses.getNodeByIdentifier(item.getId());
        ses.getWorkspace().getLockManager().lock(sharedItemNode.getPath(), true, true, 0L, login);
        try {
            log.debug("user list is empty, I'm going to remove also the shared dir");
            String adminDirPath = (String)item.getUsers().getValues().get(login);
            String[] splitString = adminDirPath.split("/");
            String parentDirectoryId = splitString[0];
            String directoryName = splitString[1];
            Node parentNode = ses.getNodeByIdentifier(parentDirectoryId);
            log.debug("parent node path is {}/{}", (Object)parentNode.getPath(), (Object)directoryName);
            Node adminNode = ses.getNode(String.format("%s/%s", parentNode.getPath(), directoryName));
            adminNode.removeShare();
            unsharedNode = this.createUnsharedFolder(ses, parentNode, directoryName, item.getDescription(), login);
            List itemsToCopy = Utils.getItemList((Node)sharedItemNode, Arrays.asList("hl:accounting", "jcr:content", "hl:metadata"), null, (boolean)true);
            for (Item itemCopy : itemsToCopy) {
                log.debug("copying {} to {}", (Object)itemCopy.getPath(), (Object)unsharedNode.getPath());
                ses.move(itemCopy.getPath(), String.format("%s/%s", unsharedNode.getPath(), itemCopy.getName()));
            }
            ses.save();
        }
        finally {
            ses.getWorkspace().getLockManager().unlock(sharedItemNode.getPath());
        }
        sharedItemNode.removeSharedSet();
        ses.save();
        log.debug("all the users have been removed, the folder is totally unshared");
        return unsharedNode.getIdentifier();
    }

    private String unshareCaller(String login, Session ses, SharedFolder item) throws StorageHubException, RepositoryException {
        if (login.equals(item.getOwner())) {
            throw new InvalidCallParameters("the callor is the owner, the folder cannot be unshared");
        }
        if (item.getUsers().getValues().get(login) == null) {
            throw new InvalidCallParameters("the folder is not shared with user " + login);
        }
        String parentId = this.removeSharingForUser(login, ses, item);
        AccessControlManager acm = ses.getAccessControlManager();
        JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)item.getPath());
        AccessControlEntry entryToDelete = null;
        for (AccessControlEntry ace : acls.getAccessControlEntries()) {
            if (!ace.getPrincipal().getName().equals(login)) continue;
            entryToDelete = ace;
            break;
        }
        if (entryToDelete != null) {
            acls.removeAccessControlEntry(entryToDelete);
        }
        log.debug("removed Access control entry for user {}", (Object)login);
        Node sharedItemNode = ses.getNodeByIdentifier(item.getId());
        Node usersNode = sharedItemNode.getNode("hl:users");
        usersNode.remove();
        Node newUsersNode = sharedItemNode.addNode("hl:users");
        item.getUsers().getValues().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(login)).forEach(entry -> {
            try {
                newUsersNode.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            catch (Exception e) {
                log.error("error adding property to shared node users node under " + item.getId());
            }
        });
        acm.setPolicy(item.getPath(), (AccessControlPolicy)acls);
        ses.save();
        return parentId;
    }

    private String unsharePartial(Set<String> usersToUnshare, String login, Session ses, SharedFolder item) throws StorageHubException, RepositoryException {
        this.authChecker.checkAdministratorControl(ses, item);
        if (usersToUnshare.contains(item.getOwner())) {
            throw new UserNotAuthorizedException("user " + login + " not authorized to unshare owner");
        }
        AccessControlManager acm = ses.getAccessControlManager();
        JackrabbitAccessControlList acls = AccessControlUtils.getAccessControlList((AccessControlManager)acm, (String)item.getPath());
        for (String user : usersToUnshare) {
            this.removeSharingForUser(user, ses, item);
            AccessControlEntry entryToDelete = null;
            for (AccessControlEntry ace : acls.getAccessControlEntries()) {
                if (!ace.getPrincipal().getName().equals(login)) continue;
                entryToDelete = ace;
                break;
            }
            if (entryToDelete == null) continue;
            acls.removeAccessControlEntry(entryToDelete);
        }
        log.debug("removed Access control entry for user {}", (Object)login);
        Node sharedItemNode = ses.getNodeByIdentifier(item.getId());
        Node usersNode = sharedItemNode.getNode("hl:users");
        usersNode.remove();
        Node newUsersNode = sharedItemNode.addNode("hl:users");
        item.getUsers().getValues().entrySet().stream().filter(entry -> !usersToUnshare.contains(entry.getKey())).forEach(entry -> {
            try {
                newUsersNode.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
            catch (Exception e) {
                log.error("error adding property to shared node users node under " + item.getId());
            }
        });
        acm.setPolicy(item.getPath(), (AccessControlPolicy)acls);
        ses.save();
        return item.getId();
    }

    public String removeSharingForUser(String user, Session ses, SharedFolder item) throws RepositoryException {
        String userDirPath = (String)item.getUsers().getValues().get(user);
        if (userDirPath == null) {
            return null;
        }
        String[] splitString = userDirPath.split("/");
        String parentDirectoryId = splitString[0];
        String directoryName = splitString[1];
        Node parentNode = ses.getNodeByIdentifier(parentDirectoryId);
        Node userNode = ses.getNode(String.format("%s/%s", parentNode.getPath(), directoryName));
        userNode.removeShare();
        log.debug("directory removed for user {}", (Object)user);
        return parentDirectoryId;
    }

    private Node createUnsharedFolder(Session ses, Node destinationNode, String name, String description, String login) {
        FolderItem item = new FolderItem();
        Calendar now = Calendar.getInstance();
        item.setName(name);
        item.setTitle(name);
        item.setDescription(description);
        item.setHidden(false);
        item.setLastAction(ItemAction.CREATED);
        item.setLastModificationTime(now);
        item.setLastModifiedBy(login);
        item.setOwner(login);
        Node newNode = ItemHandler.createNodeFromItem((Session)ses, (Node)destinationNode, (Item)item);
        return newNode;
    }
}

