/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.exceptions.BackendGenericError;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.ItemHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TrashHandler {
    private static Logger log = LoggerFactory.getLogger(TrashHandler.class);
    @Inject
    VersionHandler versionHandler;
    @Inject
    AccountingHandler accountingHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodes(Session ses, List<Item> itemsToDelete) throws RepositoryException {
        log.debug("removing node");
        String login = AuthorizationProvider.instance.get().getClient().getId();
        Node trashFolder = ses.getNode(Paths.append((Path)Utils.getHomePath(), (String)"Trash").toPath());
        try {
            ses.getWorkspace().getLockManager().lock(trashFolder.getPath(), true, true, 0L, login);
            HashSet contentIdsToDelete = new HashSet();
            for (Item itemToDelete : itemsToDelete) {
                try {
                    Utils.getAllContentIds((Session)ses, contentIdsToDelete, (Item)itemToDelete, (VersionHandler)this.versionHandler);
                    ses.removeItem(itemToDelete.getPath());
                }
                catch (Exception e) {
                    log.warn("error removing item with id {}", (Object)itemToDelete.getId(), (Object)e);
                }
            }
            new /* Unavailable Anonymous Inner Class!! */.start();
            ses.save();
        }
        finally {
            ses.getWorkspace().getLockManager().unlock(trashFolder.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveToTrash(Session ses, Node nodeToDelete, Item item) throws RepositoryException {
        log.debug("moving node to trash");
        Node trashFolder = ses.getNode(Paths.append((Path)Utils.getHomePath(), (String)"Trash").toPath());
        String login = AuthorizationProvider.instance.get().getClient().getId();
        try {
            ses.getWorkspace().getLockManager().lock(trashFolder.getPath(), true, true, 0L, login);
            ses.getWorkspace().getLockManager().lock(nodeToDelete.getPath(), true, true, 0L, login);
            log.debug("preparing thrash item");
            TrashItem trashItem = new TrashItem();
            trashItem.setDeletedBy(AuthorizationProvider.instance.get().getClient().getId());
            trashItem.setDeletedFrom(nodeToDelete.getParent().getPath());
            Calendar now = Calendar.getInstance();
            trashItem.setDeletedTime(now);
            trashItem.setHidden(false);
            trashItem.setLastAction(ItemAction.CREATED);
            trashItem.setDescription("trash item of node " + nodeToDelete.getPath());
            trashItem.setParentId(trashFolder.getIdentifier());
            trashItem.setParentPath(trashFolder.getPath());
            trashItem.setTitle(item.getTitle());
            trashItem.setName(item.getName());
            trashItem.setOriginalParentId(nodeToDelete.getParent().getIdentifier());
            trashItem.setOwner(item.getOwner());
            trashItem.setLastModificationTime(item.getLastModificationTime());
            trashItem.setLastModifiedBy(item.getLastModifiedBy());
            trashItem.setLenght(0L);
            if (item instanceof FolderItem) {
                trashItem.setFolder(Boolean.valueOf(true));
            } else if (item instanceof AbstractFileItem) {
                AbstractFileItem file = (AbstractFileItem)item;
                trashItem.setMimeType(file.getContent().getMimeType());
                trashItem.setLenght(file.getContent().getSize().longValue());
                trashItem.setFolder(Boolean.valueOf(false));
            }
            log.debug("creating node");
            Node newTrashItemNode = ItemHandler.createNodeFromItem((Session)ses, (Node)trashFolder, (Item)trashItem);
            ses.save();
            log.debug("calling jcr move");
            ses.getWorkspace().move(nodeToDelete.getPath(), Paths.append((Path)Paths.getPath((String)newTrashItemNode.getPath()), (String)nodeToDelete.getName()).toPath());
            String mimetype = null;
            if (item instanceof AbstractFileItem) {
                mimetype = ((AbstractFileItem)item).getContent().getMimeType();
            }
            this.accountingHandler.createFolderRemoveObj(item.getName(), item.getClass().getSimpleName(), mimetype, ses, ses.getNodeByIdentifier(item.getParentId()), true);
        }
        finally {
            ses.getWorkspace().getLockManager().unlock(nodeToDelete.getPath());
            ses.getWorkspace().getLockManager().unlock(trashFolder.getPath());
        }
    }

    public String restoreItem(Session ses, TrashItem item) throws RepositoryException, BackendGenericError {
        log.debug("restoring node from trash");
        String login = AuthorizationProvider.instance.get().getClient().getId();
        Node originalParent = ses.getNodeByIdentifier(item.getOriginalParentId());
        ses.getWorkspace().getLockManager().lock(originalParent.getPath(), true, true, 0L, login);
        List items = Utils.getItemList((Node)ses.getNodeByIdentifier(item.getId()), Arrays.asList("hl:accounting", "hl:metadata", "jcr:content"), null, (boolean)false);
        if (items.size() != 1) {
            log.warn("a problem occurred restoring item from trash");
            throw new BackendGenericError("An error occurred on trash item");
        }
        Item itemToMove = (Item)items.get(0);
        String newNodePath = Paths.append((Path)Paths.getPath((String)originalParent.getPath()), (String)itemToMove.getName()).toPath();
        ses.move(itemToMove.getPath(), newNodePath);
        ses.removeItem(item.getPath());
        ses.save();
        return ses.getNode(newNodePath).getIdentifier();
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

