/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.xml.ws.WebServiceException;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.expressions.Expression;
import org.gcube.common.storagehub.model.expressions.logical.And;
import org.gcube.common.storagehub.model.expressions.logical.ISDescendant;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.handlers.ItemHandler;
import org.gcube.data.access.storagehub.handlers.VRE;
import org.gcube.data.access.storagehub.handlers.VREManager;
import org.gcube.data.access.storagehub.query.sql2.evaluators.Evaluators;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
public class WorkspaceManager {
    private static final Logger log = LoggerFactory.getLogger(WorkspaceManager.class);
    @Inject
    RepositoryInitializer repository;
    @Inject
    Evaluators evaluator;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    ServletContext context;
    @Inject
    VREManager vreManager;
    @RequestScoped
    @QueryParam(value="exclude")
    private List<String> excludes = Collections.emptyList();

    @Path(value="")
    @GET
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getWorkspace(@QueryParam(value="relPath") String relPath) {
        CalledMethodProvider.instance.set("getWorkspace");
        Session ses = null;
        org.gcube.common.storagehub.model.Path absolutePath = relPath == null ? Utils.getHomePath() : Paths.append((org.gcube.common.storagehub.model.Path)Utils.getHomePath(), (String)relPath);
        Item toReturn = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            long start = System.currentTimeMillis();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            log.trace("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
            Node node = ses.getNode(absolutePath.toPath());
            this.authChecker.checkReadAuthorizationControl(ses, node.getIdentifier());
            toReturn = ItemHandler.getItem((Node)node, (List)this.excludes);
        }
        catch (Throwable e) {
            log.error("error reading the node children of {}", (Object)absolutePath, (Object)e);
            throw new WebApplicationException("error getting WS folder " + absolutePath.toPath(), e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemWrapper(toReturn);
    }

    private synchronized VRE getVreFolderItem(Session ses) throws Exception {
        org.gcube.common.storagehub.model.Path vrePath = Paths.append((org.gcube.common.storagehub.model.Path)Utils.getHomePath(), (String)"MySpecialFolders");
        ScopeBean bean = new ScopeBean(ScopeProvider.instance.get());
        if (!bean.is(ScopeBean.Type.VRE)) {
            throw new Exception("the current scope is not a VRE");
        }
        String entireScopeName = bean.toString().replaceAll("^/(.*)/?$", "$1").replaceAll("/", "-");
        VRE vre = this.vreManager.getVRE(entireScopeName);
        if (vre != null) {
            return vre;
        }
        String query = String.format("SELECT * FROM [nthl:workspaceItem] As node WHERE node.[jcr:title] like '%s' AND ISDESCENDANTNODE('%s')", entireScopeName, vrePath.toPath());
        Query jcrQuery = ses.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
        NodeIterator it = jcrQuery.execute().getNodes();
        if (!it.hasNext()) {
            throw new Exception("vre folder not found for context " + entireScopeName);
        }
        Node folder = it.nextNode();
        Item vreFolder = ItemHandler.getItem((Node)folder, (List)this.excludes);
        return this.vreManager.putVRE(vreFolder);
    }

    @Path(value="vrefolder")
    @GET
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getVreRootFolder() {
        CalledMethodProvider.instance.set("getVreRootFolder");
        Session ses = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            ItemWrapper itemWrapper = new ItemWrapper(this.getVreFolderItem(ses).getVreFolder());
            return itemWrapper;
        }
        catch (Throwable e) {
            log.error("error reading vreNode for context {}", (Object)ScopeProvider.instance.get(), (Object)e);
            throw new WebApplicationException("error retrieving vre folder", e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @Path(value="vrefolder/recents")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFolderRecentsDocument() {
        CalledMethodProvider.instance.set("getVreFolderRecents");
        Session ses = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            VRE vre = this.getVreFolderItem(ses);
            log.trace("VRE retrieved {}", (Object)vre.getVreFolder().getTitle());
            List recentItems = vre.getRecents();
            log.trace("recents retrieved {}", (Object)vre.getVreFolder().getTitle());
            ItemList itemList = new ItemList(recentItems);
            return itemList;
        }
        catch (Throwable e) {
            log.error("error reading recents for context {}", (Object)ScopeProvider.instance.get(), (Object)e);
            throw new WebApplicationException("error reading recents", e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @Path(value="trash")
    @GET
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getTrashRootFolder() {
        CalledMethodProvider.instance.set("getTrashRootFolder");
        Session ses = null;
        org.gcube.common.storagehub.model.Path trashPath = Paths.append((org.gcube.common.storagehub.model.Path)Utils.getHomePath(), (String)"Trash");
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            long start = System.currentTimeMillis();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            log.info("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
            Node folder = ses.getNode(trashPath.toPath());
            Item item = ItemHandler.getItem((Node)folder, (List)this.excludes);
            ItemWrapper itemWrapper = new ItemWrapper(item);
            return itemWrapper;
        }
        catch (Throwable e) {
            log.error("error reading the node {}", (Object)trashPath, (Object)e);
            throw new WebApplicationException("error retrieving trash folder", e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @Path(value="vrefolders")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFolders() {
        CalledMethodProvider.instance.set("getVreFolders");
        Session ses = null;
        org.gcube.common.storagehub.model.Path vrePath = Paths.append((org.gcube.common.storagehub.model.Path)Utils.getHomePath(), (String)"MySpecialFolders");
        List toReturn = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            toReturn = Utils.getItemList((Node)ses.getNode(vrePath.toPath()), (List)this.excludes, null, (boolean)false);
        }
        catch (Throwable e) {
            log.error("error reading the node children of {}", (Object)vrePath, (Object)e);
            throw new WebApplicationException("error reading the node children of " + vrePath.toPath(), e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemList(toReturn);
    }

    @Path(value="vrefolders/paged")
    @GET
    @Produces(value={"application/json"})
    public ItemList getVreFoldersPaged(@QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit) {
        CalledMethodProvider.instance.set("getVreFoldersPaged");
        Session ses = null;
        org.gcube.common.storagehub.model.Path vrePath = Paths.append((org.gcube.common.storagehub.model.Path)Utils.getHomePath(), (String)"MySpecialFolders");
        List toReturn = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            toReturn = Utils.getItemList((Node)ses.getNode(vrePath.toPath()), (List)this.excludes, (Range)new Range(start.intValue(), limit.intValue()), (boolean)false);
        }
        catch (Throwable e) {
            log.error("(paged) error reading the node children of {}", (Object)vrePath, (Object)e);
            throw new WebApplicationException("error reading the node children of " + vrePath.toPath(), e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemList(toReturn);
    }

    @Path(value="query")
    @GET
    @Produces(value={"application/json"})
    public ItemList searchItems(@QueryParam(value="n") String node, @QueryParam(value="e") String jsonExpr, @QueryParam(value="o") List<String> orderField, @QueryParam(value="l") Integer limit, @QueryParam(value="f") Integer offset) {
        CalledMethodProvider.instance.set("searchItems");
        Session ses = null;
        ArrayList<Item> toReturn = new ArrayList<Item>();
        try {
            ObjectMapper mapper = new ObjectMapper();
            Expression expression = (Expression)mapper.readValue(jsonExpr, Expression.class);
            String stringExpression = this.evaluator.evaluate((Expression)new And((Expression)new ISDescendant(Utils.getHomePath()), expression, new Expression[0]));
            String orderBy = "";
            if (orderField != null && orderField.size() > 0) {
                orderBy = String.format("ORDER BY %s", orderField.stream().collect(Collectors.joining(",")).toString());
            }
            String sql2Query = String.format("SELECT * FROM [%s] AS node WHERE %s %s ", node, stringExpression, orderBy);
            log.info("query sent is {}", (Object)sql2Query);
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            Query jcrQuery = ses.getWorkspace().getQueryManager().createQuery(sql2Query, "JCR-SQL2");
            if (limit != null && limit != -1) {
                jcrQuery.setLimit((long)limit.intValue());
            }
            if (offset != null && offset != -1) {
                jcrQuery.setOffset((long)offset.intValue());
            }
            QueryResult result = jcrQuery.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                toReturn.add(ItemHandler.getItem((Node)it.nextNode(), null));
            }
        }
        catch (Throwable e) {
            log.error("error executing the query", e);
            throw new WebServiceException("error executing the query", e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemList(toReturn);
    }
}

