/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.util.ArrayList;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.Privilege;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.common.storagehub.model.acls.ACL;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.types.ACLList;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="item")
public class ACLManager {
    private static final Logger log = LoggerFactory.getLogger(ACLManager.class);
    @Inject
    RepositoryInitializer repository;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    AuthorizationChecker authChecker;

    @Produces(value={"application/json"})
    @GET
    @Path(value="{id}/acls")
    public ACLList getACL() {
        CalledMethodProvider.instance.set("getACLById");
        Session ses = null;
        ArrayList<ACL> acls = new ArrayList<ACL>();
        try {
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(this.context.getInitParameter("admin-username"), this.context.getInitParameter("admin-pwd").toCharArray()));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            String path = ses.getNodeByIdentifier(this.id).getPath();
            log.info("checking acces for path {}", (Object)path);
            JackrabbitAccessControlList accessControlList = AccessControlUtils.getAccessControlList((Session)ses, (String)path);
            for (AccessControlEntry aclEntry : accessControlList.getAccessControlEntries()) {
                ACL acl = new ACL();
                acl.setPricipal(aclEntry.getPrincipal().getName());
                ArrayList<AccessType> types = new ArrayList<AccessType>();
                for (Privilege priv : aclEntry.getPrivileges()) {
                    try {
                        types.add(AccessType.fromValue((String)priv.getName()));
                    }
                    catch (Exception e) {
                        log.warn(priv.getName() + " cannot be mapped to AccessTypes", (Throwable)e);
                    }
                }
                acl.setAccessTypes(types);
                acls.add(acl);
            }
            ACLList aCLList = new ACLList(acls);
            return aCLList;
        }
        catch (Exception e) {
            log.error("error gettign ACL", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }
}

