/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class VersionHandler {
    private static final Logger logger = LoggerFactory.getLogger(VersionHandler.class);

    public void makeVersionableContent(Node node, Session session) {
        try {
            Node contentNode = node.getNode("jcr:content");
            contentNode.addMixin("mix:versionable");
        }
        catch (Exception e) {
            logger.warn("cannot create versioned content node", (Throwable)e);
        }
    }

    public void checkinContentNode(Node node, Session session) {
        try {
            Node contentNode = node.getNode("jcr:content");
            VersionManager versionManager = session.getWorkspace().getVersionManager();
            versionManager.checkin(contentNode.getPath());
        }
        catch (Exception e) {
            logger.warn("cannotcheckinNode content node", (Throwable)e);
        }
    }

    public void checkoutContentNode(Node node, Session session) {
        try {
            Node contentNode = node.getNode("jcr:content");
            VersionManager versionManager = session.getWorkspace().getVersionManager();
            versionManager.checkout(contentNode.getPath());
        }
        catch (Exception e) {
            logger.warn("cannot checkoutNode content node", (Throwable)e);
        }
    }

    public void getContentVersionHistory(Node node, Session session) {
        try {
            Node contentNode = node.getNode("jcr:content");
            VersionManager versionManager = session.getWorkspace().getVersionManager();
            VersionHistory history = versionManager.getVersionHistory(contentNode.getPath());
            VersionIterator iterator = history.getAllVersions();
            iterator.skip(1L);
            while (iterator.hasNext()) {
                Version version = iterator.nextVersion();
                logger.debug("version name {} with nodeType {}", (Object)version.getName(), (Object)version.getPrimaryNodeType().getName());
            }
        }
        catch (Exception e) {
            logger.warn("cannot get version history content node", (Throwable)e);
        }
    }
}

