/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.storagehub.model.Path;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.types.NodeProperty;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.ItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    public static final String SERVICE_NAME = "home-library";
    public static final String SERVICE_CLASS = "org.gcube.portlets.user";
    private static final String FOLDERS_TYPE = "nthl:workspaceItem";
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static String getSecurePassword(String user) throws Exception {
        String digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(user.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            digest = sb.toString();
        }
        catch (Exception e) {
            logger.error("error getting secure password", (Throwable)e);
        }
        return digest;
    }

    public static long getItemCount(Node parent, boolean showHidden) throws Exception {
        NodeIterator iterator = parent.getNodes();
        long count = 0L;
        while (iterator.hasNext()) {
            Node current = iterator.nextNode();
            if (Utils.isToExclude((Node)current, (boolean)showHidden)) continue;
            ++count;
        }
        return count;
    }

    public static <T extends Item> List<T> getItemList(Node parent, List<String> excludes, Range range, boolean showHidden) throws Exception {
        ArrayList<Item> returnList = new ArrayList<Item>();
        long start = System.currentTimeMillis();
        NodeIterator iterator = parent.getNodes();
        logger.trace("time to get iterator {}", (Object)(System.currentTimeMillis() - start));
        int count = 0;
        logger.trace("selected range is {}", (Object)range);
        while (iterator.hasNext()) {
            Node current = iterator.nextNode();
            if (Utils.isToExclude((Node)current, (boolean)showHidden)) continue;
            if (range == null || count >= range.getStart() && returnList.size() < range.getLimit()) {
                Item item = ItemHandler.getItem((Node)current, excludes);
                returnList.add(item);
            }
            ++count;
        }
        return returnList;
    }

    private static boolean isToExclude(Node node, boolean showHidden) throws Exception {
        return node.getName().startsWith("rep:") || node.getName().startsWith("hl:") || !showHidden && node.hasProperty(NodeProperty.HIDDEN.toString()) && node.getProperty(NodeProperty.HIDDEN.toString()).getBoolean() || node.getPrimaryNodeType().getName().equals("nthl:workspaceItem") && Constants.FOLDERS_TO_EXLUDE.contains(node.getName());
    }

    public static Path getHomePath() {
        return Paths.getPath((String)String.format("/Home/%s/Workspace", AuthorizationProvider.instance.get().getClient().getId()));
    }

    public static StorageClient getStorageClient(String login) {
        return new StorageClient("org.gcube.portlets.user", "home-library", login, AccessType.SHARED, MemoryType.PERSISTENT);
    }

    public static Deque<Item> getAllNodesForZip(FolderItem directory, Session session, AccountingHandler accountingHandler) throws Exception {
        LinkedList<Item> queue = new LinkedList<Item>();
        Node currentNode = session.getNodeByIdentifier(directory.getId());
        queue.push((Item)directory);
        LinkedList tempQueue = new LinkedList();
        logger.debug("adding directory {}", (Object)directory.getPath());
        for (Item item : Utils.getItemList((Node)currentNode, null, null, (boolean)false)) {
            if (item instanceof FolderItem) {
                tempQueue.addAll(Utils.getAllNodesForZip((FolderItem)((FolderItem)item), (Session)session, (AccountingHandler)accountingHandler));
                continue;
            }
            if (!(item instanceof AbstractFileItem)) continue;
            logger.debug("adding file {}", (Object)item.getPath());
            AbstractFileItem fileItem = (AbstractFileItem)item;
            accountingHandler.createReadObj(fileItem.getTitle(), session, session.getNodeByIdentifier(item.getId()), false);
            queue.addLast(item);
        }
        queue.addAll(tempQueue);
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zipNode(ZipOutputStream zos, Deque<Item> queue, String login, Path originalPath) throws Exception {
        logger.trace("originalPath is {}", (Object)originalPath.toPath());
        Path actualPath = Paths.getPath((String)"");
        while (!queue.isEmpty()) {
            Item item = queue.pop();
            if (item instanceof FolderItem) {
                actualPath = Paths.getPath((String)item.getPath());
                logger.trace("actualPath is {}", (Object)actualPath.toPath());
                String name = Paths.remove((Path)actualPath, (Path)originalPath).toPath().replaceFirst("/", "");
                logger.trace("writing dir {}", (Object)name);
                zos.putNextEntry(new ZipEntry(name));
                zos.closeEntry();
                continue;
            }
            if (!(item instanceof AbstractFileItem)) continue;
            InputStream streamToWrite = Utils.getStorageClient((String)login).getClient().get().RFileAsInputStream(((AbstractFileItem)item).getContent().getStorageId());
            if (streamToWrite == null) {
                logger.warn("discarding item {} ", (Object)item.getName());
                continue;
            }
            try {
                BufferedInputStream is = new BufferedInputStream(streamToWrite);
                Throwable throwable = null;
                try {
                    String name = Paths.remove((Path)actualPath, (Path)originalPath).toPath() + item.getName().replaceFirst("/", "");
                    logger.trace("writing file {}", (Object)name);
                    zos.putNextEntry(new ZipEntry(name));
                    Utils.copyStream((InputStream)is, (OutputStream)zos);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            catch (Exception e) {
                logger.warn("error writing item {}", (Object)item.getName(), (Object)e);
            }
            finally {
                zos.closeEntry();
            }
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[2048];
        int readcount = 0;
        while ((readcount = in.read(buffer)) != -1) {
            out.write(buffer, 0, readcount);
        }
    }
}

