/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.MetaInfo;
import org.gcube.data.access.storagehub.MultipleOutputStream;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.ItemHandler;
import org.gcube.data.access.storagehub.handlers.VersionHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandler;
import org.gcube.data.access.storagehub.handlers.content.ContentHandlerFactory;
import org.gcube.data.access.storagehub.services.ItemsCreator;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="item")
public class ItemsCreator {
    private static final Logger log = LoggerFactory.getLogger(ItemsCreator.class);
    private static ExecutorService executor = Executors.newFixedThreadPool(100);
    @Context
    ServletContext context;
    @Inject
    RepositoryInitializer repository;
    @Inject
    ContentHandlerFactory contenthandlerFactory;
    @Inject
    VersionHandler versionHandler;
    @Inject
    AuthorizationChecker authChecker;
    @Inject
    AccountingHandler accountingHandler;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/create/{type:(?!FILE)[^/?$]*}")
    public Response createItem(@PathParam(value="id") String id, @PathParam(value="type") String type, @QueryParam(value="name") String name, @QueryParam(value="description") String description) {
        CalledMethodProvider.instance.set(String.format("createItem(%s)", type));
        log.info("create generic item called");
        Session ses = null;
        Item destinationItem = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            long start = System.currentTimeMillis();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(this.context.getInitParameter("admin-username"), this.context.getInitParameter("admin-pwd").toCharArray()));
            if (!type.equals("FOLDER")) {
                throw new IllegalAccessException("invalid item type");
            }
            log.info("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
            Node destination = ses.getNodeByIdentifier(id);
            destinationItem = ItemHandler.getItem((Node)destination, Arrays.asList("hl:accounting", "jcr:content"));
            if (!(destinationItem instanceof FolderItem)) {
                throw new Exception("an Item must be created into a directory");
            }
            this.authChecker.checkWriteAuthorizationControl(ses, destinationItem.getId(), true);
            ses.getWorkspace().getLockManager().lock(destinationItem.getPath(), true, true, 0L, login);
            FolderItem item = new FolderItem();
            Calendar now = Calendar.getInstance();
            item.setName(name);
            item.setTitle(name);
            item.setDescription(description);
            item.setHidden(false);
            item.setLastAction(ItemAction.CREATED);
            item.setLastModificationTime(now);
            item.setLastModifiedBy(login);
            item.setOwner(login);
            log.debug("item prepared, fulfilling content");
            log.debug("content prepared");
            Node newnode = ItemHandler.createNodeFromItem((Session)ses, (Node)destination, (Item)item);
            this.accountingHandler.createFolderAddObj(name, type, null, ses, newnode, false);
            ses.save();
            log.info("item correctly created");
            Response response = Response.ok((Object)new ItemWrapper((Item)item)).build();
            return response;
        }
        catch (Exception e) {
            log.error("error creating item", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                if (destinationItem != null) {
                    try {
                        if (ses.getWorkspace().getLockManager().isLocked(destinationItem.getPath())) {
                            ses.getWorkspace().getLockManager().unlock(destinationItem.getPath());
                        }
                    }
                    catch (Throwable t) {
                        log.warn("error unlocking {}", (Object)destinationItem.getPath(), (Object)t);
                    }
                }
                ses.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/create/FILE")
    public Response createFileItem(InputStream stream, @PathParam(value="id") String id, @QueryParam(value="name") String name, @QueryParam(value="description") String description) {
        CalledMethodProvider.instance.set(String.format("createItem(FILE)", new Object[0]));
        log.info("create file called");
        Session ses = null;
        Item destinationItem = null;
        try {
            Node newNode;
            String login = AuthorizationProvider.instance.get().getClient().getId();
            long start = System.currentTimeMillis();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(this.context.getInitParameter("admin-username"), this.context.getInitParameter("admin-pwd").toCharArray()));
            log.info("time to connect to repo  {}", (Object)(System.currentTimeMillis() - start));
            Node destination = ses.getNodeByIdentifier(id);
            destinationItem = ItemHandler.getItem((Node)destination, Arrays.asList("hl:accounting", "jcr:content"));
            log.debug("destination item path is {}", (Object)destinationItem.getPath());
            if (!(destinationItem instanceof FolderItem)) {
                throw new Exception("an Item must be copyed to another directory");
            }
            ses.getWorkspace().getLockManager().lock(destinationItem.getPath(), true, true, 0L, login);
            ContentHandler handler = this.getContentHandler(stream, name, destinationItem.getPath());
            AbstractFileItem item = handler.buildItem(name, description, login);
            log.debug("item prepared, fulfilling content");
            log.debug("content prepared");
            try {
                newNode = ses.getNode(Paths.append((org.gcube.common.storagehub.model.Path)Paths.getPath((String)destinationItem.getPath()), (String)name).toPath());
                log.info("overwriting the old node");
                this.authChecker.checkWriteAuthorizationControl(ses, newNode.getIdentifier(), false);
                this.versionHandler.checkoutContentNode(newNode, ses);
                log.trace("replacing content of class {}", item.getContent().getClass());
                ItemHandler.replaceContent((Session)ses, (Node)newNode, (AbstractFileItem)item);
            }
            catch (PathNotFoundException pnf) {
                log.info("creating new node");
                this.authChecker.checkWriteAuthorizationControl(ses, destinationItem.getId(), true);
                newNode = ItemHandler.createNodeFromItem((Session)ses, (Node)destination, (Item)item);
                this.versionHandler.makeVersionableContent(newNode, ses);
            }
            this.accountingHandler.createFolderAddObj(name, "FILE", item.getContent().getMimeType(), ses, newNode, false);
            ses.save();
            this.versionHandler.checkinContentNode(newNode, ses);
            this.versionHandler.getContentVersionHistory(newNode, ses);
            log.info("item correctly created");
            Response response = Response.ok((Object)new ItemWrapper((Item)item)).build();
            return response;
        }
        catch (Throwable e) {
            log.error("error creating item", e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            if (ses != null) {
                if (destinationItem != null) {
                    try {
                        if (ses.getWorkspace().getLockManager().isLocked(destinationItem.getPath())) {
                            ses.getWorkspace().getLockManager().unlock(destinationItem.getPath());
                        }
                    }
                    catch (Throwable t) {
                        log.warn("error unlocking {}", (Object)destinationItem.getPath(), (Object)t);
                    }
                }
                ses.logout();
            }
        }
    }

    private ContentHandler getContentHandler(InputStream stream, String name, String path) throws Exception {
        MultipleOutputStream mos = new MultipleOutputStream(stream, 2);
        1 mimeTypeDector = new /* Unavailable Anonymous Inner Class!! */;
        2 uploader = new /* Unavailable Anonymous Inner Class!! */;
        Future detectorF = executor.submit(mimeTypeDector);
        Future uploaderF = executor.submit(uploader);
        mos.startWriting();
        ContentHandler handler = (ContentHandler)detectorF.get();
        handler.getContent().setData("jcr:content");
        handler.getContent().setStorageId(((MetaInfo)uploaderF.get()).getStorageId());
        handler.getContent().setSize(Long.valueOf(((MetaInfo)uploaderF.get()).getSize()));
        return handler;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

