/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventJournal;
import javax.jcr.query.Query;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.data.access.storagehub.handlers.ItemHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VREQueryRetriever
implements Callable<List<Item>> {
    private static final Logger logger = LoggerFactory.getLogger(VREQueryRetriever.class);
    private static final int CACHE_DIMENSION = 50;
    private Repository repository;
    private Credentials credentials;
    private Item vreFolder;
    List<Item> cachedList = new ArrayList(50);
    long lastTimestamp = 0L;

    public VREQueryRetriever(Repository repository, Credentials credentials, Item vreFolder) {
        this.repository = repository;
        this.credentials = credentials;
        this.vreFolder = vreFolder;
    }

    @Override
    public List<Item> call() {
        logger.trace("executing recents task");
        Session ses = null;
        if (this.lastTimestamp == 0L) {
            try {
                long start = System.currentTimeMillis();
                ses = this.repository.login(this.credentials);
                String query = String.format("SELECT * FROM [nthl:workspaceLeafItem] AS node WHERE ISDESCENDANTNODE('%s') ORDER BY node.[jcr:lastModified] DESC ", this.vreFolder.getPath());
                logger.trace("query for recents is {}", (Object)query);
                Query jcrQuery = ses.getWorkspace().getQueryManager().createQuery(query, "JCR-SQL2");
                jcrQuery.setLimit(50L);
                this.lastTimestamp = System.currentTimeMillis();
                NodeIterator it = jcrQuery.execute().getNodes();
                logger.trace("query for recents took {}", (Object)(System.currentTimeMillis() - start));
                while (it.hasNext()) {
                    this.cachedList.add(ItemHandler.getItem((Node)it.nextNode(), Arrays.asList("hl:accounting")));
                }
                logger.trace("creating objects took {}", (Object)(System.currentTimeMillis() - start));
                List<Item> list = this.cachedList.subList(0, 10);
                return list;
            }
            catch (Exception e) {
                logger.error("error querying vre {}", (Object)this.vreFolder.getTitle(), (Object)e);
                throw new RuntimeException(e);
            }
            finally {
                if (ses != null) {
                    ses.logout();
                }
                logger.trace("recents task finished");
            }
        }
        try {
            long timestampToUse = this.lastTimestamp;
            this.lastTimestamp = System.currentTimeMillis();
            long start = System.currentTimeMillis();
            ses = this.repository.login(this.credentials);
            String[] types = new String[]{"nthl:workspaceLeafItem", "nthl:workspaceItem"};
            EventJournal journalChanged = ses.getWorkspace().getObservationManager().getEventJournal(50, this.vreFolder.getPath(), true, null, types);
            journalChanged.skipTo(timestampToUse);
            block16: while (journalChanged.hasNext()) {
                Event event = journalChanged.nextEvent();
                switch (event.getType()) {
                    case 16: {
                        Property property;
                        if (!ses.propertyExists(event.getPath()) || !(property = ses.getProperty(event.getPath())).getName().equalsIgnoreCase("jcr:lastModified")) continue block16;
                        logger.trace("event property changed on {} with value {} and parent {}", new Object[]{property.getName(), property.getValue().getString(), property.getParent().getPath()});
                        String identifier = property.getParent().getIdentifier();
                        this.cachedList.removeIf(i -> i.getId().equals(identifier));
                        Item item = ItemHandler.getItem((Node)property.getParent(), Arrays.asList("hl:accounting"));
                        this.insertItemInTheRightPlace(item);
                        break;
                    }
                    case 2: {
                        logger.trace("node removed event received with type {}", (Object)event.getIdentifier());
                        this.cachedList.removeIf(i -> {
                            try {
                                return i.getId().equals(event.getIdentifier()) && i.getLastModificationTime().getTime().getTime() < event.getDate();
                            }
                            catch (RepositoryException e) {
                                return false;
                            }
                        });
                        break;
                    }
                    case 32: {
                        Node nodeMoved = ses.getNode(event.getPath());
                        logger.trace("node moved event received with type {}", (Object)nodeMoved.getPrimaryNodeType());
                        if (!nodeMoved.isNodeType("nthl:workspaceLeafItem")) continue block16;
                        logger.trace("event node moved on {} with path {}", (Object)nodeMoved.getName(), (Object)nodeMoved.getPath());
                        String identifier = nodeMoved.getIdentifier();
                        this.cachedList.removeIf(i -> i.getId().equals(identifier) && !i.getPath().startsWith(this.vreFolder.getPath()));
                        break;
                    }
                    default: {
                        throw new Exception("error in event handling");
                    }
                }
            }
            if (this.cachedList.size() > 50) {
                this.cachedList.subList(51, this.cachedList.size()).clear();
            }
            logger.trace("retrieving event took {}", (Object)(System.currentTimeMillis() - start));
            List<Item> list = this.cachedList.subList(0, 10);
            return list;
        }
        catch (Exception e) {
            logger.error("error getting events for vre {}", (Object)this.vreFolder.getTitle(), (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    private void insertItemInTheRightPlace(Item item) {
        Iterator it = this.cachedList.iterator();
        int index = 0;
        while (it.hasNext()) {
            Item inListItem = (Item)it.next();
            if (item.getLastModificationTime().getTime().getTime() >= inListItem.getLastModificationTime().getTime().getTime()) break;
            ++index;
        }
        if (index < 50) {
            this.cachedList.add(index, item);
        }
    }
}

