/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.handlers;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.value.BinaryValue;
import org.apache.jackrabbit.value.BooleanValue;
import org.apache.jackrabbit.value.DateValue;
import org.apache.jackrabbit.value.LongValue;
import org.apache.jackrabbit.value.StringValue;
import org.gcube.common.storagehub.model.annotations.Attribute;
import org.gcube.common.storagehub.model.annotations.AttributeRootNode;
import org.gcube.common.storagehub.model.annotations.ListNodes;
import org.gcube.common.storagehub.model.annotations.MapAttribute;
import org.gcube.common.storagehub.model.annotations.NodeAttribute;
import org.gcube.common.storagehub.model.annotations.RootNode;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.data.access.storagehub.handlers.ClassHandler;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ItemHandler {
    private static final Logger logger = LoggerFactory.getLogger(ItemHandler.class);
    private static ClassHandler classHandler = new ClassHandler();
    private static HashMap<Class, Map<String, Class>> typeToSubtypeMap = new HashMap();

    public static <T extends Item> T getItem(Node node, List<String> excludes) throws Exception {
        Class classToHandle = classHandler.get(node.getPrimaryNodeType().getName());
        Item item = (Item)classToHandle.newInstance();
        item.setId(node.getIdentifier());
        item.setName(Text.unescapeIllegalJcrChars((String)node.getName()));
        item.setPath(Text.unescapeIllegalJcrChars((String)node.getPath()));
        item.setLocked(node.isLocked());
        item.setPrimaryType(node.getPrimaryNodeType().getName());
        Item parent = null;
        if (item instanceof SharedFolder) {
            logger.debug("I'm in a Shared Folder");
            item.setShared(true);
        } else {
            try {
                parent = ItemHandler.getItem((Node)node.getParent(), Arrays.asList("hl:accounting", "jcr:content"));
                item.setShared(parent.isShared());
            }
            catch (Exception e) {
                item.setShared(false);
            }
        }
        if (item instanceof TrashItem) {
            item.setTrashed(true);
        } else {
            try {
                if (parent == null) {
                    parent = ItemHandler.getItem((Node)node.getParent(), Arrays.asList("hl:accounting", "jcr:content"));
                }
                item.setTrashed(parent.isTrashed());
            }
            catch (Exception e) {
                item.setTrashed(false);
            }
        }
        try {
            item.setParentId(node.getParent().getIdentifier());
            item.setParentPath(node.getParent().getPath());
        }
        catch (Throwable e) {
            logger.info("Root node doesn't have a parent");
        }
        for (Field field : ItemHandler.retrieveAllFields((Class)classToHandle)) {
            if (field.isAnnotationPresent(Attribute.class)) {
                Attribute attribute = field.getAnnotation(Attribute.class);
                field.setAccessible(true);
                try {
                    Class<?> returnType = field.getType();
                    field.set(item, ItemHandler.getPropertyValue(returnType, (Property)node.getProperty(attribute.value())));
                }
                catch (PathNotFoundException e) {
                    logger.debug("the current node dosn't contain {} property", (Object)attribute.value());
                }
                catch (Exception e) {
                    logger.warn("error setting value for property {} ", (Object)attribute.value());
                }
                continue;
            }
            if (!field.isAnnotationPresent(NodeAttribute.class)) continue;
            String fieldNodeName = field.getAnnotation(NodeAttribute.class).value();
            if (excludes != null && excludes.contains(fieldNodeName)) continue;
            logger.debug("retrieving field node " + field.getName());
            field.setAccessible(true);
            try {
                Node fieldNode = node.getNode(fieldNodeName);
                logger.debug("looking in node {} searched with {}", (Object)fieldNode.getName(), (Object)fieldNodeName);
                field.set(item, ItemHandler.iterateNodeAttributeFields(field.getType(), (Node)fieldNode));
            }
            catch (PathNotFoundException e) {
                logger.debug("the current node dosn't contain {} node", (Object)fieldNodeName);
            }
            catch (Exception e) {
                logger.warn("error setting value", (Throwable)e);
            }
        }
        return (T)item;
    }

    private static <T> T iterateNodeAttributeFields(Class<T> clazz, Node node) throws Exception {
        T obj = clazz.newInstance();
        for (Field field : ItemHandler.retrieveAllFields(clazz)) {
            String exclude;
            if (field.isAnnotationPresent(Attribute.class)) {
                Attribute attribute = field.getAnnotation(Attribute.class);
                field.setAccessible(true);
                try {
                    Class<?> returnType = field.getType();
                    field.set(obj, ItemHandler.getPropertyValue(returnType, (Property)node.getProperty(attribute.value())));
                }
                catch (PathNotFoundException e) {
                    logger.trace("the current node dosn't contain {} property", (Object)attribute.value());
                }
                catch (Exception e) {
                    logger.warn("error setting value", (Throwable)e);
                }
                continue;
            }
            if (field.isAnnotationPresent(MapAttribute.class)) {
                logger.trace("found field {} of type annotated as MapAttribute in class {} and node name {}", new Object[]{field.getName(), clazz.getName(), node.getName()});
                field.setAccessible(true);
                exclude = field.getAnnotation(MapAttribute.class).excludeStartWith();
                HashMap<String, Object> mapToset = new HashMap<String, Object>();
                PropertyIterator iterator = node.getProperties();
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        Property prop = iterator.nextProperty();
                        if (!exclude.isEmpty() && prop.getName().startsWith(exclude)) continue;
                        try {
                            logger.trace("adding {} in the map", (Object)prop.getName());
                            mapToset.put(prop.getName(), ItemHandler.getPropertyValue((Property)prop));
                        }
                        catch (PathNotFoundException e) {
                            logger.warn("the property {}  is not mapped", (Object)prop.getName(), (Object)e);
                        }
                        catch (Exception e) {
                            logger.warn("error setting value", (Throwable)e);
                        }
                    }
                }
                field.set(obj, mapToset);
                continue;
            }
            if (!field.isAnnotationPresent(ListNodes.class)) continue;
            logger.trace("found field {} of type annotated as ListNodes in class {} on node {}", new Object[]{field.getName(), clazz.getName(), node.getName()});
            field.setAccessible(true);
            exclude = field.getAnnotation(ListNodes.class).excludeTypeStartWith();
            String include = field.getAnnotation(ListNodes.class).includeTypeStartWith();
            Class listType = field.getAnnotation(ListNodes.class).listClass();
            HashMap<String, Class> subTypesMap = Collections.emptyMap();
            if (!typeToSubtypeMap.containsKey(listType)) {
                ConfigurationBuilder config = new ConfigurationBuilder().forPackages(new String[]{listType.getPackage().getName()});
                Reflections reflections = new Reflections((Configuration)config);
                Set subTypes = reflections.getSubTypesOf(listType);
                if (subTypes.size() > 0) {
                    subTypesMap = new HashMap<String, Class>();
                    for (Class subtype : subTypes) {
                        if (!subtype.isAnnotationPresent(AttributeRootNode.class)) continue;
                        AttributeRootNode attributeRootNode = subtype.getAnnotation(AttributeRootNode.class);
                        subTypesMap.put(attributeRootNode.value(), subtype);
                    }
                } else {
                    logger.trace("no subtypes found for {}", (Object)listType.getName());
                }
                typeToSubtypeMap.put(listType, subTypesMap);
            } else {
                logger.info("subtypes already found in cache");
                subTypesMap = (HashMap<String, Class>)typeToSubtypeMap.get(listType);
            }
            ArrayList<Object> toSetList = new ArrayList<Object>();
            NodeIterator iterator = node.getNodes();
            while (iterator.hasNext()) {
                Node currentNode = iterator.nextNode();
                String primaryType = currentNode.getPrimaryNodeType().getName();
                logger.trace("the current node {} has a list", (Object)currentNode.getName());
                if (!include.isEmpty() && !primaryType.startsWith(include) || !exclude.isEmpty() && primaryType.startsWith(exclude)) continue;
                if (subTypesMap.containsKey(primaryType)) {
                    toSetList.add(ItemHandler.iterateNodeAttributeFields((Class)((Class)subTypesMap.get(primaryType)), (Node)currentNode));
                    continue;
                }
                toSetList.add(ItemHandler.iterateNodeAttributeFields((Class)listType, (Node)currentNode));
            }
            if (toSetList.size() == 0) continue;
            field.set(obj, toSetList);
        }
        return obj;
    }

    private static Object getPropertyValue(Class returnType, Property prop) throws Exception {
        if (returnType.equals(String.class)) {
            return prop.getString();
        }
        if (returnType.isEnum()) {
            return Enum.valueOf(returnType, prop.getString());
        }
        if (returnType.equals(Calendar.class)) {
            return prop.getDate();
        }
        if (returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE)) {
            return prop.getBoolean();
        }
        if (returnType.equals(Long.class) || returnType.equals(Long.TYPE)) {
            return prop.getLong();
        }
        if (returnType.equals(Integer.class) || returnType.equals(Integer.TYPE)) {
            return prop.getLong();
        }
        if (returnType.isArray()) {
            if (prop.getType() == 2) {
                byte[] bytes = new byte[32000];
                try (InputStream stream = prop.getBinary().getStream();){
                    stream.read(bytes);
                }
                return bytes;
            }
            Object[] ret = ItemHandler.getArrayValue((Property)prop);
            return Arrays.copyOf(ret, ret.length, returnType);
        }
        throw new Exception(String.format("class %s not recognized", returnType.getName()));
    }

    private static Value getObjectValue(Class returnType, Object value) throws Exception {
        if (returnType.equals(String.class)) {
            return new StringValue((String)value);
        }
        if (returnType.isEnum()) {
            return new StringValue(((Enum)value).toString());
        }
        if (returnType.equals(Calendar.class)) {
            return new DateValue((Calendar)value);
        }
        if (returnType.equals(Boolean.class) || returnType.equals(Boolean.TYPE)) {
            return new BooleanValue((Boolean)value);
        }
        if (returnType.equals(Long.class) || returnType.equals(Long.TYPE)) {
            return new LongValue((Long)value);
        }
        if (returnType.equals(Integer.class) || returnType.equals(Integer.TYPE)) {
            return new LongValue((Long)value);
        }
        if (returnType.isArray() && (returnType.getComponentType().equals(Byte.class) || returnType.getComponentType().equals(Byte.TYPE))) {
            return new BinaryValue((byte[])value);
        }
        throw new Exception(String.format("class %s not recognized", returnType.getName()));
    }

    private static Object[] getArrayValue(Property prop) throws Exception {
        Object[] values = new Object[prop.getValues().length];
        int i = 0;
        for (Value value : prop.getValues()) {
            values[i++] = ItemHandler.getSingleValue((Value)value);
        }
        return values;
    }

    private static Object getPropertyValue(Property prop) throws Exception {
        if (prop.isMultiple()) {
            Object[] values = new Object[prop.getValues().length];
            int i = 0;
            for (Value value : prop.getValues()) {
                values[i++] = ItemHandler.getSingleValue((Value)value);
            }
            return values;
        }
        return ItemHandler.getSingleValue((Value)prop.getValue());
    }

    private static Object getSingleValue(Value value) throws Exception {
        switch (value.getType()) {
            case 5: {
                return value.getDate();
            }
            case 6: {
                return value.getBoolean();
            }
            case 3: {
                return value.getDate();
            }
        }
        return value.getString();
    }

    private static Set<Field> retrieveAllFields(Class<?> clazz) {
        HashSet<Field> fields = new HashSet<Field>();
        Class<?> currentClass = clazz;
        do {
            List<Field> fieldsFound = Arrays.asList(currentClass.getDeclaredFields());
            fields.addAll(fieldsFound);
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return fields;
    }

    public static <T extends Item> Node createNodeFromItem(Session session, Node parentNode, T item) {
        try {
            String primaryType = classHandler.getNodeType(item.getClass());
            Node newNode = parentNode.addNode(item.getTitle(), primaryType);
            for (Field field : ItemHandler.retrieveAllFields(item.getClass())) {
                NodeAttribute nodeAttribute;
                if (field.isAnnotationPresent(Attribute.class)) {
                    Attribute attribute = field.getAnnotation(Attribute.class);
                    if (attribute.isReadOnly()) continue;
                    field.setAccessible(true);
                    try {
                        newNode.setProperty(attribute.value(), ItemHandler.getObjectValue(field.getType(), (Object)field.get(item)));
                    }
                    catch (Exception e) {
                        logger.warn("error setting value for attribute " + attribute.value(), (Throwable)e);
                    }
                    continue;
                }
                if (!field.isAnnotationPresent(NodeAttribute.class) || (nodeAttribute = field.getAnnotation(NodeAttribute.class)).isReadOnly()) continue;
                String nodeName = nodeAttribute.value();
                logger.debug("retrieving field node " + field.getName());
                field.setAccessible(true);
                try {
                    ItemHandler.iterateItemNodeAttributeFields((Object)field.get(item), (Node)newNode, (String)nodeName);
                }
                catch (Exception e) {
                    logger.warn("error setting value", (Throwable)e);
                }
            }
            return newNode;
        }
        catch (RepositoryException e) {
            logger.error("error writing repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void iterateItemNodeAttributeFields(Object object, Node parentNode, String nodeName) throws Exception {
        AttributeRootNode attributeRootNode = object.getClass().getAnnotation(AttributeRootNode.class);
        Node newNode = parentNode.addNode(nodeName, attributeRootNode.value());
        for (Field field : ItemHandler.retrieveAllFields(object.getClass())) {
            if (field.isAnnotationPresent(Attribute.class)) {
                Attribute attribute = field.getAnnotation(Attribute.class);
                if (attribute.isReadOnly()) continue;
                field.setAccessible(true);
                try {
                    Class<?> returnType = field.getType();
                    newNode.setProperty(attribute.value(), ItemHandler.getObjectValue(returnType, (Object)field.get(object)));
                }
                catch (Exception e) {
                    logger.warn("error setting value", (Throwable)e);
                }
                continue;
            }
            if (field.isAnnotationPresent(MapAttribute.class)) {
                field.setAccessible(true);
                Map mapToset = (Map)field.get(object);
                for (Map.Entry entry : mapToset.entrySet()) {
                    try {
                        newNode.setProperty((String)entry.getKey(), ItemHandler.getObjectValue(entry.getValue().getClass(), entry.getValue()));
                    }
                    catch (Exception e) {
                        logger.warn("error setting value", (Throwable)e);
                    }
                }
                continue;
            }
            if (!field.isAnnotationPresent(ListNodes.class)) continue;
            logger.debug("found field {} of type annotated as ListNodes in class {} on node {}", new Object[]{field.getName(), object.getClass().getName(), newNode.getName()});
            field.setAccessible(true);
            List toSetList = (List)field.get(object);
            int i = 0;
            for (Object obj : toSetList) {
                logger.debug("the current node {} has a list", (Object)newNode.getName());
                ItemHandler.iterateItemNodeAttributeFields(obj, (Node)newNode, (String)(field.getName() + i++));
            }
        }
    }

    public static <F extends AbstractFileItem> void replaceContent(Session session, Node node, F item) {
        try {
            node.setPrimaryType(item.getClass().getAnnotation(RootNode.class).value());
            Node contentNode = node.getNode("jcr:content");
            contentNode.setPrimaryType(item.getContent().getClass().getAnnotation(AttributeRootNode.class).value());
            for (Field field : ItemHandler.retrieveAllFields(item.getContent().getClass())) {
                Attribute attribute;
                if (!field.isAnnotationPresent(Attribute.class) || (attribute = field.getAnnotation(Attribute.class)).isReadOnly()) continue;
                field.setAccessible(true);
                try {
                    contentNode.setProperty(attribute.value(), ItemHandler.getObjectValue(field.getType(), (Object)field.get(item.getContent())));
                }
                catch (Exception e) {
                    logger.warn("error setting value for attribute " + attribute.value(), (Throwable)e);
                }
            }
        }
        catch (RepositoryException e) {
            logger.error("error writing repository", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

