/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;
import org.gcube.data.access.storagehub.MultipleOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipleOutputStream {
    private Logger logger = LoggerFactory.getLogger(MultipleOutputStream.class);
    private MyPipedInputStream[] pipedInStreams;
    private InputStream is;
    private MyPipedOututStream[] pipedOutStreams;
    private int index = 0;

    public MultipleOutputStream(InputStream is, int number) throws IOException {
        this.is = is;
        this.logger.debug("requested {} piped streams ", (Object)number);
        this.pipedInStreams = new MyPipedInputStream[number];
        this.pipedOutStreams = new MyPipedOututStream[number];
        for (int i = 0; i < number; ++i) {
            this.pipedOutStreams[i] = new MyPipedOututStream(this);
            this.pipedInStreams[i] = new MyPipedInputStream(this, (PipedOutputStream)this.pipedOutStreams[i]);
        }
    }

    public void startWriting() throws Exception {
        try (BufferedInputStream bis = new BufferedInputStream(this.is);){
            int i;
            byte[] buf = new byte[65536];
            int read = -1;
            int writeTot = 0;
            while ((read = bis.read(buf)) != -1) {
                for (i = 0; i < this.pipedInStreams.length; ++i) {
                    if (this.pipedInStreams[i].isClosed()) continue;
                    this.logger.debug("writing into piped stream {}  ", (Object)i);
                    this.pipedOutStreams[i].write(buf, 0, read);
                }
                writeTot += read;
                if (this.allOutStreamClosed()) {
                    this.logger.debug("all streams created are closed");
                    break;
                }
                this.logger.debug("NOT all streams created are closed");
            }
            for (i = 0; i < this.pipedOutStreams.length; ++i) {
                if (this.pipedOutStreams[i].isClosed()) continue;
                this.logger.debug("closing outputstream {}", (Object)i);
                this.pipedOutStreams[i].close();
            }
            this.logger.debug("total written " + writeTot);
        }
    }

    private boolean allOutStreamClosed() {
        for (int i = 0; i < this.pipedOutStreams.length; ++i) {
            if (this.pipedOutStreams[i].isClosed()) continue;
            return false;
        }
        return true;
    }

    public synchronized InputStream get() {
        this.logger.debug("requesting piped streams {}", (Object)this.index);
        if (this.index >= this.pipedInStreams.length) {
            return null;
        }
        return this.pipedInStreams[this.index++];
    }

    static /* synthetic */ Logger access$000(MultipleOutputStream x0) {
        return x0.logger;
    }
}

