/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub.services;

import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.CalledMethodProvider;
import org.gcube.common.storagehub.model.Paths;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.common.storagehub.model.items.TrashItem;
import org.gcube.common.storagehub.model.items.VreFolder;
import org.gcube.common.storagehub.model.service.ItemList;
import org.gcube.common.storagehub.model.service.ItemWrapper;
import org.gcube.common.storagehub.model.types.ItemAction;
import org.gcube.data.access.storagehub.AuthorizationChecker;
import org.gcube.data.access.storagehub.Constants;
import org.gcube.data.access.storagehub.Range;
import org.gcube.data.access.storagehub.SingleFileStreamingOutput;
import org.gcube.data.access.storagehub.Utils;
import org.gcube.data.access.storagehub.accounting.AccountingHandler;
import org.gcube.data.access.storagehub.handlers.ItemHandler;
import org.gcube.data.access.storagehub.services.ItemsManager;
import org.gcube.data.access.storagehub.services.RepositoryInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="item")
public class ItemsManager {
    private static final Logger log = LoggerFactory.getLogger(ItemsManager.class);
    @Inject
    RepositoryInitializer repository;
    @Inject
    AccountingHandler accountingHandler;
    @RequestScoped
    @PathParam(value="id")
    String id;
    @Context
    ServletContext context;
    @Inject
    AuthorizationChecker authChecker;

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json"})
    public ItemWrapper<Item> getById(@QueryParam(value="exclude") List<String> excludes) {
        CalledMethodProvider.instance.set("getById");
        Session ses = null;
        Item toReturn = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = ItemHandler.getItem((Node)ses.getNodeByIdentifier(this.id), excludes);
        }
        catch (Throwable e) {
            log.error("error reading the node children of {}", (Object)this.id, (Object)e);
            throw new WebApplicationException(e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemWrapper(toReturn);
    }

    @GET
    @Path(value="{id}/children/count")
    @Produces(value={"application/json"})
    public Long countById(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="exclude") List<String> excludes) {
        CalledMethodProvider.instance.set("countById");
        Session ses = null;
        Long toReturn = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = Utils.getItemCount((Node)ses.getNodeByIdentifier(this.id), (boolean)(showHidden == null ? false : showHidden));
        }
        catch (Throwable e) {
            log.error("error reading the node children of {}", (Object)this.id, (Object)e);
            throw new WebApplicationException(e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return toReturn;
    }

    @GET
    @Path(value="{id}/children")
    @Produces(value={"application/json"})
    public ItemList listById(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="exclude") List<String> excludes) {
        CalledMethodProvider.instance.set("listById");
        Session ses = null;
        List toReturn = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = Utils.getItemList((Node)ses.getNodeByIdentifier(this.id), excludes, null, (boolean)(showHidden == null ? false : showHidden));
        }
        catch (Throwable e) {
            log.error("error reading the node children of {}", (Object)this.id, (Object)e);
            throw new WebApplicationException(e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemList(toReturn);
    }

    @GET
    @Path(value="{id}/children/paged")
    @Produces(value={"application/json"})
    public ItemList listByIdPaged(@QueryParam(value="showHidden") Boolean showHidden, @QueryParam(value="start") Integer start, @QueryParam(value="limit") Integer limit, @QueryParam(value="exclude") List<String> excludes) {
        CalledMethodProvider.instance.set("listByIdPaged");
        Session ses = null;
        List toReturn = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            toReturn = Utils.getItemList((Node)ses.getNodeByIdentifier(this.id), excludes, (Range)new Range(start.intValue(), limit.intValue()), (boolean)(showHidden == null ? false : showHidden));
        }
        catch (Throwable e) {
            log.error("error reading the node children of {}", (Object)this.id, (Object)e);
            throw new WebApplicationException(e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return new ItemList(toReturn);
    }

    @GET
    @Path(value="{id}/publiclink")
    public URL getPubliclink() {
        CalledMethodProvider.instance.set("getPubliclink");
        Session ses = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            String url = Utils.getStorageClient((String)login).getClient().getHttpsUrl().RFileById(this.id);
            URL uRL = new URL(url);
            return uRL;
        }
        catch (Throwable e) {
            log.error("error reading the node children of {}", (Object)this.id, (Object)e);
            throw new WebApplicationException(e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @GET
    @Path(value="{id}/anchestors")
    @Produces(value={"application/json"})
    public ItemList getAnchestors(@QueryParam(value="exclude") List<String> excludes) {
        CalledMethodProvider.instance.set("getAnchestors");
        org.gcube.common.storagehub.model.Path absolutePath = Utils.getHomePath();
        Session ses = null;
        LinkedList<Item> toReturn = new LinkedList<Item>();
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(login, Utils.getSecurePassword((String)login).toCharArray()));
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            Item currentItem = ItemHandler.getItem((Node)ses.getNodeByIdentifier(this.id), excludes);
            log.trace("current node is {}", (Object)currentItem.getPath());
            while (!(currentItem.getPath() + "/").equals(absolutePath.toPath())) {
                if (currentItem instanceof SharedFolder) {
                    Map users = ((SharedFolder)currentItem).getUsers().getValues();
                    String[] user = ((String)users.get(login)).split("/");
                    String parentId = user[0];
                    currentItem = ItemHandler.getItem((Node)ses.getNodeByIdentifier(parentId), excludes);
                } else {
                    currentItem = ItemHandler.getItem((Node)ses.getNodeByIdentifier(currentItem.getParentId()), excludes);
                }
                log.trace("current node is {}", (Object)currentItem.getPath());
                toReturn.add(currentItem);
            }
        }
        catch (Throwable e) {
            log.error("error retrieving parents of node with id {}", (Object)this.id, (Object)e);
            throw new WebApplicationException(e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        log.trace("item list to return is empty ? {}", (Object)toReturn.isEmpty());
        return new ItemList(toReturn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @GET
    @Path(value="{id}/download")
    public Response download() {
        CalledMethodProvider.instance.set("downloadById");
        Session ses = null;
        try {
            Response response;
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(this.context.getInitParameter("admin-username"), this.context.getInitParameter("admin-pwd").toCharArray()));
            Node node = ses.getNodeByIdentifier(this.id);
            this.authChecker.checkReadAuthorizationControl(ses, this.id);
            Item item = ItemHandler.getItem((Node)node, null);
            if (item instanceof AbstractFileItem) {
                AbstractFileItem fileItem = (AbstractFileItem)item;
                InputStream streamToWrite = Utils.getStorageClient((String)login).getClient().get().RFileAsInputStream(fileItem.getContent().getStorageId());
                this.accountingHandler.createReadObj(fileItem.getTitle(), ses, node, true);
                SingleFileStreamingOutput so = new SingleFileStreamingOutput(streamToWrite);
                Response response2 = Response.ok((Object)so).header("content-disposition", (Object)("attachment; filename = " + fileItem.getName())).header("Content-Length", (Object)fileItem.getContent().getSize()).build();
                return response2;
            }
            if (!(item instanceof FolderItem)) throw new Exception("item type not supported for download: " + item.getClass());
            try {
                Deque allNodes = Utils.getAllNodesForZip((FolderItem)((FolderItem)item), (Session)ses, (AccountingHandler)this.accountingHandler);
                org.gcube.common.storagehub.model.Path originalPath = Paths.getPath((String)item.getPath());
                1 so = new /* Unavailable Anonymous Inner Class!! */;
                response = Response.ok((Object)so).header("content-disposition", (Object)"attachment; filename = directory.zip").header("Content-Length", (Object)-1L).build();
                if (ses == null) return response;
            }
            catch (Throwable throwable) {
                try {
                    if (ses == null) throw throwable;
                    ses.save();
                    throw throwable;
                }
                catch (Exception e) {
                    log.error("error downloading item content", (Throwable)e);
                    throw new WebApplicationException((Throwable)e);
                }
            }
            ses.save();
            return response;
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
    }

    @PUT
    @Path(value="{id}/move")
    public Response move(@QueryParam(value="destinationId") String destinationId, @PathParam(value="id") String identifier) {
        CalledMethodProvider.instance.set("move");
        Session ses = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(this.context.getInitParameter("admin-username"), this.context.getInitParameter("admin-pwd").toCharArray()));
            this.authChecker.checkWriteAuthorizationControl(ses, destinationId, true);
            this.authChecker.checkWriteAuthorizationControl(ses, identifier, false);
            Node nodeToMove = ses.getNodeByIdentifier(identifier);
            Node destination = ses.getNodeByIdentifier(destinationId);
            Item destinationItem = ItemHandler.getItem((Node)destination, null);
            Item item = ItemHandler.getItem((Node)nodeToMove, null);
            if (item instanceof SharedFolder || item.isHidden() || destinationItem.isHidden()) {
                throw new Exception("shared folder cannot be moved or cannot not move hidden item");
            }
            if (Constants.FOLDERS_TO_EXLUDE.contains(item.getTitle()) || Constants.FOLDERS_TO_EXLUDE.contains(destinationItem.getTitle())) {
                throw new Exception("protected folder cannot be moved");
            }
            ses.getWorkspace().getLockManager().lock(destinationItem.getPath(), true, true, 0L, login);
            ses.getWorkspace().getLockManager().lock(nodeToMove.getPath(), true, true, 0L, login);
            if (item instanceof FolderItem) {
                if (this.hasSharedChildren((FolderItem)item, ses)) {
                    throw new Exception("folder item with shared children cannot be moved");
                }
                ses.getWorkspace().move(nodeToMove.getPath(), destination.getPath() + "/" + nodeToMove.getName());
            } else {
                ses.getWorkspace().move(nodeToMove.getPath(), destination.getPath() + "/" + nodeToMove.getName());
            }
            ses.getWorkspace().getLockManager().unlock(nodeToMove.getPath());
            ses.getWorkspace().getLockManager().unlock(destinationItem.getPath());
            ses.save();
        }
        catch (Exception e) {
            log.error("error moving item with id {} in item with id {}", new Object[]{identifier, destinationId, e});
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{id}/moveToTrash")
    public Response moveToTrash(@PathParam(value="id") String identifier) {
        CalledMethodProvider.instance.set("moveToTrash");
        Session ses = null;
        try {
            String login = AuthorizationProvider.instance.get().getClient().getId();
            ses = this.repository.getRepository().login((Credentials)new SimpleCredentials(this.context.getInitParameter("admin-username"), this.context.getInitParameter("admin-pwd").toCharArray()));
            this.authChecker.checkWriteAuthorizationControl(ses, identifier, false);
            Node nodeToDelete = ses.getNodeByIdentifier(identifier);
            Node trashFolder = ses.getNode(Paths.append((org.gcube.common.storagehub.model.Path)Utils.getHomePath(), (String)"Trash").toPath());
            Item item = ItemHandler.getItem((Node)nodeToDelete, null);
            if (item instanceof SharedFolder || item instanceof VreFolder || item instanceof FolderItem && this.hasSharedChildren((FolderItem)item, ses)) {
                throw new Exception("SharedFolder, VreFolder or folders with shared children cannot be deleted");
            }
            try {
                ses.getWorkspace().getLockManager().lock(trashFolder.getPath(), true, true, 0L, login);
                ses.getWorkspace().getLockManager().lock(nodeToDelete.getPath(), true, true, 0L, login);
                TrashItem trashItem = new TrashItem();
                trashItem.setDeletedBy(AuthorizationProvider.instance.get().getClient().getId());
                trashItem.setDeletedFrom(nodeToDelete.getParent().getPath());
                Calendar now = Calendar.getInstance();
                trashItem.setDeletedTime(now);
                trashItem.setHidden(false);
                trashItem.setLastAction(ItemAction.CREATED);
                trashItem.setDescription("trash item of node " + item.getPath());
                trashItem.setParentId(nodeToDelete.getParent().getIdentifier());
                trashItem.setParentPath(nodeToDelete.getParent().getPath());
                trashItem.setTitle(item.getId());
                trashItem.setOwner(item.getOwner());
                trashItem.setLastModificationTime(item.getLastModificationTime());
                trashItem.setLastModifiedBy(item.getLastModifiedBy());
                if (item instanceof FolderItem) {
                    trashItem.setFolder(Boolean.valueOf(true));
                } else if (item instanceof AbstractFileItem) {
                    AbstractFileItem file = (AbstractFileItem)item;
                    trashItem.setMimeType(file.getContent().getMimeType());
                    trashItem.setLenght(file.getContent().getSize().longValue());
                }
                Node newTrashItemNode = ItemHandler.createNodeFromItem((Session)ses, (Node)trashFolder, (Item)trashItem);
                ses.getWorkspace().move(nodeToDelete.getPath(), Paths.append((org.gcube.common.storagehub.model.Path)Paths.getPath((String)newTrashItemNode.getPath()), (String)nodeToDelete.getName()).toPath());
            }
            finally {
                ses.getWorkspace().getLockManager().unlock(nodeToDelete.getPath());
                ses.getWorkspace().getLockManager().unlock(trashFolder.getPath());
            }
            ses.save();
        }
        catch (Exception e) {
            log.error("error moving item with id {} in Thrash", (Object)identifier, (Object)e);
            throw new WebApplicationException((Throwable)e);
        }
        finally {
            if (ses != null) {
                ses.logout();
            }
        }
        return Response.ok().build();
    }

    private boolean hasSharedChildren(FolderItem item, Session session) throws Exception {
        Node currentNode = session.getNodeByIdentifier(item.getId());
        for (Item children : Utils.getItemList((Node)currentNode, Arrays.asList("hl:accounting", "jcr:content"), null, (boolean)false)) {
            if (!(children instanceof FolderItem)) continue;
            return children instanceof SharedFolder || this.hasSharedChildren(item, session);
        }
        return false;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }
}

