/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.storagehub;

import java.util.Arrays;
import javax.inject.Singleton;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.storagehub.model.acls.AccessType;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.common.storagehub.model.items.SharedFolder;
import org.gcube.data.access.storagehub.handlers.ItemHandler;

@Singleton
public class AuthorizationChecker {
    public void checkReadAuthorizationControl(Session session, String id) throws Exception {
        SharedFolder parentShared;
        Node node = session.getNodeByIdentifier(id);
        Item item = ItemHandler.getItem((Node)node, Arrays.asList("hl:accounting", "jcr:content"));
        if (item.isShared() ? !(parentShared = this.retrieveSharedFolderParent(item, session)).getUsers().getValues().containsKey(AuthorizationProvider.instance.get().getClient().getId()) : !item.getOwner().equals(AuthorizationProvider.instance.get().getClient().getId())) {
            throw new IllegalAccessException("Insufficent Provileges to read node with id " + id);
        }
    }

    private SharedFolder retrieveSharedFolderParent(Item item, Session session) throws Exception {
        if (item instanceof SharedFolder) {
            return (SharedFolder)item;
        }
        return this.retrieveSharedFolderParent(ItemHandler.getItem((Node)session.getNodeByIdentifier(item.getParentId()), Arrays.asList("hl:accounting", "jcr:content")), session);
    }

    public void checkWriteAuthorizationControl(Session session, String id, boolean isNewItem) throws Exception {
        Node node = session.getNodeByIdentifier(id);
        Item item = ItemHandler.getItem((Node)node, Arrays.asList("hl:accounting", "jcr:content"));
        if (item.isShared()) {
            AccessControlEntry[] entries;
            SharedFolder parentShared = this.retrieveSharedFolderParent(item, session);
            JackrabbitAccessControlList accessControlList = AccessControlUtils.getAccessControlList((Session)session, (String)parentShared.getPath());
            for (AccessControlEntry entry : entries = accessControlList.getAccessControlEntries()) {
                if (!entry.getPrincipal().getName().equals(AuthorizationProvider.instance.get().getClient().getId()) && (!parentShared.isVreFolder() || !entry.getPrincipal().getName().equals(parentShared.getTitle()))) continue;
                for (Privilege privilege : entry.getPrivileges()) {
                    AccessType access = AccessType.valueOf((String)privilege.getName());
                    if (isNewItem && access != AccessType.READ_ONLY) {
                        return;
                    }
                    if (isNewItem || access != AccessType.ADMINISTRATOR && access != AccessType.WRITE_ALL && (access != AccessType.WRITE_OWNER || !item.getOwner().equals(AuthorizationProvider.instance.get().getClient().getId()))) continue;
                    return;
                }
                throw new IllegalAccessException("Insufficent Provileges to write node with id " + id);
            }
        } else if (item.getOwner().equals(AuthorizationProvider.instance.get().getClient().getId())) {
            return;
        }
        throw new IllegalAccessException("Insufficent Provileges to write node with id " + id);
    }
}

