/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.namespace.QName;
import org.gcube.data.speciesplugin.Utils;
import org.gcube.data.speciesplugin.store.SpeciesStore;
import org.gcube.data.tmf.api.Property;
import org.gcube.data.tmf.impl.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeciesSource
extends AbstractSource {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(SpeciesSource.class);
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    protected Lock readLock = this.lock.readLock();
    protected Lock writeLock = this.lock.writeLock();
    private final SpeciesStore store;
    protected final List<Property> properties;

    public SpeciesSource(String id, SpeciesStore store, List<Property> properties) {
        super(id);
        this.store = store;
        this.properties = properties;
    }

    public List<Property> properties() {
        return this.properties;
    }

    public SpeciesStore store() {
        this.readLock.lock();
        try {
            SpeciesStore speciesStore = this.store;
            return speciesStore;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public File switchStore(File newStoreLocation) throws IOException {
        log.trace("switchStore newStoreLocation: {}", (Object)newStoreLocation);
        this.writeLock.lock();
        log.trace("write locked");
        try {
            File oldStoreLocation = this.store.location();
            log.trace("oldStoreLocation {}", (Object)oldStoreLocation);
            log.trace("stopping current store");
            this.store.stop();
            try {
                TimeUnit.MILLISECONDS.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.warn("could not wait for shutdown to complete", (Throwable)e);
            }
            log.trace("store stopped");
            File tmpLocation = Utils.createTempDirectory();
            log.trace("tmpLocation {}", (Object)tmpLocation);
            boolean moved = oldStoreLocation.renameTo(tmpLocation);
            log.trace("moved old store to the tmp location. success? {}", (Object)moved);
            moved = newStoreLocation.renameTo(oldStoreLocation.getParentFile());
            log.trace("moved new store to the old store location. success? {}", (Object)moved);
            log.trace("starting store in {}", (Object)oldStoreLocation);
            this.store.start(oldStoreLocation.getParentFile());
            log.trace("store ready with {} elements", (Object)this.store.cardinality());
            File file = tmpLocation;
            return file;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public synchronized Long cardinality() {
        return this.store.cardinality();
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[" + this.store + "]";
    }

    public List<QName> types() {
        return Collections.singletonList(new QName("http://org.gcube.data.spd", "SPD"));
    }
}

