/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spd.spdtools;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.model.PluginDescription;
import org.gcube.data.spd.model.exceptions.InvalidQueryException;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.model.products.ResultElement;
import org.gcube.data.spd.stubs.exceptions.UnsupportedCapabilityException;
import org.gcube.data.spd.stubs.exceptions.UnsupportedPluginException;
import org.gcube.data.streams.Stream;

public class SpdClient {
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy/M/d");
    private static final SimpleDateFormat isoDateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");

    private static Manager getManager(String scope) {
        ScopeProvider.instance.set(scope);
        Manager manager = (Manager)AbstractPlugin.manager().withTimeout(5, TimeUnit.MINUTES).build();
        return manager;
    }

    public static void listPlugin(String scope) {
        Manager manager = SpdClient.getManager(scope);
        System.out.println("LIST PLUGINS");
        List plugins = manager.getPluginsDescription();
        for (PluginDescription plugin : plugins) {
            System.out.println(plugin.getName());
        }
    }

    public static void saveOccurrences(String scope, String speciesScientificName, String fileName, Calendar fromCal, Calendar toCal, boolean printResults) {
        Manager manager = SpdClient.getManager(scope);
        String[] plugins = new String[]{"OBIS"};
        String[] columns = new String[]{"decimallongitude", "decimallatitude", "eventDate", "modifiedDate"};
        for (String plugin : plugins) {
            try {
                System.out.print(plugin + ": ");
                String query = SpdClient.createQuery(speciesScientificName, plugin, fromCal, toCal);
                System.out.println("\nEXECUTION QUERY: " + query);
                if (printResults) {
                    System.out.println("#) [<plugin>] (<decimallongitude>,<decimallatitude>); <eventDate>; <modified>");
                }
                Stream result = manager.search(query);
                CSVWriter writer = new CSVWriter((Writer)new FileWriter(fileName), ',', '\u0000');
                writer.writeNext(columns);
                int i = 0;
                while (result.hasNext()) {
                    String modifiedDate;
                    String eventDate;
                    ResultElement elem = (ResultElement)result.next();
                    OccurrencePoint op = (OccurrencePoint)elem;
                    double olong = op.getDecimalLongitude();
                    double olat = op.getDecimalLatitude();
                    Calendar eventCalendar = op.getEventDate();
                    Calendar modifiedCalendar = op.getModified();
                    try {
                        eventDate = isoDateFormatter.format(eventCalendar.getTime());
                    }
                    catch (Exception e) {
                        eventDate = "NAN";
                    }
                    try {
                        modifiedDate = isoDateFormatter.format(modifiedCalendar.getTime());
                    }
                    catch (Exception e) {
                        modifiedDate = "NAN";
                    }
                    if (printResults) {
                        System.out.println(i + 1 + ") [" + op.getProvider() + "] (" + olong + "," + olat + "); " + eventDate + "; " + modifiedDate + "  ");
                    }
                    ++i;
                    String[] entries = new String[]{"" + olong, "" + olat, eventDate, modifiedDate};
                    writer.writeNext(entries);
                }
                writer.close();
                System.out.println(i + " rows found");
                System.out.println("File " + new File(fileName).getAbsoluteFile() + " created.");
            }
            catch (InvalidQueryException e) {
                e.printStackTrace();
            }
            catch (UnsupportedPluginException e) {
                e.printStackTrace();
            }
            catch (UnsupportedCapabilityException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static String createQuery(String speciesScientificName, String plugin, Calendar fromCal, Calendar toCal) {
        boolean printAnd;
        StringBuilder query = new StringBuilder();
        query.append("SEARCH BY SN '" + speciesScientificName + "'");
        if (!plugin.contentEquals("ALL PLUGINS")) {
            query.append(" IN " + plugin);
        }
        boolean printWhere = fromCal != null || toCal != null;
        boolean bl = printAnd = fromCal != null && toCal != null;
        if (printWhere) {
            query.append(" WHERE");
        }
        if (fromCal != null) {
            query.append(" eventDate >= '" + dateFormatter.format(fromCal.getTime()) + "'");
        }
        if (printAnd) {
            query.append(" AND");
        }
        if (toCal != null) {
            query.append(" eventDate <= '" + dateFormatter.format(toCal.getTime()) + "'");
        }
        query.append(" RETURN Occurrence");
        return query.toString();
    }
}

