/**
 * 
 */
package org.gcube.spd.spdtools;

import java.util.Calendar;

/**
 * @author Francesco Cerasuolo (francesco.cerasuolo@terradue.com)
 *
 */
public class SpdTools {


	/**
	 * @param args
	 */
	public static void main(String[] args) {
//		String[] args2 = {"-help", "-scope", "/d4science.research-infrastructures.eu/gCubeApps/BiodiversityResearchEnvironment"};
//		String[] args2 = {"plugins"};
//		String[] args2 = {"occurrence", "-species", "sarda sarda", "-file", "/tmp/myFile.csv", "-pr", "-fromDate", "1990-01-01T00:00Z", "-toDate", "2006-01-01T00:00Z"};//, "-fromDate", "2006-01-01T00:00Z", "-toDate", "2006-12-01T00:00Z"};
		
		MainCommand mainCommand = new MainCommand(args);
		
		String scope = mainCommand.getScope();
		
		// help
		if (mainCommand.isHelpCommand() || mainCommand.isError()) {
			if (mainCommand.isOccurrenceCommand())
				mainCommand.occurrenceCommandUsage();
			else if (mainCommand.isListPluginCommand())
				mainCommand.listPluginUsage();
			else
				mainCommand.usage();
			return;
		}
		
		// list plugins command
		if (mainCommand.isListPluginCommand()) {
			SpdClient.listPlugin(scope);
			return;
		}
		
		// occurrence command
		if (mainCommand.isOccurrenceCommand()) {
			OccurrenceCommand occurrenceCommand = mainCommand.getOccurrenceCommand();
			
			// get species list (for now one species)
			String species = occurrenceCommand.getSpecies();
			String fileName = occurrenceCommand.getFileName();
			Calendar fromCal = occurrenceCommand.getFromDate();
			Calendar toCal = occurrenceCommand.getToDate();
			boolean printResults = occurrenceCommand.isPrintResults();
			SpdClient.saveOccurrences(scope, species, fileName, fromCal, toCal, printResults);
			return;
		}
		
		// if noone of these, print usage
		mainCommand.usage();
	}

}
