/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.sharelatex.connector.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.access.sharelatex.connector.User;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
public class Resource {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    private static final String LOGIN_URL_PARAM = "internalLoginUrl";
    private static final String HOST_NAME_PARAM = "hostName";
    private static final String MONGO_DATABASE_PARAM = "mongoDatabaseName";
    private static final String DOCS_COLLECTION_NAME = "docs";
    private static final String PROJECTS_COLLECTION_NAME = "projects";
    private static final String USER_COLLECTION_NAME = "users";
    private static final String NOTIFICATION_COLLECTION_NAME = "notifications";
    private static final String INVITATION_COLLECTION_NAME = "projectInvites";
    private static final String GCUBE_LOGIN_FIELD = "gcube_login";
    private static final String EMAIL_FIELD = "email";
    private static final String SIGNUP_DATE_FIELD = "signUpDate";
    private static final String LAST_LOGGEDIN__FIELD = "lastLoggedIn";
    private static final String LAST_NAME__FIELD = "last_name";
    private static final String FIRST_NAME_FIELD = "first_name";
    private static final String PWD_FIELD = "password";
    private static final String CSRF_TOKEN_FIELD = "_csrf";
    private static final String SHARELATEX_COOKIE_NAME = "sharelatex.sid";
    private static final String USER_ID_COOKIE = "_ga";
    private static String FIRST_PROJECT_NAME = "First Example";
    private static final String SEND_MESSAGE_METHOD = "/messages/write-message";
    private static final String GET_PROFILE_METHOD = "/users/get-profile";
    private static final String TOKEN_COOKIE_NAME = "gcube-key";
    private static final Map<String, ReentrantLock> justRegistered = Collections.synchronizedMap(new WeakHashMap());
    @Context
    ServletContext context;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="connect")
    @GET
    public Response connect(@Context HttpServletRequest request, @Context HttpServletRequest response) {
        ReentrantLock lock = null;
        try {
            String user = AuthorizationProvider.instance.get().getClient().getId();
            log.info("request for connection from {}", (Object)user);
            Map map = justRegistered;
            synchronized (map) {
                if (justRegistered.containsKey(user)) {
                    lock = (ReentrantLock)justRegistered.get(user);
                } else {
                    lock = new ReentrantLock(true);
                    justRegistered.put(user, lock);
                }
            }
            lock.lock();
            String userRealLogin = this.checkUser(user);
            if (userRealLogin == null) {
                log.info("trying to register user {}", (Object)AuthorizationProvider.instance.get().getClient().getId());
                userRealLogin = this.registerUser();
            } else {
                log.info("user {} already exists", (Object)AuthorizationProvider.instance.get().getClient().getId());
            }
            Response response2 = this._connect(userRealLogin, request.isSecure());
            return response2;
        }
        catch (Throwable e) {
            log.error("error trying to connect", e);
            Response response3 = Response.serverError().build();
            return response3;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="project/{projectId}/invite")
    @POST
    public Response invite(@PathParam(value="projectId") String projectId, String payload, @Context HttpServletRequest request, @Context HttpServletRequest response) {
        log.info("inviting user to use project with id {} and payload {}", (Object)projectId, (Object)payload);
        try {
            Cookie[] cookies;
            ObjectMapper mapper = new ObjectMapper();
            Map map = new HashMap();
            map = (Map)mapper.readValue(payload, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            String email = (String)map.get(EMAIL_FIELD);
            log.info("user email found is {}", (Object)email);
            String projectName = this.retrieveProjectNameById(projectId);
            String token = null;
            for (Cookie cookie : cookies = request.getCookies()) {
                if (!cookie.getName().trim().equals(TOKEN_COOKIE_NAME)) continue;
                token = cookie.getValue();
                break;
            }
            AuthorizationEntry entry = Constants.authorizationService().get(token);
            ScopeProvider.instance.set(entry.getContext());
            SecurityTokenProvider.instance.set(token);
            boolean messageSent = this.sendMessage(token, email, projectName);
            if (messageSent) {
                String csrfToken = (String)map.get(CSRF_TOKEN_FIELD);
                String privileges = (String)map.get("privileges");
                log.debug("old payload was {} and new csrf is {} ", (Object)payload, (Object)csrfToken);
                String[] emails = email.split(",");
                this.callSharelatexInviteInternally(entry.getClientInfo().getId(), Arrays.asList(emails), csrfToken, privileges, projectId, projectName);
                Response response2 = Response.ok().build();
                return response2;
            }
            try {
                throw new Exception("error sending message via social networking service");
            }
            catch (Exception e) {
                log.error("error sending invites for a project", (Throwable)e);
                Response response3 = Response.serverError().build();
                return response3;
            }
        }
        finally {
            ScopeProvider.instance.reset();
            SecurityTokenProvider.instance.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callSharelatexInviteInternally(String senderLogin, List<String> emails, String csrfToken, String privileges, String projectId, String projectName) throws Exception {
        String mongoDB = this.context.getInitParameter(MONGO_DATABASE_PARAM);
        try (MongoClient client = this.connectToMongo();){
            MongoDatabase db = client.getDatabase(mongoDB);
            MongoCollection usersCollection = db.getCollection(USER_COLLECTION_NAME);
            BasicDBObject senderIdQuery = new BasicDBObject();
            senderIdQuery.put((Object)GCUBE_LOGIN_FIELD, (Object)senderLogin);
            MongoCursor userCursor = usersCollection.find((Bson)senderIdQuery).iterator();
            if (userCursor.hasNext()) {
                Document userDoc = (Document)userCursor.next();
                String userId = ((ObjectId)userDoc.get((Object)"_id")).toString();
                Calendar now = Calendar.getInstance();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
                String createdAt = sdf.format(now.getTime());
                now.add(2, 1);
                String expires = sdf.format(now.getTime());
                log.debug("found user id for login {} is {}", (Object)senderLogin, (Object)userId);
                String invitationJson = "{\"sendingUserId\" : ObjectId(\"" + userId + "\"), \"projectId\" : ObjectId(\"" + projectId + "\"), \"privileges\" : \"" + privileges + "\",\"expires\" : ISODate(\"" + expires + "\"), \"createdAt\" : ISODate(\"" + createdAt + "\"), \"__v\" : 0 }";
                MongoCollection invitationColl = db.getCollection(INVITATION_COLLECTION_NAME);
                MongoCollection notificationColl = db.getCollection(NOTIFICATION_COLLECTION_NAME);
                ArrayList<Document> invitationDocs = new ArrayList<Document>(emails.size());
                ArrayList<Document> notificationDocs = new ArrayList<Document>(emails.size());
                for (String email : emails) {
                    ObjectId projectInviteId = new ObjectId();
                    Document doc = Document.parse((String)invitationJson);
                    doc.put(EMAIL_FIELD, (Object)email);
                    doc.put("_id", (Object)projectInviteId);
                    doc.put("token", (Object)csrfToken);
                    invitationDocs.add(doc);
                    BasicDBObject receiverQuery = new BasicDBObject();
                    receiverQuery.put((Object)EMAIL_FIELD, (Object)email);
                    userCursor = usersCollection.find((Bson)receiverQuery).iterator();
                    if (!userCursor.hasNext()) continue;
                    userDoc = (Document)userCursor.next();
                    ObjectId receiverId = (ObjectId)userDoc.get((Object)"_id");
                    notificationDocs.add(this.createNotificationDoc(csrfToken, receiverId, senderLogin, expires, projectInviteId.toString(), projectId, projectName));
                }
                invitationColl.insertMany(invitationDocs);
                notificationColl.insertMany(notificationDocs);
            }
        }
    }

    private Document createNotificationDoc(String token, ObjectId receiverId, String userLogin, String expires, String key, String projectId, String projectName) throws Exception {
        String notificationJson = "{ \"key\" : \"project-invite-" + key + "\", \"messageOpts\" : { \"userName\" : \"" + userLogin + "\", \"projectName\" : \"" + projectName + "\", \"projectId\" : ObjectId(\"" + projectId + "\"), \"token\" : \"" + token + "\" },\"templateKey\" : \"notification_project_invite\", \"expires\" : ISODate(\"" + expires + "\") }";
        Document notificationDoc = Document.parse((String)notificationJson);
        notificationDoc.put("user_id", (Object)receiverId);
        return notificationDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String retrieveProjectNameById(String projectId) throws Exception {
        String mongoDB = this.context.getInitParameter(MONGO_DATABASE_PARAM);
        try (MongoClient client = this.connectToMongo();){
            MongoDatabase db = client.getDatabase(mongoDB);
            MongoCollection projectCollection = db.getCollection(PROJECTS_COLLECTION_NAME);
            BasicDBObject whereQuery = new BasicDBObject();
            whereQuery.put((Object)"_id", (Object)new ObjectId(projectId));
            MongoCursor cursor = projectCollection.find((Bson)whereQuery).iterator();
            if (!cursor.hasNext()) {
                throw new Exception("project with id " + projectId + " not found");
            }
            Document project = (Document)cursor.next();
            String string = (String)project.get((Object)"name");
            return string;
        }
    }

    @Path(value="disconnect")
    @GET
    public Response disconnect(@Context HttpServletRequest request) {
        try {
            log.info("request for disconnection ");
            Cookie[] cookies = request.getCookies();
            NewCookie[] newCookies = new NewCookie[3];
            int index = 0;
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    String name = cookie.getName();
                    if (!name.trim().equals(SHARELATEX_COOKIE_NAME) && !name.trim().equals(USER_ID_COOKIE) && !name.trim().equals(TOKEN_COOKIE_NAME)) continue;
                    newCookies[index++] = new NewCookie(name, null, "/", cookie.getDomain(), cookie.getVersion(), cookie.getComment(), 0, !cookie.isHttpOnly());
                    log.debug("SHARELATEX cookie found");
                }
                return Response.ok((Object)this.context.getClassLoader().getResourceAsStream("logout.html")).cookie(newCookies).build();
            }
            return Response.ok((Object)this.context.getClassLoader().getResourceAsStream("logout.html")).build();
        }
        catch (Throwable e) {
            log.error("error disconnecting", e);
            return Response.serverError().build();
        }
    }

    private Response _connect(String userRealLogin, boolean isSecureRequest) {
        String hostName = this.context.getInitParameter(HOST_NAME_PARAM);
        String loginUrl = this.context.getInitParameter(LOGIN_URL_PARAM);
        String setCookies = "";
        HttpClient httpClient = new HttpClient();
        try {
            String csrfToken = this.retrieveCsrfToken(httpClient, loginUrl);
            setCookies = this.retrieveSharelatexCookie(httpClient, loginUrl, csrfToken, userRealLogin);
        }
        catch (Exception e) {
            log.error("cannot retrieve csrf token", (Throwable)e);
            return Response.serverError().build();
        }
        String redirectUrl = "http" + (isSecureRequest ? "s" : "") + "://" + hostName + "/project";
        List newCookies = this.elaborateCookies(setCookies);
        try {
            return Response.seeOther((URI)new URI(redirectUrl)).cookie(newCookies.toArray(new NewCookie[newCookies.size()])).build();
        }
        catch (Exception e) {
            log.error("error trying to login", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private List<NewCookie> elaborateCookies(String setCookies) {
        String[] cookies;
        ArrayList<NewCookie> newCookies = new ArrayList<NewCookie>();
        for (String cookie : cookies = setCookies.split(",", 2)) {
            String[] singleValues = cookie.split(";");
            String[] nameAndValue = singleValues[0].split("=");
            if (!nameAndValue[0].trim().equals(SHARELATEX_COOKIE_NAME)) continue;
            String pathValue = singleValues[1].split("=")[1].trim();
            newCookies.add(new NewCookie(nameAndValue[0].trim(), nameAndValue[1].trim(), pathValue, null, null, -1, false));
        }
        log.info("creating {} with token {}", (Object)TOKEN_COOKIE_NAME, (Object)SecurityTokenProvider.instance.get());
        newCookies.add(new NewCookie(TOKEN_COOKIE_NAME, SecurityTokenProvider.instance.get(), "/", null, null, -1, true));
        return newCookies;
    }

    private String retrieveSharelatexCookie(HttpClient httpClient, String loginUrl, String csrfToken, String userRealLogin) throws Exception {
        String commonPwd = this.getGeneratadePassword();
        PostMethod postMethod = new PostMethod(loginUrl);
        postMethod.setParameter(EMAIL_FIELD, userRealLogin);
        postMethod.setParameter(PWD_FIELD, commonPwd);
        postMethod.setParameter(CSRF_TOKEN_FIELD, csrfToken);
        log.info("try to login with user {} and password {}", (Object)userRealLogin, (Object)commonPwd);
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
        }
        catch (Exception e) {
            log.error("error trying to login", (Throwable)e);
            throw new Exception("error trying to login", e);
        }
        log.info("returned status is {}", (Object)postMethod.getStatusText());
        if (postMethod.getStatusCode() != 200) {
            log.error("error on login response: error code is {} ", (Object)postMethod.getStatusCode());
            throw new Exception("error on login response: error code is " + postMethod.getStatusCode());
        }
        log.info("status text on login {} ", (Object)postMethod.getStatusText());
        try {
            log.info("response on login {} ", (Object)postMethod.getResponseBodyAsString());
        }
        catch (IOException e1) {
            log.warn("cannot log response body", (Throwable)e1);
        }
        return postMethod.getResponseHeader("Set-Cookie").getValue();
    }

    private String retrieveCsrfToken(HttpClient httpClient, String loginUrl) throws Exception {
        GetMethod getMethod = new GetMethod(loginUrl);
        httpClient.executeMethod((HttpMethod)getMethod);
        if (getMethod.getStatusCode() == 200) {
            String response = getMethod.getResponseBodyAsString();
            Pattern pattern = Pattern.compile("input name=\"_csrf\" type=\"hidden\" value=\"([^\"]*)\"");
            Matcher matcher = pattern.matcher(response);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new Exception("crsf not fount on the requeste login page");
        }
        throw new Exception("the page " + loginUrl + " in not responding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkUser(String login) {
        String mongoDB = this.context.getInitParameter(MONGO_DATABASE_PARAM);
        BasicDBObject whereQuery = new BasicDBObject();
        whereQuery.put((Object)GCUBE_LOGIN_FIELD, (Object)login);
        log.info("checking for login {} in field {}", (Object)login, (Object)GCUBE_LOGIN_FIELD);
        try (MongoClient client = this.connectToMongo();){
            MongoDatabase db = client.getDatabase(mongoDB);
            MongoCollection collection = db.getCollection(USER_COLLECTION_NAME);
            MongoCursor cursor = collection.find((Bson)whereQuery).iterator();
            if (!cursor.hasNext()) {
                log.info("login {} not found", (Object)login);
                String string = null;
                return string;
            }
            String emailField = (String)((Document)cursor.next()).get((Object)EMAIL_FIELD);
            log.info("login {} found with email field {}", (Object)login, (Object)emailField);
            String string = emailField;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String registerUser() throws Exception {
        User user = this.retrieveUserInfo();
        log.trace("trying to register user {}", (Object)user.toString());
        String login = AuthorizationProvider.instance.get().getClient().getId();
        String commonPwd = this.getGeneratadePassword();
        String salt = BCrypt.gensalt((int)12);
        String hashedPwd = BCrypt.hashpw((String)commonPwd, (String)salt);
        String mongoDB = this.context.getInitParameter(MONGO_DATABASE_PARAM);
        ObjectId userId = new ObjectId();
        try (MongoClient client = this.connectToMongo();){
            MongoDatabase db = client.getDatabase(mongoDB);
            MongoCollection collection = db.getCollection(USER_COLLECTION_NAME);
            String jsonUser = "{ \"betaProgram\" : false, \"subscription\" : { \"hadFreeTrial\" : false }, \"refered_user_count\" : 0, \"refered_users\" : [ ], \"referal_id\" : \"23bbb54a\", \"features\" : { \"references\" : true, \"templates\" : true, \"compileGroup\" : \"standard\", \"compileTimeout\" : 180, \"github\" : false, \"dropbox\" : true, \"versioning\" : true, \"collaborators\" : -1 }, \"ace\" : { \"syntaxValidation\" : true, \"pdfViewer\" : \"pdfjs\", \"spellCheckLanguage\" : \"en\", \"autoComplete\" : true, \"fontSize\" : 12, \"theme\" : \"textmate\", \"mode\" : \"none\" }, \"holdingAccount\" : false, \"loginCount\" : 0, \"signUpDate\" : null, \"confirmed\" : false, \"isAdmin\" : false, \"institution\" : \"\", \"role\" : \"\", \"last_name\" : \"\", \"first_name\" : \"\", \"email\" : \"\", \"__v\" : 1,\"hashedPassword\" : null,\"lastLoggedIn\" : null })";
            Document doc = Document.parse((String)jsonUser);
            doc.put("hashedPassword", (Object)hashedPwd);
            doc.put("_id", (Object)userId);
            Calendar now = Calendar.getInstance();
            SimpleDateFormat sdfLogin = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String loginDate = sdfLogin.format(now.getTime());
            doc.put(SIGNUP_DATE_FIELD, (Object)("ISODate(\"" + loginDate + "\")"));
            doc.put(LAST_LOGGEDIN__FIELD, (Object)("ISODate(\"" + loginDate + "\")"));
            doc.put(EMAIL_FIELD, (Object)user.getEmail());
            doc.put(FIRST_NAME_FIELD, (Object)user.getFirstName());
            doc.put(LAST_NAME__FIELD, (Object)user.getLastName());
            doc.put(GCUBE_LOGIN_FIELD, (Object)login);
            log.debug("inserting doc: {}", (Object)doc.toJson());
            collection.insertOne((Object)doc);
            try {
                ObjectId projectId = new ObjectId();
                ObjectId docId = new ObjectId();
                log.debug("objectID is {}", (Object)userId);
                String projectJson = "{\"deletedDocs\" : [ ], \"description\" : \"\", \"deletedByExternalDataSource\" : false, \"spellCheckLanguage\" : \"en\", \"compiler\" : \"pdflatex\", \"publicAccesLevel\" : \"private\", \"rootFolder\" : [ { \"folders\" : [ ], \"fileRefs\" : [ ], \"docs\" : [ { \"_id\" : ObjectId(\"" + docId + "\"), \"name\" : \"main.tex\" } ], \"name\" : \"rootFolder\" } ], \"readOnly_refs\" : [ ], \"collaberator_refs\" : [ ], \"active\" : true, \"lastUpdated\" : null , \"name\" : \"" + FIRST_PROJECT_NAME + "\", \"__v\" : 0, \"rootDoc_id\" : ObjectId(\"" + docId + "\"), \"lastOpened\" : null, \"archived\" : false }";
                MongoCollection projectCollection = db.getCollection(PROJECTS_COLLECTION_NAME);
                Document project = Document.parse((String)projectJson);
                project.put("_id", (Object)projectId);
                project.put("owner_ref", (Object)userId);
                project.put("lastUpdated", (Object)("ISODate(" + loginDate + ")"));
                project.put("lastOpened", (Object)("ISODate(" + loginDate + ")"));
                projectCollection.insertOne((Object)project);
                MongoCollection docsCollection = db.getCollection(DOCS_COLLECTION_NAME);
                SimpleDateFormat sdfProject = new SimpleDateFormat("MMM yyyy");
                String docsJson = "{ \"lines\" : [ \"\\\\documentclass{article}\", \"\\\\usepackage[utf8]{inputenc}\", \"\", \"\\\\title{" + FIRST_PROJECT_NAME + "}\", \"\", \"\\\\author{" + user.getFirstName() + " " + user.getLastName() + "}\", \"\", \"\\\\date{" + sdfProject.format(now.getTime()) + "}\", \"\", \"\\\\begin{document}\", \"\", \"\\\\maketitle\", \"\", \"\\\\section{Introduction}\", \"\", \"\\\\end{document}\", \"\" ], \"ranges\" : {  }, \"rev\" : 1 }";
                Document docs = Document.parse((String)docsJson);
                docs.put("project_id", (Object)projectId);
                docs.put("_id", (Object)docId);
                docsCollection.insertOne((Object)docs);
            }
            catch (Exception e) {
                log.warn("error creating first project", (Throwable)e);
            }
            String string = user.getEmail();
            return string;
        }
    }

    private User retrieveUserInfo() throws Exception {
        String socialServiceEnpoint = this.retrieveSocialServiceEnpoint();
        String name = "";
        String lastName = "unknown";
        String email = "";
        ObjectMapper mapper = new ObjectMapper();
        HttpClient httpClient = new HttpClient();
        GetMethod getProfile = new GetMethod(socialServiceEnpoint + GET_PROFILE_METHOD + "?gcube-token=" + SecurityTokenProvider.instance.get());
        try {
            httpClient.executeMethod((HttpMethod)getProfile);
            String profile = getProfile.getResponseBodyAsString();
            Map map = new HashMap();
            map = (Map)mapper.readValue(profile, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Map profileMap = (Map)map.get("result");
            name = (String)profileMap.get(FIRST_NAME_FIELD);
            if (profileMap.get(LAST_NAME__FIELD) != null && !((String)profileMap.get(LAST_NAME__FIELD)).isEmpty()) {
                lastName = (String)profileMap.get(LAST_NAME__FIELD);
            }
            email = (String)profileMap.get(EMAIL_FIELD);
            log.trace("found profile {}, {}, {}", new Object[]{name, lastName, email});
            return new User(name, lastName, email);
        }
        catch (Exception e) {
            log.warn("error getting profile from social service", (Throwable)e);
            throw e;
        }
    }

    private boolean sendMessage(String token, String email, String projectName) throws Exception {
        String socialServiceEnpoint = this.retrieveSocialServiceEnpoint();
        PostMethod putMessage = new PostMethod(socialServiceEnpoint + SEND_MESSAGE_METHOD + "?gcube-token=" + token);
        String jsonRequest = String.format("{\"subject\":\"%s\", \"body\":\"%s %s\", \"recipients\":[\"%s\"]}", "sharleatex project invitation", "invitation to project", projectName, email);
        putMessage.setRequestEntity((RequestEntity)new StringRequestEntity(jsonRequest, "application/json", "UTF-8"));
        log.debug("json request is {}", (Object)jsonRequest);
        HttpClient httpClient = new HttpClient();
        int returnedStatus = -1;
        try {
            returnedStatus = httpClient.executeMethod((HttpMethod)putMessage);
            log.info("response from social networking service is {}", (Object)returnedStatus);
            return returnedStatus >= 200 && returnedStatus <= 205;
        }
        catch (Exception e) {
            log.error("error trying to send invitation", (Throwable)e);
            throw new Exception("error trying to send invitation", e);
        }
    }

    private String retrieveSocialServiceEnpoint() throws Exception {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq 'Portal'");
        query.addCondition("$resource/Profile/ServiceName/text() eq 'SocialNetworking'");
        query.addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint");
        query.addCondition("$entry/@EntryName/string() eq 'jersey-servlet'");
        query.setResult("$entry/text()");
        DiscoveryClient client = ICFactory.client();
        List socialServiceEnpoints = client.submit((Query)query);
        if (socialServiceEnpoints.size() == 0) {
            throw new Exception("Social servioce enpooint not found in the current scope " + ScopeProvider.instance.get());
        }
        String socialServiceEnpoint = (String)socialServiceEnpoints.get(0);
        return socialServiceEnpoint + "/2";
    }

    private String getGeneratadePassword() {
        return "gcube_SL_" + Math.abs(AuthorizationProvider.instance.get().getClient().getId().hashCode());
    }

    private MongoClient connectToMongo() {
        String mongoHost = this.context.getInitParameter("mongoHost");
        int mongoPort = Integer.parseInt(this.context.getInitParameter("mongoPort"));
        MongoClient mongoClient = new MongoClient(new ServerAddress(mongoHost, mongoPort));
        return mongoClient;
    }
}

