/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.sharelatex.connector.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.access.sharelatex.connector.User;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.mindrot.jbcrypt.BCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
public class Resource {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    private static final String LOGIN_URL_PARAM = "internalLoginUrl";
    private static final String HOST_NAME_PARAM = "hostName";
    private static final String MONGO_DATABASE_PARAM = "mongoDatabaseName";
    private static final String COLLECTION_NAME = "users";
    private static final String GCUBE_LOGIN_FIELD = "gcube_login";
    private static final String EMAIL_FIELD = "email";
    private static final String SIGNUP_DATE_FIELD = "signUpDate";
    private static final String LAST_LOGGEDIN__FIELD = "lastLoggedIn";
    private static final String LAST_NAME__FIELD = "last_name";
    private static final String FIRST_NAME_FIELD = "first_name";
    private static final String PWD_FIELD = "password";
    private static final String CSRF_TOKEN_FIELD = "_csrf";
    private static final String SHARELATEX_COOKIE_NAME = "sharelatex.sid";
    private static final String USER_ID_COOKIE = "_ga";
    @Context
    ServletContext context;

    @Path(value="connect")
    @GET
    public Response connect(@Context HttpServletRequest request, @Context HttpServletRequest response) {
        try {
            log.info("request for connection ");
            String userRealLogin = this.checkUser();
            if (userRealLogin == null) {
                log.info("trying to register user {}", (Object)AuthorizationProvider.instance.get().getClient().getId());
                userRealLogin = this.registerUser();
            } else {
                log.info("user {} already exists", (Object)AuthorizationProvider.instance.get().getClient().getId());
            }
            return this._connect(userRealLogin, request.isSecure());
        }
        catch (Throwable e) {
            log.error("error trying to connect", e);
            return Response.serverError().build();
        }
    }

    @Path(value="disconnect")
    @GET
    public Response disconnect(@Context HttpServletRequest request, @Context HttpServletRequest response) {
        try {
            log.info("request for disconnection ");
            Cookie[] cookies = request.getCookies();
            NewCookie[] newCookies = new NewCookie[2];
            int index = 0;
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                if (!name.trim().equals(SHARELATEX_COOKIE_NAME) && !name.trim().equals(USER_ID_COOKIE)) continue;
                newCookies[index++] = new NewCookie(name, null, cookie.getPath(), cookie.getDomain(), cookie.getVersion(), cookie.getComment(), 0, cookie.isHttpOnly());
                log.debug("SHARELATEX cookie found");
            }
            return Response.ok((Object)this.context.getClassLoader().getResourceAsStream("logout.html")).cookie(newCookies).build();
        }
        catch (Throwable e) {
            log.error("error disconnecting", e);
            return Response.serverError().build();
        }
    }

    private Response _connect(String userRealLogin, boolean isSecureRequest) {
        String hostName = this.context.getInitParameter(HOST_NAME_PARAM);
        String loginUrl = this.context.getInitParameter(LOGIN_URL_PARAM);
        String setCookies = "";
        HttpClient httpClient = new HttpClient();
        try {
            String csrfToken = this.retrieveCsrfToken(httpClient, loginUrl);
            setCookies = this.retrieveSharelatexCookie(httpClient, loginUrl, csrfToken, userRealLogin);
        }
        catch (Exception e) {
            log.error("cannot retrieve csrf token", (Throwable)e);
            return Response.serverError().build();
        }
        String redirectUrl = "http" + (isSecureRequest ? "s" : "") + "://" + hostName + "/project";
        List newCookies = this.elaborateCookies(setCookies);
        try {
            return Response.seeOther((URI)new URI(redirectUrl)).cookie(newCookies.toArray(new NewCookie[newCookies.size()])).build();
        }
        catch (Exception e) {
            log.error("error trying to login", (Throwable)e);
            return Response.serverError().build();
        }
    }

    private List<NewCookie> elaborateCookies(String setCookies) {
        String[] cookies;
        ArrayList<NewCookie> newCookies = new ArrayList<NewCookie>();
        for (String cookie : cookies = setCookies.split(",", 2)) {
            String[] singleValues = cookie.split(";");
            String[] nameAndValue = singleValues[0].split("=");
            if (!nameAndValue[0].trim().equals(SHARELATEX_COOKIE_NAME)) continue;
            String pathValue = singleValues[1].split("=")[1].trim();
            newCookies.add(new NewCookie(nameAndValue[0].trim(), nameAndValue[1].trim(), pathValue, null, null, -1, false));
        }
        return newCookies;
    }

    private String retrieveSharelatexCookie(HttpClient httpClient, String loginUrl, String csrfToken, String userRealLogin) throws Exception {
        String commonPwd = this.getGeneratadePassword();
        PostMethod postMethod = new PostMethod(loginUrl);
        postMethod.setParameter(EMAIL_FIELD, userRealLogin);
        postMethod.setParameter(PWD_FIELD, commonPwd);
        postMethod.setParameter(CSRF_TOKEN_FIELD, csrfToken);
        log.info("try to login with user {} and password {}", (Object)userRealLogin, (Object)commonPwd);
        try {
            httpClient.executeMethod((HttpMethod)postMethod);
        }
        catch (Exception e) {
            log.error("error trying to login", (Throwable)e);
            throw new Exception("error trying to login", e);
        }
        log.info("returned status is {}", (Object)postMethod.getStatusText());
        if (postMethod.getStatusCode() != 200) {
            log.error("error on login response: error code is {} ", (Object)postMethod.getStatusCode());
            throw new Exception("error on login response: error code is " + postMethod.getStatusCode());
        }
        log.info("status text on login {} ", (Object)postMethod.getStatusText());
        try {
            log.info("response on login {} ", (Object)postMethod.getResponseBodyAsString());
        }
        catch (IOException e1) {
            log.warn("cannot log response body", (Throwable)e1);
        }
        return postMethod.getResponseHeader("Set-Cookie").getValue();
    }

    private String retrieveCsrfToken(HttpClient httpClient, String loginUrl) throws Exception {
        GetMethod getMethod = new GetMethod(loginUrl);
        httpClient.executeMethod((HttpMethod)getMethod);
        if (getMethod.getStatusCode() == 200) {
            String response = getMethod.getResponseBodyAsString();
            Pattern pattern = Pattern.compile("input name=\"_csrf\" type=\"hidden\" value=\"([^\"]*)\"");
            Matcher matcher = pattern.matcher(response);
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new Exception("crsf not fount on the requeste login page");
        }
        throw new Exception("the page " + loginUrl + " in not responding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String checkUser() {
        String mongoDB = this.context.getInitParameter(MONGO_DATABASE_PARAM);
        String login = AuthorizationProvider.instance.get().getClient().getId();
        BasicDBObject whereQuery = new BasicDBObject();
        whereQuery.put((Object)GCUBE_LOGIN_FIELD, (Object)login);
        log.info("checking for login {} in field {}", (Object)login, (Object)GCUBE_LOGIN_FIELD);
        try (MongoClient client = this.connectToMongo();){
            MongoDatabase db = client.getDatabase(mongoDB);
            MongoCollection collection = db.getCollection(COLLECTION_NAME);
            MongoCursor cursor = collection.find((Bson)whereQuery).iterator();
            if (!cursor.hasNext()) {
                log.info("login {} not found", (Object)login);
                String string = null;
                return string;
            }
            String emailField = (String)((Document)cursor.next()).get((Object)EMAIL_FIELD);
            log.info("login {} found with email field {}", (Object)login, (Object)emailField);
            String string = emailField;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String registerUser() throws Exception {
        User user = this.retrieveUserInfo();
        log.trace("trying to register user {}", (Object)user.toString());
        String login = AuthorizationProvider.instance.get().getClient().getId();
        String commonPwd = this.getGeneratadePassword();
        String salt = BCrypt.gensalt((int)12);
        String hashedPwd = BCrypt.hashpw((String)commonPwd, (String)salt);
        String mongoDB = this.context.getInitParameter(MONGO_DATABASE_PARAM);
        try (MongoClient client = this.connectToMongo();){
            MongoDatabase db = client.getDatabase(mongoDB);
            MongoCollection collection = db.getCollection(COLLECTION_NAME);
            String json = "{ \"betaProgram\" : false, \"subscription\" : { \"hadFreeTrial\" : false }, \"refered_user_count\" : 0, \"refered_users\" : [ ], \"referal_id\" : \"23bbb54a\", \"features\" : { \"references\" : true, \"templates\" : true, \"compileGroup\" : \"standard\", \"compileTimeout\" : 180, \"github\" : false, \"dropbox\" : true, \"versioning\" : true, \"collaborators\" : -1 }, \"ace\" : { \"syntaxValidation\" : true, \"pdfViewer\" : \"pdfjs\", \"spellCheckLanguage\" : \"en\", \"autoComplete\" : true, \"fontSize\" : 12, \"theme\" : \"textmate\", \"mode\" : \"none\" }, \"holdingAccount\" : false, \"loginCount\" : 0, \"signUpDate\" : null, \"confirmed\" : false, \"isAdmin\" : false, \"institution\" : \"\", \"role\" : \"\", \"last_name\" : \"\", \"first_name\" : \"\", \"email\" : \"\", \"__v\" : 1,\"hashedPassword\" : null,\"lastLoggedIn\" : null })";
            Document doc = Document.parse((String)json);
            doc.put("hashedPassword", (Object)hashedPwd);
            Calendar now = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            String loginDate = sdf.format(now.getTime());
            doc.put(SIGNUP_DATE_FIELD, (Object)("ISODate(\"" + loginDate + "\")"));
            doc.put(LAST_LOGGEDIN__FIELD, (Object)("ISODate(\"" + loginDate + "\")"));
            doc.put(EMAIL_FIELD, (Object)user.getEmail());
            doc.put(FIRST_NAME_FIELD, (Object)user.getFirstName());
            doc.put(LAST_NAME__FIELD, (Object)user.getLastName());
            doc.put(GCUBE_LOGIN_FIELD, (Object)login);
            log.debug("inserting doc: {}", (Object)doc.toJson());
            collection.insertOne((Object)doc);
            String string = user.getEmail();
            return string;
        }
    }

    private User retrieveUserInfo() throws Exception {
        String socialServiceEnpoint = this.retrieveSocialServiceEnpoint();
        String name = "";
        String lastName = "unknown";
        String email = "";
        ObjectMapper mapper = new ObjectMapper();
        HttpClient httpClient = new HttpClient();
        GetMethod getProfile = new GetMethod(socialServiceEnpoint + "?gcube-token=" + SecurityTokenProvider.instance.get());
        try {
            httpClient.executeMethod((HttpMethod)getProfile);
            String profile = getProfile.getResponseBodyAsString();
            Map map = new HashMap();
            map = (Map)mapper.readValue(profile, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            Map profileMap = (Map)map.get("result");
            name = (String)profileMap.get(FIRST_NAME_FIELD);
            if (profileMap.get(LAST_NAME__FIELD) != null && !((String)profileMap.get(LAST_NAME__FIELD)).isEmpty()) {
                lastName = (String)profileMap.get(LAST_NAME__FIELD);
            }
            email = (String)profileMap.get(EMAIL_FIELD);
            log.trace("found profile {}, {}, {}", new Object[]{name, lastName, email});
            return new User(name, lastName, email);
        }
        catch (Exception e) {
            log.warn("error getting profile from social service", (Throwable)e);
            throw e;
        }
    }

    private String retrieveSocialServiceEnpoint() throws Exception {
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq 'Portal'");
        query.addCondition("$resource/Profile/ServiceName/text() eq 'SocialNetworking'");
        query.addVariable("$entry", "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint");
        query.addCondition("$entry/@EntryName/string() eq 'jersey-servlet'");
        query.setResult("$entry/text()");
        DiscoveryClient client = ICFactory.client();
        List socialServiceEnpoints = client.submit((Query)query);
        if (socialServiceEnpoints.size() == 0) {
            throw new Exception("Social servioce enpooint not found in the current scope " + ScopeProvider.instance.get());
        }
        String socialServiceEnpoint = (String)socialServiceEnpoints.get(0);
        return socialServiceEnpoint + "/2/users/get-profile";
    }

    private String getGeneratadePassword() {
        return "gcube_SL_" + Math.abs(AuthorizationProvider.instance.get().getClient().getId().hashCode());
    }

    private MongoClient connectToMongo() {
        String mongoHost = this.context.getInitParameter("mongoHost");
        int mongoPort = Integer.parseInt(this.context.getInitParameter("mongoPort"));
        MongoClient mongoClient = new MongoClient(new ServerAddress(mongoHost, mongoPort));
        return mongoClient;
    }
}

