/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.httpproxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpMessage;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.gcube.data.access.httpproxy.base.URIModifier;
import org.gcube.data.access.httpproxy.base.URIModifierFactory;
import org.gcube.data.access.httpproxy.utils.LogUtils;
import org.gcube.data.access.httpproxy.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private HttpPost preparePostRequest(URI finalAddress, HttpServletRequest originalpostRequest) throws IOException {
        HttpPost httpPost = new HttpPost(finalAddress);
        String contentType = originalpostRequest.getContentType();
        this.logger.debug("Content type = " + contentType);
        httpPost.setHeader("Content-Type", contentType);
        String accept = originalpostRequest.getHeader("Accept");
        this.logger.debug("Accept = " + accept);
        httpPost.setHeader("Accept", accept);
        String acceptEncoding = originalpostRequest.getHeader("Accept-Encoding");
        this.logger.debug("Accept Encoding = " + acceptEncoding);
        httpPost.setHeader("Accept-Encoding", acceptEncoding);
        String authorization = originalpostRequest.getHeader("Authorization");
        this.logger.debug("Authorization = " + authorization);
        httpPost.setHeader("Authorization", authorization);
        return httpPost;
    }

    private String parseResponseEntity(HttpEntity responseEntity, String responseContentType, HttpServletRequest request) throws UnsupportedOperationException, IOException {
        this.logger.debug("Entity found");
        InputStream in = responseEntity.getContent();
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer, (String)"UTF-8");
        String html = writer.toString();
        writer.close();
        URIModifier uriModifier = URIModifierFactory.getInstance().getUriModifier(responseContentType);
        uriModifier.init(request);
        return uriModifier.modify(html);
    }

    private void printData(HttpServletResponse servletResponse, String responseContentType, String data) throws IOException {
        this.logger.debug("Printing data");
        servletResponse.setContentType(responseContentType);
        PrintWriter out = servletResponse.getWriter();
        out.println(data);
        this.logger.debug("Data printed");
        out.close();
    }

    private void forwardMessage(HttpUriRequest request, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ClientProtocolException, IOException {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = httpClient.execute(request);
        servletResponse.setStatus(response.getStatusLine().getStatusCode());
        String responseContentType = response.getFirstHeader("Content-Type").getValue();
        this.logger.debug("Response Content type = " + responseContentType);
        LogUtils.logHeaders((String)"Server Response", (Logger)this.logger, (HttpMessage)response);
        HttpEntity responseEntity = response.getEntity();
        servletResponse.setContentType(responseContentType);
        if (responseEntity != null) {
            String html = this.parseResponseEntity(responseEntity, responseContentType, servletRequest);
            this.printData(servletResponse, responseContentType, html);
        }
    }

    private void sendErrorMessage(HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html");
        PrintWriter out = resp.getWriter();
        out.println("<h1>Please set a correct address</h1>");
    }

    private void forwardPostRequest(URI finalAddress, HttpServletRequest request, HttpServletResponse servletResponse) throws Exception {
        HttpPost httpPost = this.preparePostRequest(finalAddress, request);
        ServletInputStream requestStream = request.getInputStream();
        if (requestStream != null) {
            this.logger.debug("Adding input stream");
            InputStreamEntity entity = new InputStreamEntity((InputStream)requestStream);
            httpPost.setEntity((HttpEntity)entity);
            this.logger.debug("Input stream added");
        }
        this.forwardMessage((HttpUriRequest)httpPost, request, servletResponse);
        if (requestStream != null) {
            requestStream.close();
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.logger.debug("Forwarding request to the final address");
        String path = req.getPathInfo();
        this.logger.debug("Path = " + path);
        try {
            URI finalAddress = Utils.getAddress((String)path, (ServletRequest)req, (boolean)true);
            this.logger.debug("Final address " + finalAddress);
            this.forwardPostRequest(finalAddress, req, resp);
        }
        catch (URISyntaxException use) {
            this.sendErrorMessage(resp);
        }
        catch (Exception e) {
            this.logger.error("Unable to serve the request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.logger.debug("Forwarding request to the final address");
        String path = req.getPathInfo();
        this.logger.debug("Path = " + path);
        try {
            URI finalAddress = Utils.getAddress((String)path, (ServletRequest)req, (boolean)true);
            this.logger.debug("Final address " + finalAddress);
            HttpGet httpGet = new HttpGet(finalAddress);
            this.forwardMessage((HttpUriRequest)httpGet, req, resp);
        }
        catch (URISyntaxException use) {
            this.sendErrorMessage(resp);
        }
        catch (Exception e) {
            this.logger.error("Unable to serve the request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public static void main(String[] args) throws Exception {
        Header[] headers;
        Logger logger = LoggerFactory.getLogger(ProxyServlet.class);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet("http://www.eng.it");
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        System.out.println("Status = " + response.getStatusLine());
        for (Header header : headers = response.getAllHeaders()) {
            String headerName = header.getName();
            String headerValue = header.getValue();
            logger.debug("Header name " + headerName);
            logger.debug("Header value " + headerValue);
        }
        HttpEntity responseEntity = response.getEntity();
        logger.debug("Entity found");
        InputStream in = responseEntity.getContent();
        List lines = IOUtils.readLines((InputStream)in);
        for (String line : lines) {
            System.out.println(line);
        }
    }
}

