/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.httpproxy.access.handler;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.data.access.httpproxy.access.URLCache;
import org.gcube.data.access.httpproxy.utils.Properties;
import org.gcube.data.access.httpproxy.utils.Utils;
import org.gcube.smartgears.handlers.application.ApplicationHandler;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="domain-filter")
public class DomainFilterRequestHandler
extends RequestHandler {
    public static final String REQUEST_HANDLER_NAME = "domain-filter";
    private boolean enabled;
    private boolean defaultForward;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public DomainFilterRequestHandler() {
        this.enabled = Properties.getInstance().getProperty(Properties.BooleanPropertyType.DOMANI_FILTER_ENABLED);
        this.defaultForward = Properties.getInstance().getProperty(Properties.BooleanPropertyType.DOMANI_FILTER_DEFAULT_FORWARD);
    }

    public String getName() {
        return REQUEST_HANDLER_NAME;
    }

    public void handleRequest(RequestEvent e) {
        block8: {
            this.logger.debug("Handling request");
            if (this.enabled) {
                HttpServletRequest request = e.request();
                String path = request.getPathInfo();
                try {
                    URI address = Utils.getAddress((String)path, (ServletRequest)request, (boolean)false);
                    this.logger.debug("Loading domain list");
                    String scope = ScopeProvider.instance.get();
                    List domains = URLCache.getInstance().getDomainList(scope);
                    this.logger.debug("Using domain list " + domains);
                    if (domains.size() == 0 && this.defaultForward) {
                        this.logger.debug("No domains found: forward");
                        break block8;
                    }
                    boolean found = false;
                    Iterator domainsIterator = domains.iterator();
                    while (domainsIterator.hasNext() && !found) {
                        String domain = ((String)domainsIterator.next()).trim().toLowerCase();
                        if (!domain.startsWith("http")) {
                            domain = "http://" + domain;
                        }
                        this.logger.debug("Domain " + domain);
                        if (!address.toString().startsWith(domain)) continue;
                        found = true;
                    }
                    if (found) {
                        this.logger.debug("Domain accepted");
                        break block8;
                    }
                    this.logger.debug("Domain refused");
                    RequestError.invalid_request_error.fire("Target address not present among allowed domains");
                }
                catch (URISyntaxException use) {
                    this.logger.error("Address not found or invalid", (Throwable)use);
                }
            } else {
                this.logger.debug("Filter not enabled");
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public static void main(String[] args) throws IOException {
        String PREFIX = "META-INF/services/";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String fullName = PREFIX + ApplicationHandler.class.getName();
        Enumeration<URL> urls = cl.getResources(fullName);
        System.out.println(urls.nextElement());
    }
}

