/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.httpproxy.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static Logger logger = LoggerFactory.getLogger(Utils.class);

    public static URI getAddress(String path, ServletRequest req, boolean setParameters) throws URISyntaxException {
        URIBuilder responseBuilder;
        URI response = null;
        logger.debug("Path = " + path);
        if (path != null) {
            responseBuilder = new URIBuilder(Utils.formatPathString((String)path));
            if (setParameters) {
                Map parameters = req.getParameterMap();
                for (String name : parameters.keySet()) {
                    logger.debug("Parameter name = " + name);
                    String[] values = (String[])parameters.get(name);
                    if (values != null && values.length > 0) {
                        for (String value : values) {
                            logger.debug("Value = " + value);
                            responseBuilder.addParameter(name, value);
                        }
                        continue;
                    }
                    logger.debug("Invalid parameter");
                }
            }
        } else {
            throw new URISyntaxException("NULL", "Invalid path");
        }
        response = responseBuilder.build();
        logger.debug("Final address " + response);
        logger.debug("Final address " + response);
        return response;
    }

    private static String formatPathString(String pathString) throws URISyntaxException {
        while (pathString.startsWith("/") && pathString.length() > 1) {
            pathString = pathString.substring(1);
        }
        if (pathString.startsWith("https")) {
            throw new URISyntaxException("https", "https schema not accepted");
        }
        if (!pathString.startsWith("http://")) {
            pathString = "http://" + pathString;
        }
        return pathString;
    }

    public static String getBaseUrl(HttpServletRequest request) {
        StringBuffer requestUrl = request.getRequestURL();
        if (requestUrl.indexOf("http://") == 0) {
            requestUrl.replace(0, 7, "https://");
        }
        String pathInfo = request.getPathInfo();
        logger.debug("Request URL " + requestUrl);
        logger.debug("Path info = " + pathInfo);
        StringBuilder baseURLBuilder = new StringBuilder();
        if (pathInfo != null) {
            int pathIndex = requestUrl.indexOf(pathInfo);
            String basePath = Utils.getBasePath((String)pathInfo);
            logger.debug("Base path " + basePath);
            baseURLBuilder.append(requestUrl.delete(pathIndex, requestUrl.length())).append('/').append(basePath);
        } else {
            baseURLBuilder.append(requestUrl);
        }
        logger.debug("Base URL " + baseURLBuilder);
        return baseURLBuilder.toString();
    }

    private static String getBasePath(String pathInfo) {
        StringBuilder finalAddressBuilder = new StringBuilder(pathInfo);
        finalAddressBuilder.deleteCharAt(0);
        if (finalAddressBuilder.indexOf("http://") == 0) {
            finalAddressBuilder.delete(0, 7);
        }
        int baseUrlSeparator = finalAddressBuilder.indexOf("/");
        String basePath = finalAddressBuilder.toString();
        if (baseUrlSeparator != -1) {
            basePath = finalAddressBuilder.delete(baseUrlSeparator, finalAddressBuilder.length()).toString();
        }
        return basePath;
    }

    public static String getBasePath(HttpServletRequest request) {
        return Utils.getBasePath((String)request.getPathInfo());
    }

    public static String getCompletePath(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        String basePath = null;
        if (pathInfo != null) {
            basePath = Utils.getBasePath((String)pathInfo);
        }
        String servletPath = request.getServletPath();
        String contextPath = request.getContextPath();
        logger.debug("Context  = " + contextPath);
        logger.debug("Servlet Path info = " + servletPath);
        logger.debug("Path info = " + basePath);
        return contextPath + servletPath + "/" + basePath;
    }

    public static void main(String[] args) throws URISyntaxException {
        URIBuilder builder = new URIBuilder("https://portlet-proxy-d-d4s.d4science.org/httpproxy/proxy/narra.isti.cnr.it/timeline/narra.js");
        builder.addParameter("prova", "prova1");
        builder.addParameter("prova", "prova2");
        System.out.println(builder.build());
    }
}

