/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetChildrenById
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetChildrenById.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String id = request.getParameter("id");
        Boolean showHidden = Boolean.parseBoolean(request.getParameter("showHidden"));
        int limit = 0;
        int offset = 0;
        try {
            limit = Integer.parseInt(request.getParameter("limit"));
        }
        catch (Exception e) {
            logger.info("Limit not set");
        }
        try {
            offset = Integer.parseInt(request.getParameter("offset"));
        }
        catch (Exception e) {
            logger.info("Offset not set");
        }
        logger.info("Servlet GetChildrenById called with parameters: [id: " + id + " - limit: " + limit + " - offset: " + offset + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            List children = this.getChildren(session, id, sessionManager.getLogin(request), showHidden, limit, offset);
            xmlConfig = xstream.toXML((Object)children);
            out.println(xmlConfig);
        }
        catch (Exception e) {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            throw new ServletException((Throwable)e);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private List<ItemDelegate> getChildren(Session session, String id, String login, Boolean showHidden, int limit, int offset) throws Exception {
        Node folderNode = session.getNodeByIdentifier(id);
        int i = 0;
        int count = 0;
        NodeIterator iterator = folderNode.getNodes();
        if (limit < 1) {
            limit = (int)iterator.getSize();
        }
        ArrayList<ItemDelegate> children = new ArrayList<ItemDelegate>();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            Boolean isHidden = false;
            try {
                if (node.hasProperty(NodeProperty.HIDDEN.toString())) {
                    isHidden = node.getProperty(NodeProperty.HIDDEN.toString()).getBoolean();
                }
                String path = node.getPath();
                String name = path.substring(path.lastIndexOf(47) + 1);
                if (isHidden.booleanValue() && !showHidden.booleanValue() || name.startsWith("rep:") || name.startsWith("hl:")) continue;
                if (count > limit - 1) break;
                if (i < offset) {
                    ++i;
                    continue;
                }
                ++i;
                ++count;
                ItemDelegate item = null;
                NodeManager wrap = new NodeManager(node, login);
                item = wrap.getItemDelegate();
                children.add(item);
            }
            catch (Exception e) {
                logger.error("Problem getting children for node ID " + id + ": ", (Object)e.getMessage());
            }
        }
        return children;
    }
}

