/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.j2ee.workspacemanager.storage.GCUBEStorage;
import org.apache.jackrabbit.j2ee.workspacemanager.util.MetaInfo;
import org.apache.jackrabbit.j2ee.workspacemanager.util.MultipleOutputStream;
import org.apache.jackrabbit.j2ee.workspacemanager.util.Util;
import org.gcube.contentmanagement.blobstorage.transport.backend.RemoteBackendException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Util {
    private static Logger logger = LoggerFactory.getLogger(GCUBEStorage.class);

    public static MetaInfo getMetadataInfo(InputStream stream, GCUBEStorage storage, String remotePath, String filenameWithExtension) throws Exception {
        MultipleOutputStream mos = new MultipleOutputStream(stream);
        MetaInfo metadataInfo = new MetaInfo();
        1 t1 = new /* Unavailable Anonymous Inner Class!! */;
        2 t2 = new /* Unavailable Anonymous Inner Class!! */;
        t1.start();
        t2.start();
        try {
            mos.startWriting();
            t1.join();
            t2.join();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        Util.updateMimeTypeIntoStorage((GCUBEStorage)storage, (MetaInfo)metadataInfo, (String)remotePath, (String)filenameWithExtension);
        return metadataInfo;
    }

    public static MetaInfo getMetadataInfo(InputStream stream, GCUBEStorage storage, String remotePath, String filenameWithExtension, String mimeType, long size) throws Exception {
        if (mimeType != null && !mimeType.isEmpty()) {
            MetaInfo metadataInfo = new MetaInfo();
            metadataInfo.setMimeType(mimeType);
            metadataInfo.setSize((int)size);
            logger.debug("Save file to Storage in remotepath " + remotePath);
            Util.saveToStorage((InputStream)stream, (GCUBEStorage)storage, (String)remotePath, (MetaInfo)metadataInfo, (String)filenameWithExtension);
            logger.info("Set Mimetype for file " + filenameWithExtension + " to " + mimeType);
            if (mimeType == null || mimeType.isEmpty()) {
                Util.updateMimeTypeIntoStorage((GCUBEStorage)storage, (MetaInfo)metadataInfo, (String)remotePath, (String)filenameWithExtension);
            }
            return metadataInfo;
        }
        return Util.getMetadataInfo((InputStream)stream, (GCUBEStorage)storage, (String)remotePath, (String)filenameWithExtension);
    }

    private static void saveToStorage(InputStream is, GCUBEStorage storage, String remotePath, MetaInfo metadataInfo, String filenameWithExtension) throws IOException {
        long start = System.currentTimeMillis();
        String url = null;
        int availableSize = is.available();
        try {
            url = metadataInfo.getMimeType() != null ? storage.putStream(is, remotePath, metadataInfo.getMimeType()) : storage.putStream(is, remotePath);
            metadataInfo.setStorageId(url);
            metadataInfo.setRemotePath(remotePath);
            logger.info(String.valueOf(filenameWithExtension) + " saved to " + remotePath + " - GCUBEStorage URL : " + url);
            long start00 = System.currentTimeMillis();
            if (metadataInfo.getSize() <= 0) {
                long size = storage.getRemoteFileSize(remotePath);
                if (size < (long)availableSize) {
                    logger.error("size < available for file " + remotePath);
                } else {
                    metadataInfo.setSize((int)size);
                }
            }
        }
        catch (RemoteBackendException e) {
            logger.error(String.valueOf(remotePath) + " remote path not present " + (Object)((Object)e));
            throw new RemoteBackendException(e.getMessage());
        }
    }

    private static void updateMimeTypeIntoStorage(GCUBEStorage storage, MetaInfo metadataInfo, String remotePath, String filenameWithExtension) {
        long start = System.currentTimeMillis();
        if (metadataInfo.getStorageId() != null && metadataInfo.getMimeType() != null) {
            logger.info("Update mimetype metadata for remotepath: " + remotePath + " to " + metadataInfo.getMimeType());
            storage.setMetaInfo("mimetype", metadataInfo.getMimeType(), remotePath);
        }
        logger.info("UPDATE Mimetype into storage for file " + filenameWithExtension + " in milliseconds: " + (System.currentTimeMillis() - start));
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }

    static /* synthetic */ void access$1(InputStream inputStream, GCUBEStorage gCUBEStorage, String string, MetaInfo metaInfo, String string2) throws IOException {
        Util.saveToStorage((InputStream)inputStream, (GCUBEStorage)gCUBEStorage, (String)string, (MetaInfo)metaInfo, (String)string2);
    }
}

