/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest.Utils;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Delete
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(Delete.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String path = request.getParameter("absPath");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                exist = sessionManager.sessionExists(sessionId);
                if (exist) {
                    session = sessionManager.getSession(sessionId);
                } else {
                    session = sessionManager.newSession(request);
                    sessionId = session.toString();
                }
                Boolean flag = false;
                try {
                    Workspace workspace = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
                    path = Utils.cleanPath((Workspace)workspace, (String)path);
                    WorkspaceItem item = workspace.getItemByPath(path);
                    item.remove();
                    flag = true;
                    xmlConfig = xstream.toXML((Object)flag);
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                }
                catch (Exception e) {
                    logger.error("Error deleting item: " + path, (Throwable)e);
                    xmlConfig = xstream.toXML((Object)e.toString());
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!exist) {
                    sessionManager.releaseSession(sessionId);
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }
}

