/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.post;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateReference
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CreateReference.class);
    private static final long serialVersionUID = 1L;
    String login;
    String sessionId;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        this.sessionId = request.getParameter("uuid");
        String srcID = request.getParameter("srcId");
        String destID = request.getParameter("destId");
        logger.info("Servlet CreateReference called with parameters: [srcID: " + srcID + " - destID: " + destID + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                exist = sessionManager.sessionExists(this.sessionId);
                if (exist) {
                    session = sessionManager.getSession(this.sessionId);
                } else {
                    session = sessionManager.newSession(request);
                    this.sessionId = session.toString();
                }
                ItemDelegate new_item = this.createReference(session, srcID, destID);
                xmlConfig = xstream.toXML((Object)new_item);
                out.println(xmlConfig);
            }
            catch (Exception e) {
                if (!exist) {
                    sessionManager.releaseSession(this.sessionId);
                }
                response.sendError(500, e.getMessage());
                if (!exist) {
                    sessionManager.releaseSession(this.sessionId);
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(this.sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private ItemDelegate createReference(Session session, String srcID, String destID) throws RepositoryException {
        ItemDelegate item = null;
        Node srcNode = null;
        Node destNode = null;
        try {
            srcNode = session.getNodeByIdentifier(srcID);
            srcNode.addMixin("mix:referenceable");
            destNode = session.getNodeByIdentifier(destID);
            Node link = destNode.addNode(srcID, "nthl:workspaceReference");
            link.setProperty(NodeProperty.REFERENCE.toString(), srcNode);
            link.setProperty(NodeProperty.PORTAL_LOGIN.toString(), this.login);
            link.setProperty(NodeProperty.TITLE.toString(), srcNode.getName());
            link.setProperty(NodeProperty.LAST_ACTION.toString(), WorkspaceItemAction.CREATED.toString());
            session.save();
            logger.info("References to " + srcNode.getPath() + ":");
            for (Property reference : JcrUtils.getReferences((Node)srcNode)) {
                logger.info("- " + reference.getPath().replace(NodeProperty.REFERENCE.toString(), ""));
            }
            NodeManager wrap = new NodeManager(link, this.login);
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            throw new RepositoryException("Error creating an internal link of node " + srcNode.getPath() + " : " + e.getMessage());
        }
        return item;
    }
}

