/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUsersServlet
extends HttpServlet {
    public static final String USER_NAME = "userName";
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(ListUsersServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("Servlet ListUsersServlet called ......");
        ArrayList<String> users = null;
        String message = "";
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        String user = request.getSession().getServletContext().getInitParameter("user");
        char[] pass = request.getSession().getServletContext().getInitParameter("pass").toCharArray();
        try {
            try {
                session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(user, pass));
                UserManager userManager = session.getUserManager();
                users = new ArrayList<String>();
                Iterator iter = userManager.findAuthorizables("jcr:primaryType", "rep:User");
                while (iter.hasNext()) {
                    Authorizable auth = (Authorizable)iter.next();
                    if (auth.isGroup()) continue;
                    users.add(auth.getID());
                }
                if (!userManager.isAutoSave()) {
                    session.save();
                }
                XStream xstream = new XStream();
                String xmlConfig = xstream.toXML(users);
                out.println(xmlConfig);
            }
            catch (RepositoryException e) {
                message = e.getMessage();
                response.setContentLength(message.length());
                out.println(message);
                if (session != null) {
                    session.logout();
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }
}

