/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateUserServlet
extends HttpServlet {
    public static final String USER_NAME = "userName";
    public static final String PASS = "pwd";
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(CreateUserServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("Servlet CreateUserServlet called ......");
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        boolean modified = false;
        XStream xstream = null;
        String xmlConfig = null;
        String adminId = request.getSession().getServletContext().getInitParameter("user");
        char[] adminPass = request.getSession().getServletContext().getInitParameter("pass").toCharArray();
        try {
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(adminId, adminPass));
            String userName = request.getParameter(USER_NAME);
            String pass = request.getParameter(PASS);
            xstream = new XStream();
            UserManager userManager = session.getUserManager();
            try {
                userManager.createUser(userName, pass);
            }
            catch (Exception e) {
                this.logger.error("Error creating user " + userName + ", " + e);
            }
            session.save();
            modified = true;
            xmlConfig = xstream.toXML((Object)modified);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (RepositoryException e) {
            modified = false;
            xmlConfig = xstream.toXML((Object)modified);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }
}

