/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.post;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.ItemDelegateWrapper;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveItem
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(SaveItem.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            ItemDelegate item = null;
            try {
                item = (ItemDelegate)xstream.fromXML((InputStream)request.getInputStream());
                logger.info("Servlet SaveItem called with parameters: [itemName: " + item.getName() + " - by: " + sessionManager.getLogin() + "]");
                ItemDelegateWrapper wrapper = new ItemDelegateWrapper(item, "");
                ItemDelegate new_item = wrapper.save(session);
                xmlConfig = xstream.toXML((Object)new_item);
                out.println(xmlConfig);
            }
            catch (LockException e) {
                logger.error("Error saving item with id: " + item.getId(), (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Error saving item with id: " + item.getId(), (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error repository ex " + e.getMessage());
            xmlConfig = xstream.toXML((Object)e.toString());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }
}

