/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.post;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyContent
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(CopyContent.class);
    private static final long serialVersionUID = 1L;

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        String srcAbsPath = new String(request.getParameter("srcAbsPath").getBytes("iso-8859-1"), "UTF-8");
        String destAbsPath = new String(request.getParameter("destAbsPath").getBytes("iso-8859-1"), "UTF-8");
        logger.info("Servlet CopyContent called with parameters: [srcAbsPath11: " + srcAbsPath + " - destAbsPath11: " + destAbsPath + "]");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                exist = sessionManager.sessionExists(sessionId);
                if (exist) {
                    session = sessionManager.getSession(sessionId);
                } else {
                    session = sessionManager.newSession(login, user, pass);
                    sessionId = session.toString();
                }
                ItemDelegate new_item = this.copyContetItem(session, srcAbsPath, destAbsPath, login);
                xmlConfig = xstream.toXML((Object)new_item);
                out.println(xmlConfig);
            }
            catch (Exception e) {
                if (!exist) {
                    sessionManager.releaseSession(sessionId);
                }
                throw new ServletException((Throwable)e);
            }
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    private ItemDelegate copyContetItem(SessionImpl session, String srcId, String destId, String login) throws Exception {
        Node nodeFolder = session.getNodeByIdentifier(destId);
        Node sharedNode = session.getNodeByIdentifier(srcId);
        ItemDelegate item = null;
        NodeIterator iterator = sharedNode.getNodes();
        while (iterator.hasNext()) {
            Node child = (Node)iterator.next();
            if (child.getName().startsWith("hl:") || child.getName().startsWith("jcr:") || child.getName().startsWith("rep:")) continue;
            session.getWorkspace().copy(child.getPath(), String.valueOf(nodeFolder.getPath()) + "/" + child.getName());
        }
        NodeManager wrap = new NodeManager(nodeFolder, login);
        item = wrap.getItemDelegate();
        return item;
    }
}

