/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetChildrenById
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetChildrenById.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        String id = request.getParameter("id");
        Boolean showHidden = Boolean.parseBoolean(request.getParameter("showHidden"));
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                exist = sessionManager.sessionExists(sessionId);
                if (exist) {
                    session = sessionManager.getSession(sessionId);
                } else {
                    session = sessionManager.newSession(login, user, pass);
                    sessionId = session.toString();
                }
                try {
                    logger.info("Servlet GetChildrenById called with parameters: [id: " + id + "]");
                    List children = this.getChildren(session, id, login, showHidden);
                    xmlConfig = xstream.toXML((Object)children);
                    out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
                    out.println(xmlConfig);
                }
                catch (Exception e) {
                    logger.error("Error getting children by id: " + id, (Throwable)e);
                    xmlConfig = xstream.toXML((Object)e.toString());
                    out.println(xmlConfig);
                }
            }
            catch (Exception e) {
                logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.toString());
                out.println(xmlConfig);
                out.close();
                if (!exist) {
                    sessionManager.releaseSession(sessionId);
                }
            }
        }
        finally {
            out.close();
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
        }
    }

    private List<ItemDelegate> getChildren(SessionImpl session, String identifier, String login, Boolean showHidden) throws Exception {
        Node folderNode = session.getNodeByIdentifier(identifier);
        NodeIterator iterator = folderNode.getNodes();
        ArrayList<ItemDelegate> children = new ArrayList<ItemDelegate>();
        while (iterator.hasNext()) {
            Node node = iterator.nextNode();
            Boolean isHidden = false;
            if (node.hasProperty(NodeProperty.HIDDEN.toString())) {
                isHidden = node.getProperty(NodeProperty.HIDDEN.toString()).getBoolean();
            }
            String path = null;
            try {
                path = node.getPath();
                String name = path.substring(path.lastIndexOf(47) + 1);
                if (isHidden.booleanValue() && !showHidden.booleanValue() || name.equals("Trash") || name.equals("MySpecialFolders") || name.startsWith("rep:") || name.startsWith("hl:") || name.startsWith(".")) {
                    continue;
                }
            }
            catch (RepositoryException e1) {
                e1.printStackTrace();
            }
            ItemDelegate item = null;
            NodeManager wrap = new NodeManager(node, login);
            try {
                item = wrap.getItemDelegate();
                children.add(item);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return children;
    }
}

