/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.accessmanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.accessmanager.AccessControlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteAcesServlet
extends HttpServlet {
    public static final String ABS_PATH = "absPath";
    public static final String APPLY_TO = "applyTo";
    private Logger logger = LoggerFactory.getLogger(DeleteAcesServlet.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block16: {
            this.logger.info("Servlet Delete Aces called ......");
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
            SessionImpl session = null;
            XStream xstream = null;
            String xmlConfig = null;
            boolean modified = false;
            String absPath = null;
            String[] applyTo = null;
            try {
                try {
                    xstream = new XStream();
                    session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
                    absPath = new String(request.getParameter(ABS_PATH).getBytes("iso-8859-1"), "UTF-8");
                    applyTo = request.getParameterValues(APPLY_TO);
                    try {
                        modified = this.deleteAces(session, absPath, applyTo);
                    }
                    catch (RepositoryException e) {
                        this.logger.error("ACL not found");
                    }
                    xmlConfig = xstream.toXML((Object)modified);
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                }
                catch (RepositoryException e) {
                    xmlConfig = xstream.toXML((Object)modified);
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                    if (session != null) {
                        session.logout();
                    }
                    out.close();
                    out.flush();
                    if (modified) {
                        this.logger.info("removed privilege to node " + absPath);
                    } else {
                        this.logger.info("cannot remove privilege to node " + absPath);
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (session != null) {
                    session.logout();
                }
                out.close();
                out.flush();
                if (modified) {
                    this.logger.info("removed privilege to node " + absPath);
                } else {
                    this.logger.info("cannot remove privilege to node " + absPath);
                }
                throw throwable;
            }
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
            if (modified) {
                this.logger.info("removed privilege to node " + absPath);
            } else {
                this.logger.info("cannot remove privilege to node " + absPath);
            }
        }
    }

    private boolean deleteAces(SessionImpl jcrSession, String resourcePath, String[] principalNamesToDelete) throws RepositoryException {
        if (principalNamesToDelete == null) {
            return false;
        }
        if (jcrSession == null) {
            return false;
        }
        if (resourcePath == null) {
            return false;
        }
        Item item = jcrSession.getItem(resourcePath);
        if (item == null) {
            return false;
        }
        resourcePath = item.getPath();
        HashSet<String> pidSet = new HashSet<String>();
        pidSet.addAll(Arrays.asList(principalNamesToDelete));
        try {
            AccessControlManager accessControlManager = AccessControlUtil.getAccessControlManager((Session)jcrSession);
            AccessControlList updatedAcl = this.getAccessControlList(accessControlManager, resourcePath, false);
            AccessControlEntry[] accessControlEntries = updatedAcl.getAccessControlEntries();
            ArrayList<AccessControlEntry> oldAces = new ArrayList<AccessControlEntry>();
            AccessControlEntry[] accessControlEntryArray = accessControlEntries;
            int n = accessControlEntries.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlEntry ace = accessControlEntryArray[n2];
                if (pidSet.contains(ace.getPrincipal().getName())) {
                    oldAces.add(ace);
                }
                ++n2;
            }
            if (!oldAces.isEmpty()) {
                for (AccessControlEntry ace : oldAces) {
                    updatedAcl.removeAccessControlEntry(ace);
                }
            }
            accessControlManager.setPolicy(resourcePath, (AccessControlPolicy)updatedAcl);
            jcrSession.save();
        }
        catch (RepositoryException re) {
            re.printStackTrace();
            return false;
        }
        return true;
    }

    protected AccessControlList getAccessControlList(AccessControlManager accessControlManager, String resourcePath, boolean mayCreate) throws RepositoryException {
        AccessControlPolicy[] policies;
        AccessControlPolicy[] accessControlPolicyArray = policies = accessControlManager.getPolicies(resourcePath);
        int n = policies.length;
        int n2 = 0;
        while (n2 < n) {
            AccessControlPolicy policy = accessControlPolicyArray[n2];
            if (policy instanceof AccessControlList) {
                return (AccessControlList)policy;
            }
            ++n2;
        }
        if (mayCreate) {
            AccessControlPolicyIterator applicablePolicies = accessControlManager.getApplicablePolicies(resourcePath);
            while (applicablePolicies.hasNext()) {
                AccessControlPolicy policy = applicablePolicies.nextAccessControlPolicy();
                if (!(policy instanceof AccessControlList)) continue;
                return (AccessControlList)policy;
            }
        }
        throw new RepositoryException("Unable to find or create an access control policy to update for " + resourcePath);
    }
}

