/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.acl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.j2ee.accessmanager.AccessControlUtil;
import org.gcube.common.homelibary.model.acl.AccessRights;
import org.gcube.common.homelibary.model.items.type.NodeProperty;

public class JCRAccessControlManager {
    public static final String WRITE_ALL = "hl:writeAll";
    public static final String ADMINISTRATOR = "jcr:all";
    public static final String READ_ONLY = "jcr:read";
    public static final String WRITE_OWNER = "jcr:write";
    private Session session;
    private String login;

    public JCRAccessControlManager(Session session, String login) {
        this.session = session;
        this.login = login;
    }

    public Map<String, List<String>> getACL(String absPath) throws Exception {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Map acl = AccessControlUtil.getACL((String)absPath, (Session)this.session);
        Set keys = acl.keySet();
        for (String principal : keys) {
            if (((AccessRights)acl.get(principal)).getGranted().isEmpty()) continue;
            map.put(principal, ((AccessRights)acl.get(principal)).getGranted());
        }
        return map;
    }

    private String getOwner(Node node) throws PathNotFoundException, RepositoryException {
        String portalLogin;
        try {
            portalLogin = node.getProperty(NodeProperty.PORTAL_LOGIN.toString()).getString();
        }
        catch (Exception e) {
            Node nodeOwner = node.getNode(NodeProperty.OWNER.toString());
            portalLogin = nodeOwner.getProperty(NodeProperty.PORTAL_LOGIN.toString()).getString();
        }
        return portalLogin;
    }

    public Map<String, List<String>> getDeniedMap(String absPath) throws Exception {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Map acl = AccessControlUtil.getACL((String)absPath, (Session)this.session);
        Set keys = acl.keySet();
        for (String principal : keys) {
            if (((AccessRights)acl.get(principal)).getDenied().isEmpty()) continue;
            map.put(principal, ((AccessRights)acl.get(principal)).getDenied());
        }
        return map;
    }

    public Map<String, List<String>> getEACL(String absPath) throws Exception {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        Map acl = AccessControlUtil.getEACL((String)absPath, (Session)this.session);
        Set keys = acl.keySet();
        for (String principal : keys) {
            if (((AccessRights)acl.get(principal)).getGranted().isEmpty()) continue;
            map.put(principal, ((AccessRights)acl.get(principal)).getGranted());
        }
        return map;
    }

    public boolean canModifyProperties(String login, String absPath, Boolean root) throws Exception {
        try {
            AccessControlManager accessControlManager = this.session.getAccessControlManager();
            boolean canDelete = false;
            canDelete = root != false ? accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties"), accessControlManager.privilegeFromName("hl:noOwnershipLimit"), accessControlManager.privilegeFromName("hl:removeSharedRoot")}) : accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}modifyProperties"), accessControlManager.privilegeFromName("hl:noOwnershipLimit")});
            return canDelete;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canAddChildren(String absPath) throws Exception {
        try {
            AccessControlManager accessControlManager = this.session.getAccessControlManager();
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}addChildNodes")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canDelete(String login, String absPath, boolean isRoot) throws Exception {
        try {
            AccessControlManager accessControlManager = this.session.getAccessControlManager();
            int lastSlash = absPath.lastIndexOf(47);
            String parentPath = lastSlash == 0 ? "/" : absPath.substring(0, lastSlash);
            try {
                accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("hl:noOwnershipLimit"), accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode")});
            }
            catch (Exception e) {
                throw new Exception("Error retrieving privilege: " + e);
            }
            boolean canDelete = false;
            canDelete = isRoot ? accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"), accessControlManager.privilegeFromName("hl:noOwnershipLimit"), accessControlManager.privilegeFromName("hl:removeSharedRoot")}) : accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeNode"), accessControlManager.privilegeFromName("hl:noOwnershipLimit")}) && this.canDeleteChildren(parentPath) != false;
            return canDelete;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public Boolean canDeleteChildren(String absPath) {
        try {
            AccessControlManager accessControlManager = this.session.getAccessControlManager();
            return accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}removeChildNodes"), accessControlManager.privilegeFromName("hl:noOwnershipLimit")});
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean canReadNode(String absPath) throws Exception {
        try {
            AccessControlManager accessControlManager = this.session.getAccessControlManager();
            boolean canRead = accessControlManager.hasPrivileges(absPath, new Privilege[]{accessControlManager.privilegeFromName("{http://www.jcp.org/jcr/1.0}read")});
            return canRead;
        }
        catch (RepositoryException e) {
            return false;
        }
    }
}

