/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceItem;
import org.gcube.common.homelibary.model.items.type.NodeProperty;

public class JCRWorkspaceMessage
extends JCRWorkspaceItem {
    public JCRWorkspaceMessage(Node node, String login) throws RepositoryException {
        super(node, login);
        Map properties = this.item.getProperties();
        properties.put(NodeProperty.SUBJECT, node.getProperty(NodeProperty.SUBJECT.toString()).getString());
        properties.put(NodeProperty.BODY, node.getProperty(NodeProperty.BODY.toString()).getString());
        properties.put(NodeProperty.READ, this.xstream.toXML((Object)node.getProperty(NodeProperty.READ.toString()).getBoolean()));
        properties.put(NodeProperty.OPEN, this.xstream.toXML((Object)node.getProperty(NodeProperty.OPEN.toString()).getBoolean()));
        properties.put(NodeProperty.CREATED, this.xstream.toXML((Object)node.getProperty(NodeProperty.CREATED.toString()).getDate()));
        Node userNode = node.getNode(NodeProperty.OWNER.toString());
        HashMap<NodeProperty, String> user = new HashMap<NodeProperty, String>();
        user.put(NodeProperty.USER_ID, userNode.getProperty(NodeProperty.USER_ID.toString()).getString());
        user.put(NodeProperty.PORTAL_LOGIN, userNode.getProperty(NodeProperty.PORTAL_LOGIN.toString()).getString());
        properties.put(NodeProperty.OWNER, this.xstream.toXML(user));
        LinkedList<String> attachments = new LinkedList<String>();
        Node attachmentsNode = node.getNode(NodeProperty.ATTACHMENTS.toString());
        NodeIterator iterator = attachmentsNode.getNodes();
        while (iterator.hasNext()) {
            attachments.add(iterator.nextNode().getIdentifier());
        }
        properties.put(NodeProperty.ATTACHMENTS_ID, attachmentsNode.getIdentifier());
        properties.put(NodeProperty.ATTACHMENTS, this.xstream.toXML(attachments));
        ArrayList<String> addresses = new ArrayList<String>();
        for (Value address : node.getProperty(NodeProperty.ADDRESSES.toString()).getValues()) {
            addresses.add(address.getString());
        }
        properties.put(NodeProperty.ADDRESSES, this.xstream.toXML(addresses));
    }
}

