/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import java.util.HashMap;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.workspacemanager.Cleaner;
import org.apache.jackrabbit.j2ee.workspacemanager.MySession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private static HashMap<String, MySession> list;
    private static SessionManager sessionManager;
    private static Repository rep;
    private char[] pass = null;
    private String user = null;

    static {
        sessionManager = null;
        rep = null;
    }

    private SessionManager() {
        list = new HashMap();
        Thread thread = new Thread((Runnable)new Cleaner(list));
        thread.start();
    }

    public static synchronized SessionManager getInstance(Repository repository) {
        rep = repository;
        if (sessionManager == null) {
            sessionManager = new SessionManager();
        }
        return sessionManager;
    }

    public synchronized SessionImpl getSession(String sessionId) {
        SessionImpl mySession = null;
        if (list.size() > 0) {
            mySession = ((MySession)list.get(sessionId)).getSession();
        }
        return mySession;
    }

    public synchronized SessionImpl newSession(String login, String myUser, char[] myPass) {
        this.user = myUser;
        this.pass = myPass;
        SessionImpl session = null;
        try {
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(this.user, this.pass));
            list.put(session.toString(), new MySession(login, session));
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
        }
        return session;
    }

    public synchronized void releaseSession(String id) {
        try {
            SessionImpl session = this.getSession(id);
            if (session != null) {
                session.logout();
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
        }
        list.remove(id);
    }

    public boolean sessionExists(String uuid) {
        return list.containsKey(uuid);
    }

    public Set<String> getSessionIds() {
        return list.keySet();
    }
}

