/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import com.thoughtworks.xstream.XStream;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceItem;
import org.gcube.common.homelibary.model.items.type.NodeProperty;

public class JCRWorkspaceTrashItem
extends JCRWorkspaceItem {
    protected static final String CONTENT = "jcr:content";
    protected static final String DELETE_DATE = "hl:deletedTime";
    protected static final String DELETE_BY = "hl:deletedBy";
    protected static final String ORIGINAL_PARENT_ID = "hl:originalParentId";
    protected static final String DELETED_FROM = "hl:deletedFrom";
    protected static final String NAME = "hl:name";
    protected static final String MIME_TYPE = "hl:mimeType";
    protected static final String LENGTH = "hl:length";
    protected static final String IS_FOLDER = "hl:isFolder";

    public JCRWorkspaceTrashItem(Node node, String login) throws RepositoryException {
        super(node, login);
        Map map = this.item.getProperties();
        try {
            map.put(NodeProperty.TRASH_ITEM_NAME, node.getProperty(NAME).getString());
            map.put(NodeProperty.DELETE_DATE, new XStream().toXML((Object)node.getProperty(DELETE_DATE).getDate()));
            map.put(NodeProperty.DELETE_BY, node.getProperty(DELETE_BY).getString());
            map.put(NodeProperty.DELETED_FROM, node.getProperty(DELETED_FROM).getString());
            map.put(NodeProperty.ORIGINAL_PARENT_ID, node.getProperty(ORIGINAL_PARENT_ID).getString());
            map.put(NodeProperty.IS_FOLDER, new XStream().toXML((Object)node.getProperty(IS_FOLDER).getBoolean()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            map.put(NodeProperty.TRASH_ITEM_MIME_TYPE, node.getProperty(MIME_TYPE).getString());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            map.put(NodeProperty.LENGTH, new XStream().toXML((Object)node.getProperty(LENGTH).getLong()));
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

