/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.search;

import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;

public class JCRSearchFolder {
    private static final String ROOT = "/";
    private static final String SHARED = "nthl:workspaceSharedItem";
    private final String id;
    private Calendar creationDate;
    private Calendar lastModified;
    private String owner;
    private final String type;
    private boolean isVreFolder;
    private boolean isShared;
    private String path;
    private String parentId;
    private String name;
    private String displayName;
    private String primaryType;
    protected SearchItemDelegate item;
    public static final String TITLE = "jcr:title";
    public static final String CREATED = "jcr:created";
    public static final String LAST_MODIFIED = "jcr:lastModified";
    public static final String OWNER = "hl:owner";
    public static final String PORTAL_LOGIN = "hl:portalLogin";
    public static final String IS_VRE_FOLDER = "hl:isVreFolder";
    public static final String DISPLAY_NAME = "hl:displayName";

    public JCRSearchFolder(Node node, String itemName) throws RepositoryException {
        this.id = node.getIdentifier();
        this.parentId = node.getParent().getIdentifier();
        this.path = node.getPath();
        this.primaryType = node.getPrimaryNodeType().getName();
        String[] nameGlobs = new String[]{NodeProperty.CREATED.toString(), NodeProperty.LAST_MODIFIED.toString(), NodeProperty.IS_VRE_FOLDER.toString(), NodeProperty.DISPLAY_NAME.toString(), NodeProperty.PORTAL_LOGIN.toString()};
        PropertyIterator properties = node.getProperties(nameGlobs);
        while (properties.hasNext()) {
            Property propery = properties.nextProperty();
            switch (propery.getName()) {
                case "jcr:created": {
                    this.creationDate = propery.getDate();
                    break;
                }
                case "jcr:lastModified": {
                    this.lastModified = propery.getDate();
                    break;
                }
                case "hl:isVreFolder": {
                    this.isVreFolder = propery.getBoolean();
                    break;
                }
                case "hl:displayName": {
                    this.displayName = propery.getString();
                    break;
                }
                case "hl:portalLogin": {
                    this.owner = propery.getString();
                    break;
                }
            }
        }
        if (this.isVreFolder) {
            try {
                this.name = this.displayName;
            }
            catch (Exception e) {
                this.name = itemName;
            }
        } else {
            this.name = itemName;
        }
        try {
            this.isShared = this.isShared(node);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.type = node.getPrimaryNodeType().getName();
    }

    public WorkspaceItemType getType() {
        if (this.type.equals(SHARED)) {
            return WorkspaceItemType.SHARED_FOLDER;
        }
        return WorkspaceItemType.FOLDER;
    }

    private boolean isShared(Node node) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        return this.getIdSharedFolder(node) != null;
    }

    public String getIdSharedFolder(Node node) throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        if (node.getParent().getPath().equals(ROOT)) {
            return null;
        }
        if (node.getPrimaryNodeType().getName().equals(SHARED)) {
            return node.getIdentifier();
        }
        return this.getIdSharedFolder(node.getParent());
    }

    public SearchItemDelegate getSearchItemDelegate() {
        this.item = new SearchItemDelegate();
        this.item.setCreationTime(this.creationDate);
        this.item.setPrimaryType(this.primaryType);
        this.item.setId(this.id);
        this.item.setLastModificationTime(this.lastModified);
        this.item.setName(this.name);
        this.item.setOwner(this.owner);
        this.item.setParentId(this.parentId);
        this.item.setPath(this.path);
        this.item.setShared(this.isShared);
        this.item.setType(this.getType());
        this.item.setVreFolder(this.isVreFolder);
        return this.item;
    }
}

