/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import com.thoughtworks.xstream.XStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceItem;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWorkspaceMessage
extends JCRWorkspaceItem {
    private static Logger logger = LoggerFactory.getLogger(JCRWorkspaceMessage.class);
    private static final String CREATED = "jcr:created";
    private static final String SUBJECT = "hl:subject";
    private static final String BODY = "hl:body";
    private static final String ATTACHMENTS = "hl:attachments";
    private static final String ADDRESSES = "hl:addresses";
    private static final String TITLE = "jcr:title";
    private static final String OWNER = "hl:owner";
    private static final String SCOPE = "hl:scope";
    private static final String PORTAL_LOGIN = "hl:portalLogin";
    private static final String USER_ID = "hl:uuid";
    private static final String READ = "hl:read";
    private static final String OPEN = "hl:open";
    private static final String NT_USER = "nthl:user";

    public JCRWorkspaceMessage(Node node, String login) throws RepositoryException {
        super(node, login);
        Map properties = this.item.getProperties();
        properties.put(NodeProperty.SUBJECT, node.getProperty(SUBJECT).getString());
        properties.put(NodeProperty.BODY, node.getProperty(BODY).getString());
        properties.put(NodeProperty.READ, new XStream().toXML((Object)node.getProperty(READ).getBoolean()));
        properties.put(NodeProperty.OPEN, new XStream().toXML((Object)node.getProperty(OPEN).getBoolean()));
        properties.put(NodeProperty.CREATED, new XStream().toXML((Object)node.getProperty(CREATED).getDate()));
        Node userNode = node.getNode(OWNER);
        HashMap<NodeProperty, String> user = new HashMap<NodeProperty, String>();
        user.put(NodeProperty.USER_ID, userNode.getProperty(USER_ID).getString());
        user.put(NodeProperty.PORTAL_LOGIN, userNode.getProperty(PORTAL_LOGIN).getString());
        LinkedList<String> attachments = new LinkedList<String>();
        Node attachmentsNode = node.getNode(ATTACHMENTS);
        NodeIterator iterator = attachmentsNode.getNodes();
        while (iterator.hasNext()) {
            attachments.add(iterator.nextNode().getIdentifier());
        }
        properties.put(NodeProperty.ATTACHMENTS, new XStream().toXML(attachments));
        LinkedList<String> addresses = new LinkedList<String>();
        for (Value address : node.getProperty(ADDRESSES).getValues()) {
            addresses.add(address.getString());
        }
        properties.put(NodeProperty.ADDRESSES, new XStream().toXML(addresses));
    }
}

