/**
 * 
 */
package org.apache.jackrabbit.j2ee.workspacemanager.accounting;

import java.util.HashMap;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;

import com.thoughtworks.xstream.XStream;


public class JCRAccountingEntryRenaming extends JCRAccountingEntry {

	
	public JCRAccountingEntryRenaming(Node node) throws RepositoryException {
		super(node);
		
//		item.setEntryType(AccountingEntryType.RENAMING);
		
		String oldItemName = node.getProperty(AccountingProperty.OLD_ITEM_NAME.toString()).getString();	

		HashMap<AccountingProperty, String> map = new HashMap<AccountingProperty, String>();
		map.put(AccountingProperty.OLD_ITEM_NAME, new XStream().toXML(oldItemName));

		item.setAccountingProperties(map);
		
	}
	

}
