/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceFolder;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.model.exceptions.InternalErrorException;

public class JCRWorkspaceSharedFolder
extends JCRWorkspaceFolder {
    public static final String HL_NAMESPACE = "hl:";
    public static final String JCR_NAMESPACE = "jcr:";
    public static final String REP_NAMESPACE = "rep:";
    private static final String NT_NAMESPACE = "nt:";
    private static final String SEPARATOR = "/";

    public JCRWorkspaceSharedFolder(Node node, String login) throws RepositoryException {
        super(node, login);
        Map properties = this.item.getProperties();
        try {
            properties.put(NodeProperty.MEMBERS, new XStream().toXML((Object)this.getMembers(node)));
        }
        catch (InternalErrorException e) {
            logger.info(NodeProperty.MEMBERS + " not present");
        }
        try {
            properties.put(NodeProperty.USERS, new XStream().toXML((Object)this.getUsers(node)));
        }
        catch (Exception e) {
            logger.info(NodeProperty.USERS + " not present");
        }
        if (node.hasProperty(NodeProperty.IS_VRE_FOLDER.toString())) {
            properties.put(NodeProperty.IS_VRE_FOLDER, new XStream().toXML((Object)node.getProperty(NodeProperty.IS_VRE_FOLDER.toString()).getBoolean()));
        }
        if (node.hasProperty(NodeProperty.DISPLAY_NAME.toString())) {
            properties.put(NodeProperty.DISPLAY_NAME, node.getProperty(NodeProperty.DISPLAY_NAME.toString()).getString());
        }
    }

    private Map<String, String> getUsers(Node node) throws InternalErrorException {
        HashMap<String, String> list = new HashMap<String, String>();
        try {
            Node usersNode = node.getNode(NodeProperty.USERS.toString());
            PropertyIterator iterator = usersNode.getProperties();
            while (iterator.hasNext()) {
                Property property = iterator.nextProperty();
                String key = property.getName();
                String value = property.getString();
                if (key.startsWith(JCR_NAMESPACE) || key.startsWith(HL_NAMESPACE) || key.startsWith(NT_NAMESPACE)) continue;
                list.put(key, value);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }

    public List<String> getMembers(Node node) throws InternalErrorException {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Node members = node.getNode(NodeProperty.MEMBERS.toString());
            NodeIterator children = members.getNodes();
            while (children.hasNext()) {
                String name = children.nextNode().getName();
                if (name.startsWith(JCR_NAMESPACE) || name.startsWith(HL_NAMESPACE)) continue;
                list.add(name);
            }
        }
        catch (RepositoryException e) {
            throw new InternalErrorException((Throwable)e);
        }
        return list;
    }
}

