package org.apache.jackrabbit.j2ee.workspacemanager;

import java.util.HashMap;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;


public class JCRWorkspaceFolder extends JCRWorkspaceItem {

	public JCRWorkspaceFolder(Node node, String login) throws RepositoryException {
		super(node, login);
		
		if(node.hasNode(NodeProperty.CONTENT.toString())){
			Node content = (node.getNode(NodeProperty.CONTENT.toString()));
			if(content.getPrimaryNodeType().getName().equals(ContentType.SMART.toString())){
				Map<NodeProperty, String> smartContent = new HashMap<NodeProperty, String>();
				smartContent.put(NodeProperty.QUERY, content.getProperty(NodeProperty.QUERY.toString()).getString());
				item.setContent(smartContent);
			}
		}
	}
}